/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand.registry;

import com.atlassian.fugue.Option;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.OperandHandler;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.plugin.jql.function.JqlFunction;
import com.atlassian.jira.plugin.jql.function.JqlFunctionModuleDescriptor;
import com.atlassian.jira.plugin.util.ModuleDescriptors;
import com.atlassian.jira.util.CaseFolding;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class LazyResettableJqlFunctionHandlerRegistry
implements JqlFunctionHandlerRegistry {
    private static final Logger log = LoggerFactory.getLogger(LazyResettableJqlFunctionHandlerRegistry.class);
    private final PluginAccessor pluginAccesor;
    private final ModuleDescriptors.Orderings moduleDescriptorOrderings;
    private final I18nHelper i18nHelper;
    @ClusterSafe
    private final ResettableLazyReference<Map<String, FunctionOperandHandler>> registryRef = new ResettableLazyReference<Map<String, FunctionOperandHandler>>(){

        protected Map<String, FunctionOperandHandler> create() throws Exception {
            return LazyResettableJqlFunctionHandlerRegistry.this.loadFromJqlFunctionModuleDescriptors();
        }
    };

    LazyResettableJqlFunctionHandlerRegistry(PluginAccessor pluginAccesor, ModuleDescriptors.Orderings moduleDescriptorOrderings, I18nHelper i18nHelper) {
        this.pluginAccesor = pluginAccesor;
        this.moduleDescriptorOrderings = moduleDescriptorOrderings;
        this.i18nHelper = i18nHelper;
    }

    Map<String, FunctionOperandHandler> loadFromJqlFunctionModuleDescriptors() {
        List jqlFunctionModuleDescriptors = this.pluginAccesor.getEnabledModuleDescriptorsByClass(JqlFunctionModuleDescriptor.class);
        List sortedJqlModuleDescriptors = this.moduleDescriptorOrderings.byOrigin().compound(this.moduleDescriptorOrderings.natural()).sortedCopy((Iterable)jqlFunctionModuleDescriptors);
        ConcurrentHashMap<String, FunctionOperandHandler> registry = new ConcurrentHashMap<String, FunctionOperandHandler>();
        for (JqlFunctionModuleDescriptor descriptor : sortedJqlModuleDescriptors) {
            FunctionOperandHandler operandHandler;
            String functionName;
            OperandHandler handler;
            final JqlFunction jqlFunction = (JqlFunction)descriptor.getModule();
            Option functionNameFromPlugin = SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return jqlFunction.getFunctionName();
                }
            });
            if (functionNameFromPlugin.isEmpty() || (handler = (OperandHandler)registry.putIfAbsent(functionName = CaseFolding.foldString((String)((String)functionNameFromPlugin.get())), operandHandler = new FunctionOperandHandler(jqlFunction, this.i18nHelper))) == null) continue;
            log.error(String.format("Plugin '%s' defined a function with the name: '%s' but one with that name already exists.", descriptor.getPlugin().getName(), functionName));
        }
        return registry;
    }

    void reset() {
        this.registryRef.reset();
    }

    @Override
    public FunctionOperandHandler getOperandHandler(FunctionOperand operand) {
        Assertions.notNull((String)"operand", (Object)operand);
        Map registry = (Map)this.registryRef.get();
        FunctionOperandHandler handler = (FunctionOperandHandler)registry.get(CaseFolding.foldString((String)operand.getName()));
        if (handler == null && log.isDebugEnabled()) {
            log.debug("Unable to find handler for function '" + operand.getName() + "'.");
        }
        return handler;
    }

    @Override
    public List<String> getAllFunctionNames() {
        Collection functionOperandHandlers = ((Map)this.registryRef.get()).values();
        ArrayList<String> functionNames = new ArrayList<String>(functionOperandHandlers.size());
        for (final FunctionOperandHandler functionOperandHandler : functionOperandHandlers) {
            CollectionUtils.addIgnoreNull(functionNames, (Object)SafePluginPointAccess.call((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return functionOperandHandler.getJqlFunction().getFunctionName();
                }
            }).getOrNull());
        }
        Collections.sort(functionNames);
        return functionNames;
    }
}

