/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.util.IssueIdsIssueIterable;
import com.atlassian.jira.jql.query.IssueIdCollector;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IssueIdCollectorIterable
extends IssueIdsIssueIterable {
    public IssueIdCollectorIterable(@Nonnull IssueIdCollector collector, @Nonnull IssueManager issueManager) throws IOException {
        super(IssueIdCollectorIterable.readIssueIds(collector), issueManager);
    }

    @Nonnull
    private static Collection<Long> readIssueIds(@Nonnull IssueIdCollector collector) throws IOException {
        return ImmutableList.copyOf((Collection)Collections2.transform(collector.getIssueIds(), (Function)new StringToLongFunction()));
    }

    private static class StringToLongFunction
    implements Function<String, Long> {
        private StringToLongFunction() {
        }

        public Long apply(@Nullable String input) {
            return Long.valueOf(input);
        }
    }
}

