/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.jira.issue.statistics.util.FieldableDocumentHitCollector;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collections;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.SetBasedFieldSelector;
import org.apache.lucene.search.IndexSearcher;

public class PrefixFieldableHitCollector
extends FieldableDocumentHitCollector {
    private final FieldSelector fieldSelector;
    private final String fieldId;
    private final String prefix;
    private final Set<String> results;

    public PrefixFieldableHitCollector(IndexSearcher searcher, String fieldId, String prefix, Set<String> results) {
        super(searcher);
        this.fieldId = (String)Assertions.notNull((String)"fieldId", (Object)fieldId);
        this.results = (Set)Assertions.notNull((String)"results", results);
        this.prefix = ((String)Assertions.notNull((String)"prefix", (Object)prefix)).toLowerCase();
        this.fieldSelector = new SetBasedFieldSelector(CollectionBuilder.newBuilder((Object[])new String[]{fieldId}).asSet(), Collections.emptySet());
    }

    protected FieldSelector getFieldSelector() {
        return this.fieldSelector;
    }

    public void collect(Document doc) {
        for (String value : doc.getValues(this.fieldId)) {
            if (!value.toLowerCase().startsWith(this.prefix)) continue;
            this.results.add(value);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PrefixFieldableHitCollector that = (PrefixFieldableHitCollector)((Object)o);
        if (!this.fieldId.equals(that.fieldId)) {
            return false;
        }
        if (!this.prefix.equals(that.prefix)) {
            return false;
        }
        return this.results.equals(that.results);
    }

    public int hashCode() {
        int result = this.fieldId.hashCode();
        result = 31 * result + this.prefix.hashCode();
        result = 31 * result + this.results.hashCode();
        return result;
    }
}

