/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics.util;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.search.ReaderCache;
import com.atlassian.jira.issue.search.parameters.lucene.sort.JiraLuceneFieldFinder;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.util.RuntimeIOException;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class OneDimensionalObjectHitCollector
extends Collector {
    private final ReaderCache readerCache;
    private StatisticsMapper statisticsMapper;
    private final Map<Object, Integer> result;
    private Collection<String>[] docToTerms;
    private int docBase = 0;
    private final boolean isUnique;

    public OneDimensionalObjectHitCollector(StatisticsMapper statisticsMapper, Map result) {
        this(statisticsMapper, result, false);
    }

    @ExperimentalApi
    public OneDimensionalObjectHitCollector(StatisticsMapper statisticsMapper, Map result, boolean isUnique) {
        this.result = result;
        this.statisticsMapper = statisticsMapper;
        this.isUnique = isUnique;
        this.readerCache = (ReaderCache)ComponentAccessor.getComponent(ReaderCache.class);
    }

    public void collect(int i) {
        this.adjustMapForValues(this.result, this.docToTerms[i]);
    }

    public void setScorer(Scorer scorer) throws IOException {
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.docBase = docBase;
        String fieldId = this.statisticsMapper.getDocumentConstant();
        this.docToTerms = this.readerCache.get(reader, fieldId, () -> {
            try {
                if (this.isUnique) {
                    return JiraLuceneFieldFinder.getInstance().getUniqueMatches(reader, fieldId);
                }
                return JiraLuceneFieldFinder.getInstance().getMatches(reader, fieldId);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        });
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    private void adjustMapForValues(Map<Object, Integer> map, Collection<String> terms) {
        if (terms == null) {
            return;
        }
        for (String term : terms) {
            Object object = this.statisticsMapper.getValueFromLuceneField(term);
            if (object == null) continue;
            Integer count = map.get(object);
            map.put(object, count == null ? 1 : count + 1);
        }
    }
}

