/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.atlassian.jira.issue.statistics.StatisticsManager;
import com.atlassian.jira.issue.statistics.StatisticsMapper;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.bean.StatisticAccessorBean;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.query.Query;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class StatisticsManagerImpl
implements StatisticsManager {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectManager projectManager;
    private final FilterStatisticsValuesGenerator filterStatisticsGenerator;

    public StatisticsManagerImpl(JiraAuthenticationContext jiraAuthenticationContext, ProjectManager projectManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.filterStatisticsGenerator = new FilterStatisticsValuesGenerator();
    }

    @VisibleForTesting
    StatisticsManagerImpl(JiraAuthenticationContext jiraAuthenticationContext, ProjectManager projectManager, FilterStatisticsValuesGenerator filterStatisticsGenerator) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectManager = projectManager;
        this.filterStatisticsGenerator = filterStatisticsGenerator;
    }

    @Override
    public StatisticMapWrapper<Object, Integer> getObjectsResultingFrom(Optional<Query> query, String statsObject) {
        Query q = query.orElse(JqlQueryBuilder.newBuilder().buildQuery());
        SearchRequest sr = new SearchRequest(q);
        StatisticsMapper mapper = this.filterStatisticsGenerator.getStatsMapper(statsObject);
        if (mapper == null) {
            throw new IllegalArgumentException(statsObject + " CF does not implement CustomFieldStattable so cannot be parsed by the StatsMapper");
        }
        StatisticAccessorBean statsBean = new StatisticAccessorBean(this.jiraAuthenticationContext.getLoggedInUser(), sr);
        try {
            return statsBean.getWrapper(mapper, StatisticAccessorBean.OrderBy.NATURAL, StatisticAccessorBean.Direction.ASC);
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Map<Project, Map<T, Integer>> getProjectsWithItemsWithIssueCount(Optional<Query> query, Function<T, Long> objToProjectIdMapper, String objectType) {
        StatisticMapWrapper<Object, Integer> items = this.getObjectsResultingFrom(query, objectType);
        Map<Project, Map<T, Integer>> out = items.keySet().stream().filter(obj -> obj != null).map(objToProjectIdMapper).distinct().collect(Collectors.toMap(projectId -> this.projectManager.getProjectObj(projectId), projectId -> Maps.newHashMap()));
        for (Map.Entry e : items.getStatistics().entrySet()) {
            Object item = e.getKey();
            if (item == null) continue;
            Integer count = (Integer)e.getValue();
            Long projectId2 = objToProjectIdMapper.apply(item);
            Project project = this.projectManager.getProjectObj(projectId2);
            if (!out.containsKey(project)) continue;
            out.get(project).put(item, count);
        }
        return out;
    }
}

