/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.security;

import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.association.NodeAssocationType;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.group.GroupConfigurable;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelAddedEvent;
import com.atlassian.jira.event.issue.security.IssueSecurityLevelDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeAddedToProjectEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeCopiedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeCreatedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeDeletedEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.issue.security.IssueSecuritySchemeUpdatedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeAddedToProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeCopiedEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeRemovedFromProjectEvent;
import com.atlassian.jira.event.scheme.AbstractSchemeUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeCommand;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeTaskContext;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelPermission;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.permission.PermissionContextFactory;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeManager;
import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.scheme.SchemeFactory;
import com.atlassian.jira.security.SecurityTypeManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.type.SecurityType;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.NameComparator;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TenantInfo(value=TenantAware.UNRESOLVED)
public class IssueSecuritySchemeManagerImpl
extends AbstractSchemeManager
implements IssueSecuritySchemeManager,
Startable,
GroupConfigurable {
    private static final Logger log = LoggerFactory.getLogger(IssueSecuritySchemeManagerImpl.class);
    private static final String SCHEME_ENTITY_NAME = "IssueSecurityScheme";
    private static final String ISSUE_SECURITY_ENTITY_NAME = "SchemeIssueSecurities";
    private static final String SCHEME_DESC = "Issue Security";
    private static final String DEFAULT_NAME_KEY = "admin.schemes.security.default";
    private static final String DEFAULT_DESC_KEY = "admin.schemes.security.default.desc";
    private static final String PERM_TYPE = "type";
    private static final String PERM_PARAMETER = "parameter";
    private static final NodeAssocationType ISSUE_SECURITY_SCHEME_ASSOCIATION = new NodeAssocationType("ProjectScheme", "Project", "IssueSecurityScheme");
    private static final String SCHEME_ID_TO_SECURITIES_FEATURE = "jira.jvc." + IssueSecuritySchemeManagerImpl.class.getName() + ".schemeIdToSecuritiesCache.request";
    private static final String SECURITY_LEVEL_TO_PERMISSIONS = "jira.jvc." + IssueSecuritySchemeManagerImpl.class.getName() + "securityLevelToPermissionsCache.request";
    private static final String SCHEME = "scheme";
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<CacheKey, List<GenericValue>> schemeIdToSecuritiesCache;
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<Long, List<IssueSecurityLevelPermission>> securityLevelToPermissionsCache;
    private final IssueIndexingService issueIndexingService;
    private final IssueManager issueManager;
    private final TaskManager taskManager;
    private final QueryDslAccessor queryDslAccessor;
    private final I18nHelper i18nHelper;
    private final ProjectManager projectManager;
    private final OfBizDelegator ofBizDelegator;
    private final NodeAssociationStore nodeAssociationStore;

    public IssueSecuritySchemeManagerImpl(ProjectManager projectManager, SecurityTypeManager securityTypeManager, PermissionContextFactory permissionContextFactory, SchemeFactory schemeFactory, EventPublisher eventPublisher, OfBizDelegator ofBizDelegator, GroupManager groupManager, NodeAssociationStore nodeAssociationStore, SwitchingCacheFactory cacheFactory, IssueIndexingService issueIndexingService, IssueManager issueManager, TaskManager taskManager, QueryDslAccessor queryDslAccessor, I18nHelper i18nHelper) {
        super(projectManager, securityTypeManager, permissionContextFactory, schemeFactory, nodeAssociationStore, ofBizDelegator, groupManager, eventPublisher, cacheFactory);
        this.projectManager = projectManager;
        this.nodeAssociationStore = nodeAssociationStore;
        this.ofBizDelegator = ofBizDelegator;
        this.issueIndexingService = issueIndexingService;
        this.issueManager = issueManager;
        this.taskManager = taskManager;
        this.queryDslAccessor = queryDslAccessor;
        this.i18nHelper = i18nHelper;
        this.schemeIdToSecuritiesCache = cacheFactory.buildSwitchingRequestCache(IssueSecuritySchemeManagerImpl.class.getName() + ".schemeIdToSecuritiesCache", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build()), SCHEME_ID_TO_SECURITIES_FEATURE);
        this.securityLevelToPermissionsCache = cacheFactory.buildSwitchingRequestCache(IssueSecuritySchemeManagerImpl.class.getName() + "securityLevelToPermissionsCache", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).build()), SECURITY_LEVEL_TO_PERMISSIONS);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @Override
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        super.onClearCache(event);
        this.clearCache();
    }

    @Override
    public String getSchemeEntityName() {
        return SCHEME_ENTITY_NAME;
    }

    @Override
    public String getEntityName() {
        return ISSUE_SECURITY_ENTITY_NAME;
    }

    @Override
    public String getSchemeDesc() {
        return SCHEME_DESC;
    }

    @Override
    public String getDefaultNameKey() {
        return DEFAULT_NAME_KEY;
    }

    @Override
    public String getDefaultDescriptionKey() {
        return DEFAULT_DESC_KEY;
    }

    private void clearCache() {
        if (log.isDebugEnabled()) {
            log.debug("Clearing issue security scheme cache.");
        }
        this.schemeIdToSecuritiesCache.removeAll();
        this.securityLevelToPermissionsCache.removeAll();
    }

    @Override
    public List<GenericValue> getEntities(GenericValue scheme) {
        CacheKey id = new CacheKey(scheme.getLong("id"));
        return (List)this.schemeIdToSecuritiesCache.get(id, this.loadSecuritiesByField(id));
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long securityLevelId) throws GenericEntityException {
        List<GenericValue> securities = this.getEntitiesBySecurityLevel(securityLevelId);
        return securities.isEmpty() || scheme.getLong("id").equals(securities.get(0).getLong(SCHEME)) ? securities : Collections.emptyList();
    }

    public IssueSecurityLevelScheme getIssueSecurityLevelScheme(Long issueSecuritySchemeId) {
        return (IssueSecurityLevelScheme)Select.from(Entity.ISSUE_SECURITY_LEVEL_SCHEME).whereEqual("id", issueSecuritySchemeId).runWith(this.ofBizDelegator).singleValue();
    }

    public Collection<IssueSecurityLevelScheme> getIssueSecurityLevelSchemes() {
        return Select.from(Entity.ISSUE_SECURITY_LEVEL_SCHEME).runWith(this.ofBizDelegator).asList();
    }

    public List<GenericValue> getEntitiesBySecurityLevel(Long securityLevelId) {
        return EntityUtils.convertToGenericValues(Entity.ISSUE_SECURITY_LEVEL_PERMISSION, this.getPermissionsBySecurityLevel(securityLevelId));
    }

    public List<IssueSecurityLevelPermission> getPermissionsBySecurityLevel(Long securityLevelId) {
        return (List)this.securityLevelToPermissionsCache.get(securityLevelId, this.loadPermissionBySecurityLevel(securityLevelId));
    }

    public Collection<GenericValue> getSchemesContainingEntity(String type, String parameter) {
        List entities = this.ofBizDelegator.findByAnd(ISSUE_SECURITY_ENTITY_NAME, (Map)FieldMap.build((String)PERM_TYPE, (Object)type, (String)PERM_PARAMETER, (Object)parameter));
        if (entities.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Long> schemeIds = entities.stream().map(schemeEntity -> schemeEntity.getLong(SCHEME)).collect(Collectors.toSet());
        return this.getSchemesByIds(schemeIds);
    }

    public void setSchemeForProject(Project project, Long schemeId) {
        this.nodeAssociationStore.removeAssociationsFromSource(ISSUE_SECURITY_SCHEME_ASSOCIATION, project.getId());
        if (schemeId != null) {
            this.nodeAssociationStore.createAssociation(ISSUE_SECURITY_SCHEME_ASSOCIATION, project.getId(), schemeId);
        }
        this.flushProjectSchemes();
    }

    public String assignSchemeToProject(@Nonnull Project project, Long newSchemeId, Map<Long, Long> oldToNewSecurityLevelMappings) {
        String taskName = this.i18nHelper.getText("admin.iss.associate.security.scheme", project.getName());
        AssignIssueSecuritySchemeCommand indexCallable = new AssignIssueSecuritySchemeCommand(project, newSchemeId, oldToNewSecurityLevelMappings, this.queryDslAccessor, this, this.issueIndexingService, this.issueManager, log, this.i18nHelper);
        return this.taskManager.submitTask(indexCallable, taskName, new AssignIssueSecuritySchemeTaskContext(project), true).getProgressURL();
    }

    public List<Project> getProjectsUsingScheme(long schemeId) {
        return this.nodeAssociationStore.getSourceIdsFromSink(ISSUE_SECURITY_SCHEME_ASSOCIATION, schemeId).stream().map(arg_0 -> ((ProjectManager)this.projectManager).getProjectObj(arg_0)).sorted(NameComparator.COMPARATOR).collect(Collectors.toList());
    }

    private Collection<GenericValue> getSchemesByIds(Set<Long> schemeIds) {
        List entityConditions = schemeIds.stream().map(schemeId -> new EntityExpr("id", EntityOperator.EQUALS, schemeId)).collect(Collectors.toList());
        return entityConditions.isEmpty() ? Collections.emptyList() : this.ofBizDelegator.findByOr(SCHEME_ENTITY_NAME, entityConditions, Collections.emptyList());
    }

    public List<GenericValue> getEntities(GenericValue scheme, Long schemeTypeId, String parameter) throws GenericEntityException {
        List<GenericValue> securities = this.getEntities(scheme, schemeTypeId);
        return securities.isEmpty() ? securities : IssueSecuritySchemeManagerImpl.filter(securities, IssueSecuritySchemeManagerImpl.withField(PERM_PARAMETER, parameter));
    }

    public List<GenericValue> getEntities(GenericValue scheme, String entityTypeId) throws GenericEntityException {
        throw new IllegalArgumentException("Issue Security scheme IDs must be Long values.");
    }

    public List<GenericValue> getEntities(GenericValue scheme, String type, Long schemeTypeId) throws GenericEntityException {
        List<GenericValue> securities = this.getEntities(scheme, schemeTypeId);
        return securities.isEmpty() ? securities : IssueSecuritySchemeManagerImpl.filter(securities, IssueSecuritySchemeManagerImpl.withField(PERM_TYPE, type));
    }

    public GenericValue createSchemeEntity(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        GenericValue result = this.createSchemeEntityNoEvent(scheme, schemeEntity);
        this.eventPublisher.publish((Object)new IssueSecurityLevelAddedEvent(scheme == null ? null : scheme.getLong("id"), schemeEntity));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GenericValue createSchemeEntityNoEvent(GenericValue scheme, SchemeEntity schemeEntity) throws GenericEntityException {
        if (!(schemeEntity.getEntityTypeId() instanceof Long)) {
            throw new IllegalArgumentException("Issue Security Level IDs must be a long value.");
        }
        try {
            Long schemeId = scheme == null ? null : scheme.getLong("id");
            GenericValue genericValue = EntityUtils.createValue(ISSUE_SECURITY_ENTITY_NAME, (Map<String, Object>)FieldMap.build((String)SCHEME, (Object)schemeId, (String)"security", (Object)schemeEntity.getEntityTypeId(), (String)PERM_TYPE, (Object)schemeEntity.getType(), (String)PERM_PARAMETER, (Object)schemeEntity.getParameter()));
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue copyScheme(GenericValue oldScheme) throws GenericEntityException {
        if (oldScheme == null) {
            return null;
        }
        try {
            String name = this.getNameForCopy(oldScheme.getString("name"), null);
            GenericValue newScheme = this.createSchemeNoEvent(name, oldScheme.getString("description"));
            this.copySecurityLevels(newScheme, oldScheme);
            this.eventPublisher.publish((Object)this.createSchemeCopiedEvent(this.schemeFactory.getScheme(oldScheme), this.schemeFactory.getScheme(newScheme)));
            GenericValue genericValue = newScheme;
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    @Nonnull
    protected AbstractSchemeCopiedEvent createSchemeCopiedEvent(@Nonnull Scheme oldScheme, @Nonnull Scheme newScheme) {
        return new IssueSecuritySchemeCopiedEvent(oldScheme, newScheme);
    }

    private void copySecurityLevels(GenericValue scheme, GenericValue oldScheme) throws GenericEntityException {
        List levels = this.ofBizDelegator.findByAnd("SchemeIssueSecurityLevels", (Map)FieldMap.build((String)SCHEME, (Object)oldScheme.getLong("id")));
        for (GenericValue level : levels) {
            IssueSecurityLevel newSecurityLevel = ComponentAccessor.getIssueSecurityLevelManager().createIssueSecurityLevel(scheme.getLong("id").longValue(), level.getString("name"), level.getString("description"));
            if (level.getLong("id").equals(oldScheme.getLong("defaultlevel"))) {
                scheme.set("defaultlevel", (Object)newSecurityLevel.getId());
                scheme.store();
            }
            List securities = this.ofBizDelegator.findByAnd(this.getEntityName(), (Map)FieldMap.build((String)SCHEME, (Object)oldScheme.getLong("id"), (String)"security", (Object)level.getLong("id")));
            for (GenericValue security : securities) {
                this.createSchemeEntity(scheme, new SchemeEntity(security.getString(PERM_TYPE), security.getString(PERM_PARAMETER), (Object)newSecurityLevel.getId()));
            }
        }
    }

    public boolean hasSecurityLevelAccess(@Nonnull Issue issue, @Nullable ApplicationUser user) {
        Long securityLevelId = issue.getSecurityLevelId();
        if (securityLevelId == null) {
            return true;
        }
        try {
            Scheme scheme = this.getSchemeFor(issue.getProjectObject());
            if (scheme != null) {
                return this.hasPermission(issue, user, this.getEntities(this.getScheme(scheme.getId()), securityLevelId));
            }
        }
        catch (GenericEntityException e) {
            log.error("Could not retrieve entities from the database", (Throwable)e);
        }
        return false;
    }

    private boolean hasPermission(Issue issue, ApplicationUser user, List<GenericValue> entities) {
        if (entities.isEmpty()) {
            return false;
        }
        for (SecurityType type : this.securityTypeManager.getTypes().values()) {
            for (GenericValue perm : IssueSecuritySchemeManagerImpl.filter(entities, IssueSecuritySchemeManagerImpl.withField(PERM_TYPE, type.getType()))) {
                if (perm == null || !this.hasPermission(issue, user, type, perm)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasPermission(Issue issue, ApplicationUser user, SecurityType type, GenericValue perm) {
        return user == null ? type.hasPermission(issue, perm.getString(PERM_PARAMETER)) : type.hasPermission(issue, perm.getString(PERM_PARAMETER), user, false);
    }

    @Override
    protected AbstractSchemeUpdatedEvent createSchemeUpdatedEvent(Scheme scheme, Scheme originalScheme) {
        return new IssueSecuritySchemeUpdatedEvent(scheme, originalScheme);
    }

    @Override
    public void deleteScheme(Long id) throws GenericEntityException {
        try {
            GenericValue scheme = this.getScheme(id);
            this.nodeAssociationStore.removeAssociationsFromSink(scheme);
            scheme.removeRelated("Child" + this.getEntityName());
            scheme.removeRelated("ChildSchemeIssueSecurityLevels");
            scheme.remove();
            this.eventPublisher.publish((Object)new IssueSecuritySchemeDeletedEvent(id));
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    public void deleteEntity(Long id) throws DataAccessException {
        this.deleteEntities(Collections.singleton(id));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEntities(Iterable<Long> ids) {
        try {
            super.deleteEntities(ids);
            for (Long id : ids) {
                this.eventPublisher.publish((Object)new IssueSecurityLevelDeletedEvent(id));
            }
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    protected SchemeEntity makeSchemeEntity(GenericValue entity) {
        return new SchemeEntity(entity.getString(PERM_TYPE), entity.getString(PERM_PARAMETER), (Object)entity.getLong("security"));
    }

    @Override
    protected Object createSchemeEntityDeletedEvent(GenericValue entity) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(GenericValue scheme, Long entityTypeId) throws RemoveException {
        try {
            boolean bl = super.removeEntities(scheme, entityTypeId);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenericValue createScheme(String name, String description) throws GenericEntityException {
        try {
            GenericValue genericValue = super.createScheme(name, description);
            return genericValue;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    protected AbstractSchemeEvent createSchemeCreatedEvent(Scheme scheme) {
        return new IssueSecuritySchemeCreatedEvent(scheme);
    }

    @Override
    protected void flushProjectSchemes() {
        try {
            super.flushProjectSchemes();
        }
        finally {
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntities(String type, String parameter) throws RemoveException {
        try {
            boolean bl = super.removeEntities(type, parameter);
            return bl;
        }
        finally {
            this.clearCache();
        }
    }

    @Override
    @Nonnull
    protected AbstractSchemeAddedToProjectEvent createSchemeAddedToProjectEvent(Scheme scheme, Project project) {
        return new IssueSecuritySchemeAddedToProjectEvent(scheme, project);
    }

    @Override
    @Nonnull
    protected AbstractSchemeRemovedFromProjectEvent createSchemeRemovedFromProjectEvent(Scheme scheme, Project project) {
        return new IssueSecuritySchemeRemovedFromProjectEvent(scheme, project);
    }

    private static List<GenericValue> filter(List<GenericValue> list, Predicate<GenericValue> predicate) {
        return ImmutableList.copyOf((Collection)list.stream().filter(predicate).collect(Collectors.toList()));
    }

    private static Predicate<GenericValue> withField(String field, String value) {
        if (value == null) {
            return input -> input.getString(field) == null;
        }
        return input -> value.equals(input.getString(field));
    }

    @Override
    public boolean isGroupUsed(@Nonnull Group group) {
        List entities = this.ofBizDelegator.findByAnd(ISSUE_SECURITY_ENTITY_NAME, (Map)FieldMap.build((String)PERM_TYPE, (Object)"group", (String)PERM_PARAMETER, (Object)group.getName()));
        return entities.size() > 0;
    }

    @Nonnull
    private Supplier<List<GenericValue>> loadSecuritiesByField(@Nonnull CacheKey cacheKey) {
        List result = this.ofBizDelegator.findByAnd(this.getEntityName(), (Map)FieldMap.build((String)SCHEME, (Object)cacheKey.id));
        return () -> result;
    }

    private Supplier<List<IssueSecurityLevelPermission>> loadPermissionBySecurityLevel(@Nullable Long input) {
        return () -> Select.from(Entity.ISSUE_SECURITY_LEVEL_PERMISSION).whereEqual("security", input).runWith(this.ofBizDelegator).asList();
    }

    static class CacheKey
    implements Serializable {
        final Long id;

        CacheKey(Long id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            return this.id == null ? other.id == null : this.id.equals(other.id);
        }

        public int hashCode() {
            return this.id != null ? this.id.hashCode() : 0;
        }
    }
}

