/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.util;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.comparator.UserCachingComparator;
import com.atlassian.jira.issue.search.searchers.util.UserSearcherHelper;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserHistoryItem;
import com.atlassian.jira.user.UserHistoryManager;
import com.atlassian.jira.user.util.GroupNameComparator;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UserSearcherHelperImpl
implements UserSearcherHelper {
    private final GroupManager groupManager;
    private final PermissionManager permissionManager;
    private final UserManager userManager;
    private final UserHistoryManager userHistoryManager;
    private final UserSearchService userSearchService;
    private static final int LARGE_USER_COUNT_THRESHOLD = 10;

    public UserSearcherHelperImpl(GroupManager groupManager, PermissionManager permissionManager, UserManager userManager, UserHistoryManager userHistoryManager, UserSearchService userSearchService) {
        this.groupManager = groupManager;
        this.permissionManager = permissionManager;
        this.userManager = userManager;
        this.userHistoryManager = userHistoryManager;
        this.userSearchService = userSearchService;
    }

    public void addUserSuggestionParams(ApplicationUser user, List<String> selectedUsers, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedUsers", this.getSuggestedUsers(user, selectedUsers, UserSearchParams.ACTIVE_USERS_ALLOW_EMPTY_QUERY));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_user"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_user"));
        }
    }

    public void addUserGroupSuggestionParams(ApplicationUser user, List<String> selectedUsers, Map<String, Object> params) {
        this.addUserGroupSuggestionParams(user, selectedUsers, UserSearchParams.ACTIVE_USERS_ALLOW_EMPTY_QUERY, params);
    }

    public void addUserGroupSuggestionParams(ApplicationUser user, List<String> selectedUsers, UserSearchParams searchParams, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        if (searchParams != null) {
            params.put("suggestedUsers", this.getSuggestedUsers(user, selectedUsers, searchParams));
        }
        params.put("suggestedGroups", this.getSuggestedGroups(user));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_usergroup"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_usergroup"));
        }
    }

    public void addGroupSuggestionParams(ApplicationUser user, Map<String, Object> params) {
        params.put("hasPermissionToPickUsers", this.hasUserPickingPermission(user));
        params.put("suggestedGroups", this.getSuggestedGroups(user));
        if (this.hasUserPickingPermission(user)) {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.browse_group"));
        } else {
            params.put("placeholderText", this.getI18n(user).getText("common.concepts.sparkler.placeholder.no_browse_group"));
        }
    }

    List<Group> getSuggestedGroups(ApplicationUser user) {
        ArrayList groups = new ArrayList();
        if (user != null) {
            groups.addAll(this.groupManager.getGroupsForUser(user));
        } else if (this.hasUserPickingPermission(user)) {
            groups.addAll(this.groupManager.getAllGroups());
        } else {
            return null;
        }
        Collections.sort(groups, new GroupNameComparator());
        return groups.subList(0, Math.min(5, groups.size()));
    }

    List<ApplicationUser> getSuggestedUsers(ApplicationUser appUser, List<String> selectedUserNames, UserSearchParams searchParams) {
        if (this.hasUserPickingPermission(appUser)) {
            int limit = 5;
            LinkedHashSet<ApplicationUser> suggestedUsers = new LinkedHashSet<ApplicationUser>();
            Set<ApplicationUser> recentlyUsedUsers = this.getRecentlyUsedUsers(appUser);
            this.addToSuggestList(limit, suggestedUsers, recentlyUsedUsers, Sets.newHashSet(selectedUserNames), searchParams);
            if (suggestedUsers.size() < limit && this.isEvaluatorSystem()) {
                ArrayList<ApplicationUser> allUsers = this.userSearchService.findUsers("", searchParams);
                allUsers = new ArrayList<ApplicationUser>(allUsers);
                Collections.sort(allUsers, new UserCachingComparator());
                if (!recentlyUsedUsers.isEmpty()) {
                    this.addToSuggestList(limit, suggestedUsers, allUsers, Stream.concat(selectedUserNames.stream(), recentlyUsedUsers.stream().map(ApplicationUser::getName)).collect(Collectors.toSet()), searchParams);
                } else {
                    this.addToSuggestList(limit, suggestedUsers, allUsers, Sets.newHashSet(selectedUserNames), searchParams);
                }
            }
            return ImmutableList.copyOf(suggestedUsers);
        }
        return null;
    }

    boolean isEvaluatorSystem() {
        UserSearchParams params = UserSearchParams.builder().allowEmptyQuery(true).maxResults(Integer.valueOf(11)).build();
        return this.userSearchService.findUserNames("", params).size() <= 10;
    }

    void addToSuggestList(int limit, LinkedHashSet<ApplicationUser> suggestedUsers, Iterable<ApplicationUser> users, Set<String> alreadySelected, UserSearchParams searchParams) {
        for (ApplicationUser user : users) {
            if (suggestedUsers.size() >= limit) break;
            if (suggestedUsers.contains(user) || alreadySelected.contains(user.getName()) || !this.userSearchService.userMatches(user, searchParams)) continue;
            suggestedUsers.add(user);
        }
    }

    Set<ApplicationUser> getUsersToSelect(Stream<ApplicationUser> usersToSelectFrom, Set<String> alreadySelected, int limit, UserSearchParams searchParams) {
        return usersToSelectFrom.filter(u -> !alreadySelected.contains(u.getName())).filter(u -> this.userSearchService.userMatches(u, searchParams)).limit(limit).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<ApplicationUser> getRecentlyUsedUsers(ApplicationUser user) {
        Function toUser = name -> name == null ? null : this.userManager.getUserByName(name);
        Function historyItemToUser = Functions.compose((Function)toUser, (Function)UserHistoryItem.GET_ENTITY_ID);
        return this.userHistoryManager.getHistory(UserHistoryItem.USED_USER, user).stream().map(arg_0 -> ((Function)historyItemToUser).apply(arg_0)).filter(appUser -> appUser != null).collect(Collectors.toSet());
    }

    public boolean hasUserPickingPermission(ApplicationUser user) {
        return this.permissionManager.hasPermission(27, user);
    }

    private I18nHelper getI18n(ApplicationUser user) {
        return ((I18nHelper.BeanFactory)ComponentAccessor.getComponent(I18nHelper.BeanFactory.class)).getInstance(user);
    }
}

