/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.quicksearch;

import com.atlassian.jira.issue.search.quicksearch.ProjectAwareQuickSearchHandler;
import com.atlassian.jira.issue.search.quicksearch.QuickSearchResult;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class ProjectAwareQuickSearchHandlerImpl
implements ProjectAwareQuickSearchHandler {
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final JiraAuthenticationContext authenticationContext;

    public ProjectAwareQuickSearchHandlerImpl(ProjectManager projectManager, PermissionManager permissionManager, JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public List<Project> getProjects(QuickSearchResult searchResult) {
        Collection projectIds = searchResult.getSearchParameters("pid");
        if (projectIds != null && projectIds.size() == 1) {
            String projectId = (String)projectIds.iterator().next();
            Project project = this.projectManager.getProjectObj(new Long(projectId));
            return Lists.newArrayList((Object[])new Project[]{project});
        }
        return Lists.newArrayList((Iterable)this.permissionManager.getProjects(ProjectPermissions.BROWSE_PROJECTS, this.authenticationContext.getUser()));
    }

    @Override
    public String getSingleProjectIdFromSearch(QuickSearchResult searchResult) {
        Collection projectIds = searchResult.getSearchParameters("pid");
        if (projectIds != null && projectIds.size() == 1) {
            return (String)projectIds.iterator().next();
        }
        return null;
    }

    @Override
    public void addProject(String projectId, QuickSearchResult searchResult) {
        searchResult.addSearchParameter("pid", projectId);
    }
}

