/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.parameters.filter;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.dbc.Assertions;

public class NoBrowsePermissionPredicate
implements Predicate<Issue> {
    private final ApplicationUser searcher;
    private final PermissionManager permissionManager;

    public NoBrowsePermissionPredicate(ApplicationUser searcher) {
        this(searcher, ComponentAccessor.getPermissionManager());
    }

    NoBrowsePermissionPredicate(ApplicationUser searcher, PermissionManager permissionManager) {
        this.searcher = searcher;
        this.permissionManager = (PermissionManager)Assertions.notNull((String)"permissionManager", (Object)permissionManager);
    }

    public boolean evaluate(Issue issue) {
        return !this.permissionManager.hasPermission(10, issue, this.searcher);
    }
}

