/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.type.EventDispatchOption;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.UpdateIssueRequest;
import com.atlassian.jira.security.JiraAuthenticationContextImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.servlet.http.HttpServletRequest;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class RequestCachingIssueManager
implements IssueManager {
    private static final String ISSUE_NAV_ROOT = "kickass-issue-nav-root";
    private static final String CACHE_KEY = RequestCachingIssueManager.class.getName() + ".issues";
    private static final String FEATURE_KEY = "jira.request.scope.issue.caching.disabled";
    private final IssueManager delegate;
    private final FeatureManager featureManager;

    public RequestCachingIssueManager(IssueManager delegate, FeatureManager featureManager) {
        this.delegate = delegate;
        this.featureManager = featureManager;
    }

    public MutableIssue getIssueObject(Long id) throws DataAccessException {
        if (this.shouldCacheIssues()) {
            IssueCache cache = (IssueCache)JiraAuthenticationContextImpl.getRequestCache(CACHE_KEY, () -> new IssueCache());
            Optional<MutableIssue> issue = cache.getById(id);
            if (issue == null) {
                issue = Optional.ofNullable(this.delegate.getIssueObject(id));
                cache.put(id, issue);
            }
            return issue.orElse(null);
        }
        return this.delegate.getIssueObject(id);
    }

    private boolean shouldCacheIssues() {
        return this.isViewIssueRequest() && this.isRequestScopeIssueCachingEnabled();
    }

    private boolean isRequestScopeIssueCachingEnabled() {
        return !this.featureManager.isEnabled(FEATURE_KEY);
    }

    private boolean isViewIssueRequest() {
        HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
        return httpServletRequest != null && httpServletRequest.getAttribute(ISSUE_NAV_ROOT) != null;
    }

    public MutableIssue getIssueObject(String key) throws DataAccessException {
        if (this.shouldCacheIssues() && key != null) {
            IssueCache cache = (IssueCache)JiraAuthenticationContextImpl.getRequestCache(CACHE_KEY, () -> new IssueCache());
            Optional<MutableIssue> issue = cache.getByKey(key);
            if (issue == null) {
                issue = Optional.ofNullable(this.delegate.getIssueObject(key));
                cache.put(key, issue);
            }
            return issue.orElse(null);
        }
        return this.delegate.getIssueObject(key);
    }

    @ExperimentalApi
    public MutableIssue getIssueByKeyIgnoreCase(String key) throws DataAccessException {
        return this.delegate.getIssueByKeyIgnoreCase(key);
    }

    @ExperimentalApi
    public MutableIssue getIssueByCurrentKey(String key) throws DataAccessException {
        MutableIssue issue = this.getIssueObject(key);
        if (issue != null && issue.getString("key").equals(key)) {
            return issue;
        }
        return null;
    }

    @Deprecated
    public List<GenericValue> getIssues(Collection<Long> ids) {
        return this.delegate.getIssues(ids);
    }

    public List<Issue> getIssueObjects(Collection<Long> ids) {
        return this.delegate.getIssueObjects(ids);
    }

    public List<Issue> getVotedIssues(ApplicationUser user) {
        return this.delegate.getVotedIssues(user);
    }

    public List<Issue> getVotedIssuesOverrideSecurity(ApplicationUser user) {
        return this.delegate.getVotedIssuesOverrideSecurity(user);
    }

    public List<ApplicationUser> getWatchers(Issue issue) {
        return this.delegate.getWatchers(issue);
    }

    public List<ApplicationUser> getWatchersFor(Issue issue) {
        return this.delegate.getWatchersFor(issue);
    }

    public List<Issue> getWatchedIssues(ApplicationUser user) {
        return this.delegate.getWatchedIssues(user);
    }

    public List<Issue> getWatchedIssuesOverrideSecurity(ApplicationUser user) {
        return this.delegate.getWatchedIssuesOverrideSecurity(user);
    }

    public List<GenericValue> getEntitiesByIssue(String relationName, GenericValue issue) throws GenericEntityException {
        return this.delegate.getEntitiesByIssue(relationName, issue);
    }

    public List<GenericValue> getEntitiesByIssueObject(String relationName, Issue issue) throws GenericEntityException {
        return this.delegate.getEntitiesByIssueObject(relationName, issue);
    }

    public List<GenericValue> getIssuesByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return this.delegate.getIssuesByEntity(relationName, entity);
    }

    public List<Issue> getIssueObjectsByEntity(String relationName, GenericValue entity) throws GenericEntityException {
        return this.delegate.getIssueObjectsByEntity(relationName, entity);
    }

    public Set<String> getAllIssueKeys(Long issueId) {
        return this.delegate.getAllIssueKeys(issueId);
    }

    @Deprecated
    public GenericValue createIssue(String remoteUserName, Map<String, Object> fields) throws CreateException {
        return this.delegate.createIssue(remoteUserName, fields);
    }

    public Issue createIssueObject(String remoteUserName, Map<String, Object> fields) throws CreateException {
        return this.delegate.createIssueObject(remoteUserName, fields);
    }

    @Deprecated
    public GenericValue createIssue(ApplicationUser remoteUser, Map<String, Object> fields) throws CreateException {
        return this.delegate.createIssue(remoteUser, fields);
    }

    public Issue createIssueObject(ApplicationUser remoteUser, Map<String, Object> fields) throws CreateException {
        return this.delegate.createIssueObject(remoteUser, fields);
    }

    @Deprecated
    public GenericValue createIssue(ApplicationUser remoteUser, Issue issue) throws CreateException {
        return this.delegate.createIssue(remoteUser, issue);
    }

    public Issue createIssueObject(ApplicationUser remoteUser, Issue issue) throws CreateException {
        return this.delegate.createIssueObject(remoteUser, issue);
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) {
        return this.delegate.updateIssue(user, issue, eventDispatchOption, sendMail);
    }

    public Issue updateIssue(ApplicationUser user, MutableIssue issue, UpdateIssueRequest updateIssueRequest) {
        return this.delegate.updateIssue(user, issue, updateIssueRequest);
    }

    public void deleteIssue(ApplicationUser user, Issue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.delegate.deleteIssue(user, issue, eventDispatchOption, sendMail);
    }

    @Deprecated
    public void deleteIssue(ApplicationUser user, MutableIssue issue, EventDispatchOption eventDispatchOption, boolean sendMail) throws RemoveException {
        this.delegate.deleteIssue(user, issue, eventDispatchOption, sendMail);
    }

    public void deleteIssueNoEvent(Issue issue) throws RemoveException {
        this.delegate.deleteIssueNoEvent(issue);
    }

    @Deprecated
    public void deleteIssueNoEvent(MutableIssue issue) throws RemoveException {
        this.delegate.deleteIssueNoEvent(issue);
    }

    @Deprecated
    public List<GenericValue> getProjectIssues(GenericValue project) throws GenericEntityException {
        return this.delegate.getProjectIssues(project);
    }

    public boolean isEditable(Issue issue) {
        return this.delegate.isEditable(issue);
    }

    public boolean isEditable(Issue issue, ApplicationUser user) {
        return this.delegate.isEditable(issue, user);
    }

    public Collection<Long> getIssueIdsForProject(Long projectId) throws GenericEntityException {
        return this.delegate.getIssueIdsForProject(projectId);
    }

    public long getIssueCountForProject(Long projectId) {
        return this.delegate.getIssueCountForProject(projectId);
    }

    public boolean hasUnassignedIssues() {
        return this.delegate.hasUnassignedIssues();
    }

    public long getUnassignedIssueCount() {
        return this.delegate.getUnassignedIssueCount();
    }

    public long getIssueCount() {
        return this.delegate.getIssueCount();
    }

    public boolean atLeastOneIssueExists() {
        return this.delegate.atLeastOneIssueExists();
    }

    @Internal
    public Issue findMovedIssue(String oldIssueKey) {
        return this.delegate.findMovedIssue(oldIssueKey);
    }

    @Internal
    public void recordMovedIssueKey(Issue oldIssue) {
        this.delegate.recordMovedIssueKey(oldIssue);
    }

    @Nonnull
    @Internal
    public Set<Pair<Long, String>> getProjectIssueTypePairsByKeys(@Nonnull Set<String> issueKeys) {
        return this.delegate.getProjectIssueTypePairsByKeys(issueKeys);
    }

    @Nonnull
    @Internal
    public Set<Pair<Long, String>> getProjectIssueTypePairsByIds(@Nonnull Set<Long> issueIds) {
        return this.delegate.getProjectIssueTypePairsByIds(issueIds);
    }

    @Nonnull
    @Internal
    public Set<String> getKeysOfMissingIssues(@Nonnull Set<String> issueKeys) {
        return this.delegate.getKeysOfMissingIssues(issueKeys);
    }

    @Nonnull
    @Internal
    public Set<Long> getIdsOfMissingIssues(@Nonnull Set<Long> issueIds) {
        return this.delegate.getIdsOfMissingIssues(issueIds);
    }

    @Deprecated
    public GenericValue getIssue(Long id) throws DataAccessException {
        return this.delegate.getIssue(id);
    }

    @Deprecated
    public GenericValue getIssue(String key) throws GenericEntityException {
        return this.delegate.getIssue(key);
    }

    @Deprecated
    public GenericValue getIssueByWorkflow(Long wfid) throws GenericEntityException {
        return this.delegate.getIssueByWorkflow(wfid);
    }

    public MutableIssue getIssueObjectByWorkflow(Long workflowId) throws GenericEntityException {
        return this.delegate.getIssueObjectByWorkflow(workflowId);
    }

    @ExperimentalApi
    public boolean isExistingIssueKey(String issueKey) throws GenericEntityException {
        return this.delegate.isExistingIssueKey(issueKey);
    }

    private static class IssueCache {
        private final HashMap<Long, Optional<MutableIssue>> byId = new HashMap();
        private final HashMap<String, Optional<MutableIssue>> byKey = new HashMap();

        private IssueCache() {
        }

        public Optional<MutableIssue> getById(Long id) {
            return this.byId.get(id);
        }

        public void put(@Nonnull Long id, @Nonnull Optional<MutableIssue> issue) {
            this.byId.put(id, issue);
            issue.ifPresent(i -> this.byKey.put(i.getKey(), Optional.of(i)));
        }

        public void put(@Nonnull String key, @Nonnull Optional<MutableIssue> issue) {
            this.byKey.put(key, issue);
            issue.ifPresent(i -> this.byId.put(i.getId(), Optional.of(i)));
        }

        public Optional<MutableIssue> getByKey(String key) {
            return this.byKey.get(key);
        }
    }
}

