/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.event.issue.field.CustomFieldCreatedEvent;
import com.atlassian.jira.event.issue.field.CustomFieldUpdatedEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.CustomFieldComparators;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.customfields.CustomFieldSearcher;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.customfields.CustomFieldUtils;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.CustomFieldFactory;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenManager;
import com.atlassian.jira.issue.index.managers.FieldIndexerManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.managers.CustomFieldSearcherManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.managers.IssueSearcherManager;
import com.atlassian.jira.model.querydsl.CustomFieldDTO;
import com.atlassian.jira.model.querydsl.QColumnLayoutItem;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.model.querydsl.QFieldLayoutItem;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptor;
import com.atlassian.jira.plugin.customfield.CustomFieldSearcherModuleDescriptors;
import com.atlassian.jira.plugin.customfield.CustomFieldTypeModuleDescriptors;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.atlassian.jira.util.ObjectUtils;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.util.concurrent.Assertions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TenantInfo(value=TenantAware.UNRESOLVED, comment="Should be Tenanted, but vcache is currently behind a feature flag.")
public class CachingCustomFieldManager
implements CustomFieldManager {
    private static final Logger log = LoggerFactory.getLogger(CachingCustomFieldManager.class);
    private static final String ID = "id";
    public static final String DARK_FEATURE_REQUEST_CACHE_KEY = "jira.jvc.CachingCustomFieldManager.request";
    private final PluginAccessor pluginAccessor;
    private final QueryDslAccessor dbConnectionManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;
    private final ConstantsManager constantsManager;
    private final ProjectManager projectManager;
    private final FieldConfigContextPersister contextPersister;
    private final FieldScreenManager fieldScreenManager;
    private final CustomFieldValuePersister customFieldValuePersister;
    private final NotificationSchemeManager notificationSchemeManager;
    private final FieldManager fieldManager;
    private final EventPublisher eventPublisher;
    private final CustomFieldFactory customFieldFactory;
    private final CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors;
    private final CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors;
    private final CustomFieldSearcherManager customFieldSearcherManager;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<CustomFieldInMemoryStore> cache;

    public CachingCustomFieldManager(PluginAccessor pluginAccessor, OfBizDelegator delegator, QueryDslAccessor dbConnectionManager, FieldConfigSchemeManager fieldConfigSchemeManager, ConstantsManager constantsManager, ProjectManager projectManager, FieldConfigContextPersister contextPersister, FieldScreenManager fieldScreenManager, CustomFieldValuePersister customFieldValuePersister, NotificationSchemeManager notificationSchemeManager, FieldManager fieldManager, EventPublisher eventPublisher, CustomFieldFactory customFieldFactory, CustomFieldTypeModuleDescriptors customFieldTypeModuleDescriptors, CustomFieldSearcherModuleDescriptors customFieldSearcherModuleDescriptors, CustomFieldSearcherManager customFieldSearcherManager, SwitchingCacheFactory switchingCacheFactory) {
        this.pluginAccessor = pluginAccessor;
        this.dbConnectionManager = dbConnectionManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
        this.constantsManager = constantsManager;
        this.projectManager = projectManager;
        this.contextPersister = contextPersister;
        this.fieldScreenManager = fieldScreenManager;
        this.customFieldValuePersister = customFieldValuePersister;
        this.notificationSchemeManager = notificationSchemeManager;
        this.fieldManager = fieldManager;
        this.eventPublisher = eventPublisher;
        this.customFieldFactory = customFieldFactory;
        this.customFieldTypeModuleDescriptors = customFieldTypeModuleDescriptors;
        this.customFieldSearcherModuleDescriptors = customFieldSearcherModuleDescriptors;
        this.customFieldSearcherManager = customFieldSearcherManager;
        this.cache = switchingCacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cache", this::loadAllCustomFields, DARK_FEATURE_REQUEST_CACHE_KEY);
        eventPublisher.register((Object)this);
    }

    private CustomFieldInMemoryStore loadAllCustomFields() {
        return new CustomFieldInMemoryStore(this.dbConnectionManager.withNewConnection().executeQuery(callback -> ((SQLQuery)callback.newSqlQuery().select((Expression)QCustomField.CUSTOM_FIELD).from((Expression)QCustomField.CUSTOM_FIELD)).fetch()).stream().map(this.customFieldFactory::create).filter(customField -> customField != null && customField.getCustomFieldType() != null).collect(Collectors.toList()));
    }

    public CustomField createCustomField(String fieldName, String description, CustomFieldType fieldType, CustomFieldSearcher customFieldSearcher, List<JiraContextNode> contexts, List<IssueType> issueTypes) throws GenericEntityException {
        String customFieldName = StringUtils.abbreviate((String)fieldName, (int)254);
        Optional<String> customFieldDescription = Optional.ofNullable(description).filter(s -> !s.isEmpty());
        Optional<String> customFieldSearcherKey = Optional.ofNullable(customFieldSearcher).map(searcher -> customFieldSearcher.getDescriptor().getCompleteKey());
        CustomFieldDTO initialCustomField = CustomFieldDTO.builder().name(customFieldName).customfieldtypekey(fieldType.getKey()).description(customFieldDescription.orElse(null)).customfieldsearcherkey(customFieldSearcherKey.orElse(null)).build();
        Long createdCustomFieldId = this.dbConnectionManager.withNewConnection().executeQuery(connection -> connection.insert(QCustomField.CUSTOM_FIELD).populate(initialCustomField).executeWithId());
        CustomFieldDTO customFieldToInsert = CustomFieldDTO.builder(initialCustomField).id(createdCustomFieldId).build();
        CustomField customField = this.customFieldFactory.create(customFieldToInsert);
        this.associateCustomFieldContext(customField, contexts, issueTypes);
        this.refreshConfiguration();
        this.eventPublisher.publish((Object)new CustomFieldCreatedEvent(customField));
        return this.getCustomFieldObject(createdCustomFieldId);
    }

    private void associateCustomFieldContext(CustomField customField, List<JiraContextNode> contexts, List<IssueType> issueTypes) {
        if (CollectionUtils.isNotEmpty(contexts)) {
            this.fieldConfigSchemeManager.createDefaultScheme((ConfigurableField)customField, contexts, issueTypes);
        }
    }

    @Nonnull
    public List<CustomFieldType<?, ?>> getCustomFieldTypes() {
        return this.customFieldTypeModuleDescriptors.getCustomFieldTypes();
    }

    public CustomFieldType getCustomFieldType(String key) {
        return (CustomFieldType)this.customFieldTypeModuleDescriptors.getCustomFieldType(key).getOrNull();
    }

    @Nonnull
    public List<CustomFieldSearcher> getCustomFieldSearchers(CustomFieldType customFieldType) {
        return this.customFieldSearcherManager.getSearchersValidFor(customFieldType);
    }

    public CustomFieldSearcher getCustomFieldSearcher(String key) {
        return (CustomFieldSearcher)this.customFieldSearcherModuleDescriptors.getCustomFieldSearcher(key).getOrNull();
    }

    @Nullable
    public CustomFieldSearcher getDefaultSearcher(@Nonnull CustomFieldType<?, ?> type) {
        return this.getCustomFieldSearchers((CustomFieldType)Assertions.notNull((String)"type", type)).stream().findFirst().orElse(null);
    }

    public Class<? extends CustomFieldSearcher> getCustomFieldSearcherClass(String key) {
        if (!ObjectUtils.isValueSelected((Object)key)) {
            return null;
        }
        ModuleDescriptor module = this.pluginAccessor.getEnabledPluginModule(key);
        if (module instanceof CustomFieldSearcherModuleDescriptor) {
            return ((CustomFieldSearcherModuleDescriptor)module).getModuleClass();
        }
        log.warn("Custom field searcher module: " + key + " is invalid. Null being returned.");
        return null;
    }

    public List<CustomField> getCustomFieldObjects(Issue issue) {
        return this.getCustomFieldObjects(issue.getProjectId(), issue.getIssueTypeId());
    }

    public List<CustomField> getCustomFieldObjects(GenericValue issue) {
        return this.getCustomFieldObjects(issue.getLong("project"), issue.getString("type"));
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, String issueTypeId) {
        return this.getCustomFieldObjects(projectId, issueTypeId == null ? null : Lists.newArrayList((Object[])new String[]{issueTypeId}));
    }

    public List<CustomField> getCustomFieldObjects(Long projectId, List<String> issueTypeIds) {
        Project project = this.projectManager.getProjectObj(projectId);
        List expandedIssueTypeIds = this.constantsManager.expandIssueTypeIds(issueTypeIds);
        return this.getCustomFieldObjects().stream().filter(customField -> customField.isInScopeForSearch(project, expandedIssueTypeIds)).collect(Collectors.toList());
    }

    public List<CustomField> getCustomFieldObjects(SearchContext searchContext) {
        return this.getCustomFieldObjects().stream().filter(customField -> customField.isInScope(searchContext)).collect(Collectors.toList());
    }

    @Nullable
    public CustomField getCustomFieldObject(Long id) {
        return this.cache.get().get(id);
    }

    private Optional<CustomField> getCustomFieldOptional(Long id) {
        return Optional.ofNullable(this.getCustomFieldObject(id));
    }

    @Nullable
    public CustomField getCustomFieldObject(String key) {
        Optional<Long> id = Optional.ofNullable(CustomFieldUtils.getCustomFieldId((String)key));
        return id.map(this::getCustomFieldObject).orElse(null);
    }

    public boolean isCustomField(String id) {
        return id != null && id.startsWith("customfield_");
    }

    public boolean exists(String key) {
        return this.getCustomFieldObject(key) != null;
    }

    @Nullable
    public CustomField getCustomFieldObjectByName(String customFieldName) {
        Collection<CustomField> values = this.getCustomFieldObjectsByName(customFieldName);
        if (values.size() > 1) {
            this.logReturningFirstCustomFieldWarning(values.size(), customFieldName);
        }
        return values.stream().findFirst().orElse(null);
    }

    private void logReturningFirstCustomFieldWarning(int size, String customFieldName) {
        String msg = "Warning: returning 1 of " + size + " custom fields named '" + customFieldName + '\'';
        if (log.isDebugEnabled()) {
            log.warn(msg, new Throwable());
        } else {
            log.warn(msg);
        }
    }

    public Collection<CustomField> getCustomFieldObjectsByName(String customFieldName) {
        return this.cache.get().getAllByName(customFieldName);
    }

    public List<CustomField> getCustomFieldObjects() {
        ArrayList<CustomField> fields = new ArrayList<CustomField>(this.cache.get().getAll());
        Collections.sort(fields, CustomFieldComparators.byName());
        return fields;
    }

    public List<CustomField> getGlobalCustomFieldObjects() {
        return this.getCustomFieldObjects().stream().filter(CustomField::isGlobal).collect(Collectors.toList());
    }

    public void refresh() {
        this.refreshConfigurationSchemes(null);
        this.refreshSearchersAndIndexers();
    }

    public void refreshConfigurationSchemes(Long customFieldId) {
        this.fieldConfigSchemeManager.init();
        this.cache.reset();
    }

    public void refreshConfiguration() {
        this.fieldManager.refresh();
        this.cache.reset();
    }

    private void refreshSearchersAndIndexers() {
        IssueSearcherManager issueSearcherManager = (IssueSearcherManager)ComponentAccessor.getComponent(IssueSearcherManager.class);
        issueSearcherManager.refresh();
        FieldIndexerManager fieldIndexerManager = (FieldIndexerManager)ComponentAccessor.getComponent(FieldIndexerManager.class);
        fieldIndexerManager.refresh();
    }

    public void clear() {
        this.cache.reset();
    }

    public void removeCustomFieldPossiblyLeavingOrphanedData(Long customFieldId) throws RemoveException {
        CustomField originalCustomField = this.getCustomFieldObject((Long)Assertions.notNull((String)ID, (Object)customFieldId));
        if (originalCustomField != null) {
            this.removeCustomField(originalCustomField);
        } else {
            this.removeCustomFieldDirectlyFromDb(customFieldId);
        }
    }

    private void removeCustomFieldDirectlyFromDb(Long customFieldId) throws RemoveException {
        log.debug("Couldn't load customfield object for id '" + customFieldId + "'.  Trying to lookup field directly via the db.  Please note that deleting a custom field this way may leave some custom field data behind.");
        Optional.ofNullable(this.dbConnectionManager.withNewConnection().executeQuery(callback -> (CustomFieldDTO)((SQLQuery)((SQLQuery)((SQLQuery)callback.newSqlQuery().from((Expression)QCustomField.CUSTOM_FIELD)).select((Expression)QCustomField.CUSTOM_FIELD).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)customFieldId))).limit(1L)).fetchOne())).orElseThrow(() -> new IllegalArgumentException("Tried to remove custom field with id '" + customFieldId + "' that doesn't exist!"));
        log.debug("Customfield with id '" + customFieldId + "' retrieved successfully via the db.");
        String customFieldStringId = "customfield_" + customFieldId;
        this.removeCustomFieldAssociations(customFieldStringId);
        this.customFieldValuePersister.removeAllValues(customFieldStringId);
        this.dbConnectionManager.withNewConnection().execute(connection -> connection.delete((RelationalPath<?>)QCustomField.CUSTOM_FIELD).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)customFieldId)).execute());
        this.fieldManager.refresh();
    }

    public void removeCustomField(CustomField customField) throws RemoveException {
        this.removeCustomFieldAssociations(customField.getId());
        customField.remove();
        this.refreshConfiguration();
    }

    private void removeCustomFieldAssociations(String customFieldId) throws RemoveException {
        this.fieldScreenManager.removeFieldScreenItems(customFieldId);
        this.dbConnectionManager.withNewConnection().execute(connection -> {
            connection.delete((RelationalPath<?>)QColumnLayoutItem.COLUMN_LAYOUT_ITEM).where((Predicate)QColumnLayoutItem.COLUMN_LAYOUT_ITEM.fieldidentifier.eq((Object)customFieldId)).execute();
            connection.delete((RelationalPath<?>)QFieldLayoutItem.FIELD_LAYOUT_ITEM).where((Predicate)QFieldLayoutItem.FIELD_LAYOUT_ITEM.fieldidentifier.eq((Object)customFieldId)).execute();
        });
        this.fieldConfigSchemeManager.removeInvalidFieldConfigSchemesForCustomField(customFieldId);
        this.notificationSchemeManager.removeSchemeEntitiesForField(customFieldId);
    }

    public void removeCustomFieldValues(GenericValue issue) throws GenericEntityException {
        this.dbConnectionManager.withNewConnection().execute(connection -> connection.delete((RelationalPath<?>)QCustomFieldValue.CUSTOM_FIELD_VALUE).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.eq((Object)issue.getLong(ID))).execute());
    }

    public void updateCustomField(Long id, String name, String description, CustomFieldSearcher searcher) {
        CustomField oldCustomField = this.getCustomFieldOptional(id).orElseThrow(() -> new DataAccessException("Cannot update custom field that does not exist"));
        String searcherKey = Optional.ofNullable(searcher).map(s -> s.getDescriptor().getCompleteKey()).orElse(null);
        this.dbConnectionManager.withNewConnection().execute(connection -> connection.update((RelationalPath<?>)QCustomField.CUSTOM_FIELD).set((Path)QCustomField.CUSTOM_FIELD.name, (Object)name).set((Path)QCustomField.CUSTOM_FIELD.description, (Object)description).set((Path)QCustomField.CUSTOM_FIELD.customfieldsearcherkey, (Object)searcherKey).where((Predicate)QCustomField.CUSTOM_FIELD.id.eq((Object)id)).execute());
        this.cache.reset();
        CustomField newCustomField = this.getCustomFieldObject(id);
        this.eventPublisher.publish((Object)new CustomFieldUpdatedEvent(newCustomField, oldCustomField));
        if (!this.areConfigSchemesEqual(newCustomField.getConfigurationSchemes(), oldCustomField.getConfigurationSchemes())) {
            this.fieldManager.refresh();
        } else if (searcher != oldCustomField.getCustomFieldSearcher()) {
            this.refreshSearchersAndIndexers();
        }
    }

    protected boolean areConfigSchemesEqual(List<FieldConfigScheme> schemes, List<FieldConfigScheme> otherSchemes) {
        if (schemes != null && otherSchemes != null) {
            return HashMultiset.create(schemes).equals((Object)HashMultiset.create(otherSchemes));
        }
        return schemes == null && otherSchemes == null;
    }

    public CustomField getCustomFieldInstance(GenericValue customFieldGv) {
        return this.customFieldFactory.create(customFieldGv);
    }

    public void removeProjectAssociations(Project project) {
        this.contextPersister.removeContextsForProject(project);
        this.refresh();
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @TenantInfo(value=TenantAware.TENANTED)
    private final class CustomFieldInMemoryStore {
        private final Map<Long, CustomField> byId;
        private final Multimap<String, CustomField> byName;

        private CustomFieldInMemoryStore(Collection<CustomField> customFields) {
            this.byId = Maps.uniqueIndex(customFields, CustomField::getIdAsLong);
            this.byName = Multimaps.index(customFields, Field::getName);
        }

        @Nullable
        private CustomField get(Long id) {
            return this.byId.get(id);
        }

        @Nonnull
        private Collection<CustomField> getAllByName(String name) {
            return this.byName.get((Object)name);
        }

        @Nonnull
        private Collection<CustomField> getAll() {
            return this.byId.values();
        }
    }
}

