/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.statistics.util.PrefixFieldableHitCollector;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Set;
import java.util.TreeSet;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;

public class PrefixSearchLabelsProvider {
    private final IssueIndexManager issueIndexManager;

    public PrefixSearchLabelsProvider(IssueIndexManager issueIndexManager) {
        this.issueIndexManager = issueIndexManager;
    }

    public Set<String> findByPrefixToken(String prefix, String searchField, String displayField, ApplicationUser searchUser) {
        TreeSet<String> suggestions = new TreeSet<String>();
        try {
            this.getSearchProvider().search(new SearchRequest().getQuery(), searchUser, (Collector)this.createCollector(prefix, displayField, suggestions), this.createLuceneQuery(prefix, searchField));
        }
        catch (SearchException e) {
            throw new RuntimeException(e);
        }
        return suggestions;
    }

    private PrefixFieldableHitCollector createCollector(String prefix, String displayField, Set<String> suggestions) {
        return new PrefixFieldableHitCollector(this.issueIndexManager.getIssueSearcher(), displayField, prefix, suggestions);
    }

    private Query createLuceneQuery(String prefix, String searchField) {
        return new PrefixQuery(new Term(searchField, prefix.toLowerCase()));
    }

    private SearchProvider getSearchProvider() {
        return (SearchProvider)ComponentAccessor.getComponentOfType(SearchProvider.class);
    }
}

