/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label.suggestions;

import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.suggestions.PopularLabelsProvider;
import com.atlassian.jira.issue.label.suggestions.PrefixSearchLabelsProvider;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class LabelSuggester {
    private final PopularLabelsProvider popularLabelsProvider;
    private final PrefixSearchLabelsProvider prefixSearchLabelsProvider;

    public LabelSuggester(PopularLabelsProvider popularLabelsProvider, PrefixSearchLabelsProvider prefixSearchLabelsProvider) {
        this.popularLabelsProvider = popularLabelsProvider;
        this.prefixSearchLabelsProvider = prefixSearchLabelsProvider;
    }

    public Set<String> getSuggestedLabels(String token, Long issueId, Set<Label> issueLabels, ApplicationUser user) {
        return this.getSuggestions(token, issueId, issueLabels, "labels_folded", "labels", user);
    }

    public Set<String> getSuggestedLabels(String token, Long issueId, Long customFieldId, Set<Label> issueLabels, ApplicationUser user) {
        String searchField = "customfield_" + customFieldId;
        return this.getSuggestions(token, issueId, issueLabels, searchField, searchField, user);
    }

    private Set<String> getSuggestions(String token, Long issueId, Set<Label> issueLabels, String searchField, String displayField, ApplicationUser user) {
        Set<String> suggestions = StringUtils.isEmpty((String)token) ? this.popularLabelsProvider.findMostPopular(displayField, user) : this.prefixSearchLabelsProvider.findByPrefixToken(token, searchField, displayField, user);
        return this.postProcessSuggestions(issueId, suggestions, issueLabels, token);
    }

    private Set<String> postProcessSuggestions(Long issueId, Set<String> suggestions, Set<Label> issueLabels, String token) {
        Set<String> result = suggestions;
        if (issueId != null) {
            result = this.removeSuggestionsFoundInIssueLabels(suggestions, issueLabels.stream().map(Label::getLabel).collect(Collectors.toSet()));
        }
        if (StringUtils.isEmpty((String)token)) {
            return result;
        }
        return this.orderSuggestionsByMatchingTokenFirst(result, token);
    }

    private Set<String> removeSuggestionsFoundInIssueLabels(Set<String> suggestions, Set<String> issueLabels) {
        return Sets.filter(suggestions, suggestion -> !issueLabels.contains(suggestion));
    }

    private Set<String> orderSuggestionsByMatchingTokenFirst(Set<String> suggestions, String token) {
        LinkedHashSet<String> orderedSuggestions = new LinkedHashSet<String>(suggestions.size());
        orderedSuggestions.addAll(Sets.filter(suggestions, label -> label.startsWith(token)));
        orderedSuggestions.addAll(Sets.filter(suggestions, label -> !label.startsWith(token)));
        return orderedSuggestions;
    }
}

