/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelManager;
import com.atlassian.jira.issue.label.LabelParser;
import com.atlassian.jira.issue.label.LabelStore;
import com.atlassian.jira.issue.label.suggestions.LabelSuggester;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class DefaultLabelManager
implements LabelManager {
    private final LabelStore labelStore;
    private final IssueManager issueManager;
    private final IssueUpdater issueUpdater;
    private final LabelSuggester labelSuggester;

    public DefaultLabelManager(LabelStore labelStore, IssueManager issueManager, IssueUpdater issueUpdater, LabelSuggester labelSuggester) {
        this.labelStore = labelStore;
        this.issueManager = issueManager;
        this.issueUpdater = issueUpdater;
        this.labelSuggester = labelSuggester;
    }

    protected CustomFieldManager getFieldManager() {
        return (CustomFieldManager)ComponentAccessor.getComponentOfType(CustomFieldManager.class);
    }

    public Set<Label> getLabels(Long issueId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        return this.labelStore.getLabels(issueId, null);
    }

    public Set<Label> setLabels(ApplicationUser remoteUser, Long issueId, Set<String> labels, boolean sendNotification, boolean causesChangeNotification) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"labels", labels);
        this.validateLabels(labels);
        Issue issue = this.findIssue(issueId);
        return this.setIfNotEqual(issue, labels, null, remoteUser, sendNotification, causesChangeNotification);
    }

    public Set<Label> getLabels(Long issueId, Long customFieldId) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        return this.labelStore.getLabels(issueId, customFieldId);
    }

    public Set<Label> setLabels(ApplicationUser remoteUser, Long issueId, Long customFieldId, Set<String> labels, boolean sendNotification, boolean causesChangeNotification) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        Assertions.notNull((String)"labels", labels);
        this.validateLabels(labels);
        Issue issue = this.findIssue(issueId);
        return this.setIfNotEqual(issue, labels, customFieldId, remoteUser, sendNotification, causesChangeNotification);
    }

    public Label addLabel(ApplicationUser remoteUser, Long issueId, String label, boolean sendNotification) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"label", (Object)label);
        this.validateSingleLabel(label);
        Issue issue = this.findIssue(issueId);
        return this.addIfNotContains(issue, label, null, remoteUser, sendNotification);
    }

    public Label addLabel(ApplicationUser remoteUser, Long issueId, Long customFieldId, String label, boolean sendNotification) {
        Assertions.notNull((String)"issueId", (Object)issueId);
        Assertions.notNull((String)"label", (Object)label);
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        this.validateSingleLabel(label);
        return this.addIfNotContains(this.findIssue(issueId), label, customFieldId, remoteUser, sendNotification);
    }

    private Set<Label> setIfNotEqual(Issue issue, Set<String> labels, Long customFieldId, ApplicationUser remoteUser, boolean sendNotification, boolean causesChangeNotification) {
        Set<Label> oldLabels = this.labelStore.getLabels(issue.getId(), customFieldId);
        if (this.differentLabels(labels, oldLabels)) {
            Set<Label> newLabels = this.labelStore.setLabels(issue.getId(), customFieldId, labels);
            if (causesChangeNotification) {
                this.issueUpdated(newLabels, oldLabels, issue, customFieldId, remoteUser, sendNotification);
            }
            return newLabels;
        }
        return oldLabels;
    }

    private Label addIfNotContains(Issue issue, String label, Long customFieldId, ApplicationUser remoteUser, boolean sendNotification) {
        Set<Label> oldLabels = this.labelStore.getLabels(issue.getId(), customFieldId);
        if (this.containsLabel(label, oldLabels)) {
            return this.getLabel(label, oldLabels);
        }
        Label newLabel = this.labelStore.addLabel(issue.getId(), customFieldId, label);
        this.issueUpdated(newLabel, oldLabels, issue, customFieldId, remoteUser, sendNotification);
        return newLabel;
    }

    public Set<Long> removeLabelsForCustomField(Long customFieldId) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        return this.labelStore.removeLabelsForCustomField(customFieldId);
    }

    public Set<String> getSuggestedLabels(ApplicationUser user, Long issueId, String token) {
        Set<Label> issueLabels = issueId != null ? this.getLabels(issueId) : Collections.emptySet();
        return this.labelSuggester.getSuggestedLabels(token, issueId, issueLabels, user);
    }

    public Set<String> getSuggestedLabels(ApplicationUser user, Long issueId, Long customFieldId, String token) {
        Assertions.notNull((String)"customFieldId", (Object)customFieldId);
        Set<Label> issueLabels = issueId != null ? this.getLabels(issueId) : Collections.emptySet();
        return this.labelSuggester.getSuggestedLabels(token, issueId, customFieldId, issueLabels, user);
    }

    private Issue findIssue(Long issueId) {
        MutableIssue issue = this.issueManager.getIssueObject(issueId);
        if (issue == null) {
            throw new IllegalArgumentException("Issue with id '" + issueId + "' no longer exists!");
        }
        return issue;
    }

    private boolean differentLabels(Set<String> labels, Set<Label> existingLabels) {
        if (labels.size() != existingLabels.size()) {
            return true;
        }
        return !labels.containsAll(this.asSortedStringLabels(existingLabels));
    }

    private boolean containsLabel(String label, Set<Label> labels) {
        for (Label issueLabel : labels) {
            if (!issueLabel.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    private Label getLabel(String label, Set<Label> labels) {
        for (Label issueLabel : labels) {
            if (!issueLabel.getLabel().equals(label)) continue;
            return issueLabel;
        }
        throw new IllegalArgumentException("The label <" + label + "> not found in the issue");
    }

    private void issueUpdated(Label label, Set<Label> oldLabels, Issue originalIssue, Long customFieldId, ApplicationUser remoteUser, boolean sendNotification) {
        this.issueUpdated(this.joinLabels(label, oldLabels), oldLabels, originalIssue, customFieldId, remoteUser, sendNotification);
    }

    private Set<Label> joinLabels(Label label, Set<Label> oldLabels) {
        HashSet<Label> answer = new HashSet<Label>(oldLabels);
        answer.add(label);
        return answer;
    }

    private void issueUpdated(Set<Label> newLabels, Set<Label> oldLabels, Issue originalIssue, Long customFieldId, ApplicationUser remoteUser, boolean sendNotification) {
        IssueUpdateBean updateBean = this.createIssueUpdateBean(remoteUser, originalIssue, sendNotification);
        updateBean.setChangeItems((Collection)Lists.newArrayList((Object[])new ChangeItemBean[]{this.createLabelsChangeItem(newLabels, oldLabels, customFieldId)}));
        this.doUpdate(updateBean);
    }

    private IssueUpdateBean createIssueUpdateBean(ApplicationUser remoteUser, Issue originalIssue, boolean sendNotification) {
        MutableIssue updated = this.issueManager.getIssueObject(originalIssue.getId());
        return new IssueUpdateBean((Issue)updated, originalIssue, EventType.ISSUE_UPDATED_ID, remoteUser, sendNotification, false);
    }

    private ChangeItemBean createLabelsChangeItem(Set<Label> newLabels, Set<Label> oldLabels, Long customFieldId) {
        return new ChangeItemBean(this.resolveFieldType(customFieldId), this.resolveFieldName(customFieldId), null, this.toString(oldLabels), null, this.toString(newLabels));
    }

    private String resolveFieldType(Long customFieldId) {
        if (customFieldId == null) {
            return "jira";
        }
        return "custom";
    }

    private String resolveFieldName(Long customFieldId) {
        if (customFieldId == null) {
            return "labels";
        }
        return this.getFromCustomField(customFieldId);
    }

    private String getFromCustomField(Long customFieldId) {
        CustomField field = this.getFieldManager().getCustomFieldObject(customFieldId);
        if (field == null) {
            throw new IllegalArgumentException("No custom field with ID [" + customFieldId + "] found");
        }
        return field.getName();
    }

    private String toString(Set<Label> labels) {
        if (labels.isEmpty()) {
            return "";
        }
        StringBuilder accumulator = new StringBuilder(labels.size() * 8);
        for (String label : this.asSortedStringLabels(labels)) {
            accumulator.append(label).append(" ");
        }
        return accumulator.deleteCharAt(accumulator.length() - 1).toString();
    }

    private Set<String> asSortedStringLabels(Set<Label> labels) {
        TreeSet<String> strings = new TreeSet<String>();
        for (Label label : labels) {
            strings.add(label.getLabel());
        }
        return strings;
    }

    private void doUpdate(IssueUpdateBean updateBean) {
        this.issueUpdater.doUpdate(updateBean, false);
    }

    private void validateLabels(Set<String> labels) {
        for (String theLabel : labels) {
            this.validateSingleLabel(theLabel);
        }
    }

    private void validateSingleLabel(String theLabel) {
        String label = theLabel.trim();
        if (StringUtils.isBlank((String)label)) {
            throw new IllegalArgumentException("Labels cannot be blank!");
        }
        if (!LabelParser.isValidLabelName((String)label)) {
            throw new IllegalArgumentException("The label '" + label + "' contained spaces which is invalid.");
        }
        if (label.length() > 255) {
            throw new IllegalArgumentException("The label '" + label + "' exceeds the maximum length allowed for labels of " + 255 + " characters.");
        }
    }
}

