/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.label;

import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.label.Label;
import com.atlassian.jira.issue.label.LabelStore;
import com.atlassian.jira.issue.label.OfBizLabelStore;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@TenantInfo(value=TenantAware.UNRESOLVED, comment="This class is tenanted, but cannot be marked as such until only vcache is used.")
@EventComponent
public class CachingLabelStore
implements LabelStore,
Startable {
    private static final String DARK_FEATURE_REQUEST_CACHE_KEY = "jira.jvc.CachingLabelStore.caches.request";
    private final OfBizLabelStore delegateStore;
    @TenantInfo(value=TenantAware.TENANTED)
    private CacheAdapter<CacheKey, Set<Label>> cache;

    public CachingLabelStore(OfBizLabelStore delegateStore, SwitchingCacheFactory cacheFactory) {
        this.delegateStore = delegateStore;
        this.cache = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".cache", Optional.of(new CacheSettingsBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).maxEntries(1000).build()), DARK_FEATURE_REQUEST_CACHE_KEY);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.removeAll();
    }

    @Override
    public Set<Label> getLabels(Long issueId, Long customFieldId) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        return (Set)this.cache.get(key, () -> this.loadCacheLabels(key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Label> setLabels(Long issueId, Long customFieldId, Set<String> labels) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        try {
            Set<Label> set = this.delegateStore.setLabels(issueId, customFieldId, labels);
            return set;
        }
        finally {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Label addLabel(Long issueId, Long customFieldId, String label) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        try {
            Label label2 = this.delegateStore.addLabel(issueId, customFieldId, label);
            return label2;
        }
        finally {
            this.cache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLabel(Long labelId, Long issueId, Long customFieldId) {
        CacheKey key = new CacheKey(issueId, customFieldId);
        try {
            this.delegateStore.removeLabel(labelId, issueId, customFieldId);
        }
        finally {
            this.cache.remove(key);
        }
    }

    @Override
    public Set<Long> removeLabelsForCustomField(Long customFieldId) {
        try {
            Set<Long> set = this.delegateStore.removeLabelsForCustomField(customFieldId);
            return set;
        }
        finally {
            this.cache.removeAll();
        }
    }

    public void start() throws Exception {
    }

    private Set<Label> loadCacheLabels(CacheKey key) {
        return Collections.unmodifiableSet(this.delegateStore.getLabels(key.getIssueId(), key.getFieldId()));
    }

    static final class CacheKey
    implements Serializable {
        private final Long issueId;
        private final Long fieldId;

        CacheKey(Long issueId, Long fieldId) {
            this.issueId = issueId;
            this.fieldId = fieldId;
        }

        public Long getFieldId() {
            return this.fieldId;
        }

        public Long getIssueId() {
            return this.issueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (this.fieldId != null ? !this.fieldId.equals(cacheKey.fieldId) : cacheKey.fieldId != null) {
                return false;
            }
            return this.issueId.equals(cacheKey.issueId);
        }

        public int hashCode() {
            int result = this.issueId.hashCode();
            result = 31 * result + (this.fieldId != null ? this.fieldId.hashCode() : 0);
            return result;
        }
    }
}

