/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.issue.index.indexers.phrase.PhraseQuerySupportField;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;

public class DescriptionIndexer
extends BaseFieldIndexer {
    public DescriptionIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
    }

    public String getId() {
        return SystemSearchConstants.forDescription().getFieldId();
    }

    public String getDocumentFieldId() {
        return SystemSearchConstants.forDescription().getIndexField();
    }

    public void addIndex(Document doc, Issue issue) {
        String descValue = issue.getDescription();
        this.indexText(doc, this.getDocumentFieldId(), descValue, issue);
        this.indexText(doc, PhraseQuerySupportField.forIndexField((String)this.getDocumentFieldId()), descValue, issue);
        this.indexTextForSorting(doc, "sort_description", descValue, issue);
    }
}

