/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.indexers.impl.BaseFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class AttachmentIndexer
extends BaseFieldIndexer {
    private final FieldVisibilityManager fieldVisibilityManager;

    public AttachmentIndexer(FieldVisibilityManager fieldVisibilityManager) {
        super(fieldVisibilityManager);
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public String getId() {
        return "attachment";
    }

    public String getDocumentFieldId() {
        return "issue_has_attachment";
    }

    public void addIndex(Document doc, Issue issue) {
        this.indexAttachment(doc, this.hasAttachments(issue));
    }

    private boolean hasAttachments(Issue issue) {
        return issue.getAttachments() != null && !issue.getAttachments().isEmpty();
    }

    private void indexAttachment(Document doc, boolean hasAttachment) {
        doc.add((Fieldable)new Field(this.getDocumentFieldId(), String.valueOf(hasAttachment), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    @Override
    public boolean isFieldVisibleAndInScope(Issue issue) {
        return this.fieldVisibilityManager.isFieldVisible("attachment", issue);
    }
}

