/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.fugue.Option;
import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.index.EntityDocumentFactory;
import com.atlassian.jira.index.SearchExtractorRegistrationManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.index.WorklogDocumentFactory;
import com.atlassian.jira.issue.worklog.Worklog;
import com.atlassian.jira.util.LuceneUtils;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;

public class DefaultWorklogDocumentFactory
implements WorklogDocumentFactory {
    private final SearchExtractorRegistrationManager searchExtractorManager;

    public DefaultWorklogDocumentFactory(SearchExtractorRegistrationManager searchExtractorManager) {
        this.searchExtractorManager = searchExtractorManager;
    }

    public Option<Document> apply(Worklog worklog) {
        if (worklog == null) {
            return Option.none();
        }
        Issue issue = worklog.getIssue();
        Builder builder = (Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder(worklog).addField("projid", String.valueOf(issue.getProjectId()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("issue_id", String.valueOf(issue.getId()), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("worklog_id", String.valueOf(worklog.getId()), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("worklog_date", LuceneUtils.localDateToString((LocalDate)LocalDateFactory.from((Date)worklog.getStartDate())), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addKeywordWithDefault("worklog_level", worklog.getGroupLevel(), "-1")).addKeywordWithDefault("worklog_role_level", worklog.getRoleLevel() != null ? worklog.getRoleLevel().getId() : null, "-1")).addAllExtractors(this.searchExtractorManager.findExtractorsForEntity(Worklog.class));
        if (worklog.getAuthorKey() != null) {
            ((Builder)((Builder)builder.addField("worklog_author", worklog.getAuthorKey(), Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("visiblefieldids", "worklog_author", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS)).addField("nonemptyfieldids", "worklog_author", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
        }
        if (worklog.getComment() != null) {
            ((Builder)builder.addField("worklog_comment", worklog.getComment(), Field.Store.NO, Field.Index.ANALYZED_NO_NORMS)).addField("visiblefieldids", "worklog_comment", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            if (StringUtils.isNotEmpty((String)worklog.getComment())) {
                builder.addField("nonemptyfieldids", "worklog_comment", Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS);
            }
        }
        return builder.build();
    }

    @Override
    public Term getIdentifyingTerm(Worklog worklog) {
        return new Term("worklog_id", worklog.getId().toString());
    }

    private static class Builder
    extends EntityDocumentFactory.EntityDocumentBuilder<Worklog, Builder> {
        private Builder(Worklog entity) {
            super(entity, "worklog");
        }
    }
}

