/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.issue.index.ChangeHistoryFieldConfigurationManager;
import com.atlassian.jira.issue.index.IndexedChangeHistoryField;
import com.atlassian.jira.issue.index.IndexedChangeHistoryFieldManager;
import com.atlassian.query.operator.Operator;
import com.atlassian.util.concurrent.LazyReference;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexedChangeHistoryFieldManager
implements IndexedChangeHistoryFieldManager {
    private final LazyReference<Map<String, IndexedChangeHistoryField>> ref = new LazyReference<Map<String, IndexedChangeHistoryField>>(){

        protected Map<String, IndexedChangeHistoryField> create() throws Exception {
            return DefaultIndexedChangeHistoryFieldManager.this.loadChangeHistoryFields();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexedChangeHistoryFieldManager.class);
    private final ChangeHistoryFieldConfigurationManager changeHistoryFieldConfigurationManager;

    public DefaultIndexedChangeHistoryFieldManager(ChangeHistoryFieldConfigurationManager changeHistoryFieldConfigurationManager) {
        this.changeHistoryFieldConfigurationManager = changeHistoryFieldConfigurationManager;
    }

    public Collection<IndexedChangeHistoryField> getIndexedChangeHistoryFields() {
        return Collections.unmodifiableCollection(((Map)this.ref.get()).values());
    }

    @ClusterSafe(value="LOCAL_CACHE")
    public synchronized void addIndexedChangeHistoryField(IndexedChangeHistoryField field) {
        ((Map)this.ref.get()).put(field.getFieldName(), field);
    }

    @ClusterSafe(value="LOCAL_CACHE")
    public synchronized void deleteIndexedChangeHistoryField(IndexedChangeHistoryField field) {
        ((Map)this.ref.get()).remove(field.getFieldName());
    }

    public Collection<String> getIndexedChangeHistoryFieldNames() {
        return ((Map)this.ref.get()).keySet();
    }

    public Set<Operator> getSupportedOperators(String fieldName, Set<Operator> operators) {
        IndexedChangeHistoryField field = (IndexedChangeHistoryField)((Map)this.ref.get()).get(fieldName);
        return field != null ? field.getSupportedOperators(operators) : operators;
    }

    private Map<String, IndexedChangeHistoryField> loadChangeHistoryFields() {
        HashMap<String, IndexedChangeHistoryField> fields = new HashMap<String, IndexedChangeHistoryField>();
        for (String fieldName : this.changeHistoryFieldConfigurationManager.getAllFieldNames()) {
            fields.put(fieldName, new IndexedChangeHistoryField(fieldName, this.changeHistoryFieldConfigurationManager.getDateRangeBuilder(fieldName)));
        }
        return fields;
    }
}

