/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.screen;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.Field;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.HackyFieldRendererRegistry;
import com.atlassian.jira.issue.fields.screen.BulkFieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.BulkFieldScreenRendererImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreen;
import com.atlassian.jira.issue.fields.screen.FieldScreenLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTabImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenTab;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.workflow.WorkflowActionsBean;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BulkFieldScreenRendererFactory {
    private static final Logger log = LoggerFactory.getLogger(BulkFieldScreenRendererFactory.class);
    private final FieldManager fieldManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final HackyFieldRendererRegistry hackyFieldRendererRegistry;

    BulkFieldScreenRendererFactory(FieldManager fieldManager, FieldLayoutManager fieldLayoutManager, HackyFieldRendererRegistry hackyFieldRendererRegistry) {
        this.hackyFieldRendererRegistry = hackyFieldRendererRegistry;
        this.fieldManager = (FieldManager)Assertions.notNull((String)"fieldManager", (Object)fieldManager);
        this.fieldLayoutManager = (FieldLayoutManager)Assertions.notNull((String)"fieldLayoutManager", (Object)fieldLayoutManager);
    }

    BulkFieldScreenRendererImpl createRenderer(Collection<Issue> issues, ActionDescriptor actionDescriptor) {
        Collection<FieldLayout> fieldLayouts = this.getFieldLayouts(issues);
        Set unavailableFields = this.fieldManager.getUnavailableFields();
        List<FieldScreenTab> fieldScreenTabs = this.getScreenTabs(actionDescriptor);
        ArrayList<FieldScreenRenderTab> fieldScreenRenderTabs = new ArrayList<FieldScreenRenderTab>();
        int i = 0;
        for (FieldScreenTab fieldScreenTab : fieldScreenTabs) {
            List fieldScreenLayoutItems = fieldScreenTab.getFieldScreenLayoutItems();
            ArrayList<FieldScreenRenderLayoutItem> fieldScreenRenderLayoutItems = new ArrayList<FieldScreenRenderLayoutItem>(fieldScreenLayoutItems.size());
            for (FieldScreenLayoutItem fieldScreenLayoutItem : fieldScreenLayoutItems) {
                OrderableField field = fieldScreenLayoutItem.getOrderableField();
                if (field == null || unavailableFields.contains(field)) continue;
                ArrayList<FieldLayoutItem> fieldLayoutItems = new ArrayList<FieldLayoutItem>(fieldLayouts.size());
                for (FieldLayout fieldLayout : fieldLayouts) {
                    fieldLayoutItems.add(fieldLayout.getFieldLayoutItem(field));
                }
                if (this.fieldManager.isCustomField((Field)field)) {
                    CustomField customField = (CustomField)field;
                    if (!customField.getCustomFieldType().getDescriptor().isViewTemplateExists()) continue;
                    BulkFieldScreenRenderLayoutItemImpl fieldScreenRenderLayoutItem = new BulkFieldScreenRenderLayoutItemImpl(this.fieldManager, this.hackyFieldRendererRegistry, fieldScreenLayoutItem, fieldLayoutItems);
                    fieldScreenRenderLayoutItems.add(fieldScreenRenderLayoutItem);
                    continue;
                }
                BulkFieldScreenRenderLayoutItemImpl fieldScreenRenderLayoutItem = new BulkFieldScreenRenderLayoutItemImpl(this.fieldManager, this.hackyFieldRendererRegistry, fieldScreenLayoutItem, fieldLayoutItems);
                fieldScreenRenderLayoutItems.add(fieldScreenRenderLayoutItem);
            }
            if (fieldScreenRenderLayoutItems.isEmpty()) continue;
            fieldScreenRenderTabs.add(new FieldScreenRenderTabImpl(fieldScreenTab.getName(), i++, fieldScreenRenderLayoutItems));
        }
        return new BulkFieldScreenRendererImpl(fieldScreenRenderTabs);
    }

    private List<FieldScreenTab> getScreenTabs(ActionDescriptor actionDescriptor) {
        FieldScreen fieldScreen = this.getScreen(actionDescriptor);
        return fieldScreen == null ? Collections.emptyList() : fieldScreen.getTabs();
    }

    FieldScreen getScreen(ActionDescriptor actionDescriptor) {
        WorkflowActionsBean workflowActionsBean = new WorkflowActionsBean();
        return workflowActionsBean.getFieldScreenForView(actionDescriptor);
    }

    private Collection<FieldLayout> getFieldLayouts(Collection<Issue> issues) {
        HashSet<FieldLayout> fieldLayouts = new HashSet<FieldLayout>();
        for (Issue issue : issues) {
            try {
                fieldLayouts.add(this.fieldLayoutManager.getFieldLayout(issue));
            }
            catch (DataAccessException e) {
                log.error("Unable to retrieve the fieldlayout associated with the issue: " + issue.getKey() + ".", (Throwable)e);
            }
        }
        return fieldLayouts;
    }
}

