/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.dto;

import com.atlassian.core.util.FileSize;
import com.atlassian.core.util.thumbnail.Thumbnail;
import com.atlassian.jira.bc.issue.attachment.FileNameBasedVersionedAttachmentsList;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.AttachmentIndexManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.fields.rest.json.dto.AttachmentViewDtoConverter;
import com.atlassian.jira.issue.fields.rest.json.dto.AttachmentViewJsonDto;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.issue.thumbnail.ThumbnailedImage;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public final class AttachmentViewDtoConverterImpl
implements AttachmentViewDtoConverter {
    private final ThumbnailManager thumbnailManager;
    private final JiraAuthenticationContext authenticationContext;
    private final ApplicationProperties applicationProperties;
    private final AttachmentIndexManager attachmentIndexManager;
    private final IssueManager issueManager;
    private final PermissionManager permissionManager;
    private final DateTimeFormatter dateTimeFormatter;
    private final UserManager userManager;

    public AttachmentViewDtoConverterImpl(ThumbnailManager thumbnailManager, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, AttachmentIndexManager attachmentIndexManager, IssueManager issueManager, PermissionManager permissionManager, DateTimeFormatter dateTimeFormatter, UserManager userManager) {
        this.thumbnailManager = thumbnailManager;
        this.authenticationContext = authenticationContext;
        this.applicationProperties = applicationProperties;
        this.attachmentIndexManager = attachmentIndexManager;
        this.issueManager = issueManager;
        this.permissionManager = permissionManager;
        this.dateTimeFormatter = dateTimeFormatter;
        this.userManager = userManager;
    }

    public List<AttachmentViewJsonDto> convert(List<Attachment> attachments) {
        final FileNameBasedVersionedAttachmentsList attachmentsList = new FileNameBasedVersionedAttachmentsList(attachments);
        final ApplicationUser loggedInUser = this.authenticationContext.getUser();
        final DateTimeFormatter userDateTimeFormatter = this.dateTimeFormatter.forUser(this.authenticationContext.getLoggedInUser()).withStyle(DateTimeStyle.COMPLETE);
        Iterable extendedBeans = Iterables.transform(attachments, (Function)new Function<Attachment, AttachmentViewJsonDto>(){
            private Map<Long, Issue> issueById = new HashMap<Long, Issue>(1);

            private Issue getIssue(Attachment attachment) {
                Long issueId = attachment.getIssueId();
                Issue issue = this.issueById.get(issueId);
                if (issue == null) {
                    issue = attachment.getIssue();
                    this.issueById.put(issueId, issue);
                }
                return issue;
            }

            public AttachmentViewJsonDto apply(Attachment attachment) {
                int thumbnailedImageHeight;
                int thumbnailedImageWidth;
                URI thumbnailUrl;
                Issue issue = this.getIssue(attachment);
                String urlEncodedFileName = JiraUrlCodec.encode((String)attachment.getFilename(), (boolean)true);
                Thumbnail thumbnail = AttachmentViewDtoConverterImpl.this.thumbnailManager.getThumbnail(issue, attachment);
                ThumbnailedImage thumbnailedImage = AttachmentViewDtoConverterImpl.this.thumbnailManager.toThumbnailedImage(thumbnail);
                if (thumbnailedImage != null) {
                    thumbnailUrl = URI.create(thumbnailedImage.getImageURL());
                    thumbnailedImageWidth = thumbnailedImage.getWidth();
                    thumbnailedImageHeight = thumbnailedImage.getHeight();
                } else {
                    thumbnailUrl = null;
                    thumbnailedImageWidth = 0;
                    thumbnailedImageHeight = 0;
                }
                URI attachmentUrl = URI.create(String.format("secure/attachment/%s/%s", attachment.getId(), urlEncodedFileName));
                ApplicationUser author = AttachmentViewDtoConverterImpl.this.userManager.getUserByKeyEvenWhenUnknown(attachment.getAuthorKey());
                Timestamp createdTimestamp = attachment.getCreated();
                DateTime created = new DateTime(createdTimestamp.getTime(), DateTimeZone.forTimeZone((TimeZone)userDateTimeFormatter.getZone()));
                return new AttachmentViewJsonDto(attachment.getId().longValue(), attachmentsList.isLatestVersion(attachment), AttachmentViewDtoConverterImpl.this.canDeleteAttachment(issue, attachment, loggedInUser), AttachmentViewDtoConverterImpl.this.getZipSupport() && AttachmentViewDtoConverterImpl.this.attachmentIndexManager.isExpandable(attachment), thumbnailUrl, thumbnailedImageWidth, thumbnailedImageHeight, attachmentUrl, author != null ? author.getDisplayName() : null, attachment.getAuthorKey(), FileSize.format((Long)attachment.getFilesize()), attachment.getFilename(), attachment.getMimetype(), (ReadableInstant)created, userDateTimeFormatter.format((Date)createdTimestamp));
            }
        });
        return ImmutableList.builder().addAll(extendedBeans).build();
    }

    private boolean getZipSupport() {
        return this.applicationProperties.getOption("jira.attachment.allow.zip.support");
    }

    private boolean canDeleteAttachment(Issue issue, Attachment attachment, ApplicationUser user) {
        return this.issueManager.isEditable(issue) && (this.permissionManager.hasPermission(38, issue, user) || this.permissionManager.hasPermission(39, issue, user) && this.isUserAttachmentAuthor(attachment, user));
    }

    private boolean isUserAttachmentAuthor(Attachment attachment, ApplicationUser user) {
        ApplicationUser attachmentAuthor = attachment.getAuthorObject();
        if (attachmentAuthor == null && user == null) {
            return true;
        }
        if (attachmentAuthor == null || user == null) {
            return false;
        }
        return attachmentAuthor.equals((Object)user);
    }
}

