/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.option;

import com.atlassian.jira.issue.fields.option.AbstractOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.collect.CollectionUtil;
import java.util.Collections;
import java.util.List;

public class ProjectOption
extends AbstractOption
implements Option {
    private Project project;
    private List childOptions = Collections.emptyList();

    public ProjectOption(Project project) {
        this.project = project;
    }

    public ProjectOption(Project project, List childOptions) {
        this.project = project;
        if (childOptions != null) {
            this.childOptions = childOptions;
        }
    }

    public String getId() {
        return this.project != null ? this.project.getId().toString() : "";
    }

    public String getName() {
        return this.project.getName();
    }

    public String getDescription() {
        return this.project.getDescription();
    }

    public List getChildOptions() {
        return this.childOptions;
    }

    public static List<ProjectOption> transform(Iterable<? extends Project> projects) {
        return CollectionUtil.transform(projects, (Function)new Function<Project, ProjectOption>(){

            public ProjectOption get(Project input) {
                return new ProjectOption(input);
            }
        });
    }
}

