/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.persistence;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.SingleValueLocalCache;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.entity.EntityUtils;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigImpl;
import com.atlassian.jira.issue.fields.config.FieldConfigItemType;
import com.atlassian.jira.issue.fields.config.persistence.FieldConfigPersister;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.collection.CompositeCollection;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@TenantInfo(value=TenantAware.UNRESOLVED)
@EventComponent
public class FieldConfigPersisterImpl
implements FieldConfigPersister {
    protected static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jvc.jira.FieldConfigPersisterImpl.caches.request";
    private static final String ENTITY_TABLE_NAME = "FieldConfiguration";
    public static final String ENTITY_ID = "id";
    public static final String ENTITY_NAME = "name";
    public static final String ENTITY_DESCRIPTION = "description";
    public static final String ENTITY_FIELD = "fieldid";
    private final OfBizDelegator delegator;
    @TenantInfo(value=TenantAware.TENANTED)
    private final SingleValueLocalCache<Map<Long, GenericValue>> fieldConfigsById;

    public FieldConfigPersisterImpl(OfBizDelegator delegator, SwitchingCacheFactory cacheFactory) {
        this.delegator = delegator;
        this.fieldConfigsById = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".fieldConfigsById", this::loadFieldConfigs, DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.fieldConfigsById.reset();
    }

    public FieldConfig create(FieldConfig config, List<FieldConfigItemType> configurationItemTypes) {
        Map<String, Object> fields = this.transformToFieldsMap(config);
        GenericValue createdGV = EntityUtils.createValue(ENTITY_TABLE_NAME, fields);
        this.fieldConfigsById.reset();
        return this.transformToDomainObject(createdGV, configurationItemTypes);
    }

    public FieldConfig createWithDefaultValues(ConfigurableField field) {
        String name = "Default Configuration for " + field.getName();
        String description = "Default configuration generated by JIRA";
        FieldConfigImpl config = new FieldConfigImpl(null, name, "Default configuration generated by JIRA", Collections.emptyList(), field.getId());
        return this.create(config, field.getConfigurationItemTypes());
    }

    public FieldConfig update(FieldConfig config) {
        try {
            GenericValue gv = this.findById(config.getId());
            Map<String, Object> fields = this.transformToFieldsMap(config);
            gv.setNonPKFields(fields);
            gv.store();
            this.fieldConfigsById.reset();
            CustomField customField = config.getCustomField();
            return this.transformToDomainObject(gv, customField.getConfigurationItemTypes());
        }
        catch (GenericEntityException e) {
            throw new DataAccessException("Unable to store FieldConfig: " + config, (Throwable)e);
        }
    }

    public void remove(FieldConfig config) {
        this.removeImpl(config.getId());
    }

    private void removeImpl(Long id) {
        this.delegator.removeValue(this.findById(id));
        this.fieldConfigsById.reset();
    }

    public Collection<FieldConfig> getConfigsExclusiveToConfigScheme(final Long fieldConfigSchemeId) {
        class ExclusiveConfigFinder {
            private static final String MAPPING_TABLE = "FieldConfigSchemeIssueType";
            private static final String SCHEME_COLUMN = "fieldconfigscheme";
            private static final String CONFIG_COLUMN = "fieldconfiguration";
            private final List<Long> delete = new ArrayList<Long>();
            private final List<Long> ignore = new ArrayList<Long>();
            private final Collection alreadyProcessed = new CompositeCollection(new Collection[]{this.delete, this.ignore});

            ExclusiveConfigFinder() {
            }

            Collection<FieldConfig> process() {
                List fieldConfigSchemeIssueTypeMappings = FieldConfigPersisterImpl.this.delegator.findByAnd(MAPPING_TABLE, (Map)FieldMap.build((String)SCHEME_COLUMN, (Object)fieldConfigSchemeId));
                for (GenericValue fieldConfigSchemeIssueTypeGV : fieldConfigSchemeIssueTypeMappings) {
                    this.add(fieldConfigSchemeIssueTypeGV.getLong(CONFIG_COLUMN));
                }
                return ImmutableList.copyOf((Iterable)Iterables.transform(this.delete, (Function)new Function<Long, FieldConfig>(){

                    public FieldConfig apply(@Nullable Long input) {
                        return FieldConfigPersisterImpl.this.getFieldConfig(input);
                    }
                }));
            }

            private void add(Long configId) {
                if (this.alreadyProcessed.contains(configId)) {
                    return;
                }
                if (this.fieldConfigIsExclusiveToScheme(configId)) {
                    this.delete.add(configId);
                } else {
                    this.ignore.add(configId);
                }
            }

            private boolean fieldConfigIsExclusiveToScheme(Long configId) {
                List specificConfigs = FieldConfigPersisterImpl.this.delegator.findByAnd(MAPPING_TABLE, (Map)FieldMap.build((String)CONFIG_COLUMN, (Object)configId));
                for (GenericValue fieldConfigIssueType : specificConfigs) {
                    if (fieldConfigSchemeId.equals(fieldConfigIssueType.getLong(SCHEME_COLUMN))) continue;
                    return false;
                }
                return true;
            }
        }
        return new ExclusiveConfigFinder().process();
    }

    public FieldConfig getFieldConfig(Long configId) {
        GenericValue gv = this.getById(configId);
        ConfigurableField field = ComponentAccessor.getFieldManager().getConfigurableField(gv.getString(ENTITY_FIELD));
        return this.transformToDomainObject(gv, field == null ? Collections.emptyList() : field.getConfigurationItemTypes());
    }

    public FieldConfig getFieldConfig(Long configId, ConfigurableField field) {
        GenericValue gv = this.getById(configId);
        if (gv != null) {
            return this.transformToDomainObject(gv, field.getConfigurationItemTypes());
        }
        return null;
    }

    public List getConfigForField(final ConfigurableField field) {
        List configs = this.getConfigGvsForCustomField(field);
        CollectionUtils.transform((Collection)configs, (Transformer)new Transformer(){

            public Object transform(Object input) {
                return FieldConfigPersisterImpl.this.transformToDomainObject((GenericValue)input, field.getConfigurationItemTypes());
            }
        });
        return configs;
    }

    private Map<String, Object> transformToFieldsMap(FieldConfig config) {
        HashMap fields = Maps.newHashMap();
        if (config.getId() != null) {
            fields.put(ENTITY_ID, config.getId());
        }
        if (config.getName() != null) {
            fields.put(ENTITY_NAME, config.getName());
        }
        if (config.getDescription() != null) {
            fields.put(ENTITY_DESCRIPTION, config.getDescription());
        }
        if (config.getFieldId() != null) {
            fields.put(ENTITY_FIELD, config.getFieldId());
        }
        return fields;
    }

    private FieldConfig transformToDomainObject(GenericValue createdGV, List<FieldConfigItemType> configurationItemTypes) {
        Long id = createdGV.getLong(ENTITY_ID);
        String name = createdGV.getString(ENTITY_NAME);
        String desc = createdGV.getString(ENTITY_DESCRIPTION);
        String fieldId = createdGV.getString(ENTITY_FIELD);
        return new FieldConfigImpl(id, name, desc, configurationItemTypes, fieldId);
    }

    private List getConfigGvsForCustomField(ConfigurableField field) {
        FieldMap fields = FieldMap.build((String)ENTITY_FIELD, (Object)field.getId());
        ImmutableList sortBy = ImmutableList.of((Object)ENTITY_ID);
        return this.delegator.findByAnd(ENTITY_TABLE_NAME, (Map)fields, (List)sortBy);
    }

    private GenericValue findById(Long configId) {
        return this.delegator.findById(ENTITY_TABLE_NAME, configId);
    }

    private GenericValue getById(Long id) {
        return this.fieldConfigsById.get().get(id);
    }

    private Map<Long, GenericValue> loadFieldConfigs() {
        List genericValues = this.delegator.findAll(ENTITY_TABLE_NAME);
        HashMap newValues = Maps.newHashMap();
        for (GenericValue genericValue : genericValues) {
            newValues.put(genericValue.getLong(ENTITY_ID), genericValue);
        }
        return newValues;
    }
}

