/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config.manager;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeCreatedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeDeletedEvent;
import com.atlassian.jira.event.issue.field.config.manager.IssueTypeSchemeUpdatedEvent;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.IssueContextImpl;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.IssueTypeField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.IssueConstantOption;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.GenericValue;

public class IssueTypeSchemeManagerImpl
implements IssueTypeSchemeManager {
    private final FieldConfigSchemeManager configSchemeManager;
    private final OptionSetManager optionSetManager;
    private final GenericConfigManager genericConfigManager;
    private final ConstantsManager constantsManager;
    private final ComponentReference<FieldManager> fieldManagerRef;
    private final ComponentReference<ApplicationProperties> applicationPropertiesRef;
    private EventPublisher eventPublisher;
    private static final Comparator<FieldConfigScheme> BY_NAME_NULLS_FIRST = Comparator.comparing(FieldConfigScheme::getName, Comparator.nullsFirst(String::compareToIgnoreCase));

    public IssueTypeSchemeManagerImpl(FieldConfigSchemeManager configSchemeManager, OptionSetManager optionSetManager, GenericConfigManager genericConfigManager, ConstantsManager constantsManager, EventPublisher eventPublisher) {
        this.configSchemeManager = configSchemeManager;
        this.optionSetManager = optionSetManager;
        this.genericConfigManager = genericConfigManager;
        this.constantsManager = constantsManager;
        this.eventPublisher = eventPublisher;
        this.fieldManagerRef = ComponentAccessor.getComponentReference(FieldManager.class);
        this.applicationPropertiesRef = ComponentAccessor.getComponentReference(ApplicationProperties.class);
    }

    public FieldConfigScheme create(String schemeName, String schemeDescription, List<String> optionIds) {
        FieldConfigScheme configScheme = new FieldConfigScheme.Builder().setName(schemeName).setDescription(schemeDescription).toFieldConfigScheme();
        configScheme = this.configSchemeManager.createFieldConfigScheme(configScheme, null, FieldConfigSchemeManager.ALL_ISSUE_TYPES, this.getIssueTypeField());
        FieldConfig config = configScheme.getOneAndOnlyConfig();
        this.optionSetManager.createOptionSet(config, optionIds);
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeCreatedEvent(configScheme));
        return configScheme;
    }

    public FieldConfigScheme update(FieldConfigScheme configScheme, Collection<String> optionIds) {
        configScheme = this.configSchemeManager.updateFieldConfigScheme(configScheme);
        FieldConfig config = configScheme.getOneAndOnlyConfig();
        this.optionSetManager.updateOptionSet(config, optionIds);
        this.triggerIssueTypeSchemeUpdated(configScheme);
        return configScheme;
    }

    public FieldConfigScheme getDefaultIssueTypeScheme() {
        long schemeId = this.getDefaultIssueTypeSchemeId();
        return this.configSchemeManager.getFieldConfigScheme(Long.valueOf(schemeId));
    }

    public boolean isDefaultIssueTypeScheme(FieldConfigScheme configScheme) {
        Long id = configScheme.getId();
        return id != null && id.longValue() == this.getDefaultIssueTypeSchemeId();
    }

    private ConfigurableField<?> getIssueTypeField() {
        return this.getFieldManager().getConfigurableField("issuetype");
    }

    private long getDefaultIssueTypeSchemeId() {
        String s = ((ApplicationProperties)this.applicationPropertiesRef.get()).getString("jira.scheme.default.issue.type");
        return Long.parseLong(s);
    }

    public void addOptionToDefault(String id) {
        FieldConfigScheme defaultIssueTypeScheme = this.getDefaultIssueTypeScheme();
        this.optionSetManager.addOptionToOptionSet(defaultIssueTypeScheme.getOneAndOnlyConfig(), id);
        this.triggerIssueTypeSchemeUpdated(defaultIssueTypeScheme);
    }

    public Collection<FieldConfigScheme> getAllRelatedSchemes(final String optionId) {
        List configs = this.configSchemeManager.getConfigSchemesForField(this.getIssueTypeField());
        return Lists.newArrayList((Iterable)Iterables.filter((Iterable)configs, (Predicate)new Predicate<FieldConfigScheme>(){

            public boolean apply(@Nullable FieldConfigScheme configScheme) {
                Collection optionIds = IssueTypeSchemeManagerImpl.this.optionSetManager.getOptionsForConfig(configScheme.getOneAndOnlyConfig()).getOptionIds();
                return optionIds.contains(optionId);
            }
        }));
    }

    public void removeOptionFromAllSchemes(String optionId) {
        Collection<FieldConfigScheme> relatedSchemes = this.getAllRelatedSchemes(optionId);
        for (FieldConfigScheme configScheme : relatedSchemes) {
            this.optionSetManager.removeOptionFromOptionSet(configScheme.getOneAndOnlyConfig(), optionId);
            this.triggerIssueTypeSchemeUpdated(configScheme);
        }
    }

    private void triggerIssueTypeSchemeUpdated(FieldConfigScheme configScheme) {
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeUpdatedEvent(configScheme));
    }

    public void deleteScheme(FieldConfigScheme configScheme) {
        this.configSchemeManager.removeFieldConfigScheme(configScheme.getId());
        this.getFieldManager().refresh();
        this.eventPublisher.publish((Object)new IssueTypeSchemeDeletedEvent(configScheme));
    }

    public List<FieldConfigScheme> getAllSchemes() {
        ArrayList<FieldConfigScheme> schemes = new ArrayList<FieldConfigScheme>(this.configSchemeManager.getConfigSchemesForField((ConfigurableField)this.getFieldManager().getIssueTypeField()));
        Collections.sort(schemes, this.schemeComparator());
        return schemes;
    }

    private FieldManager getFieldManager() {
        return (FieldManager)this.fieldManagerRef.get();
    }

    public IssueType getDefaultValue(Issue issue) {
        FieldConfig config = this.configSchemeManager.getRelevantConfig((IssueContext)issue, this.getIssueTypeField());
        return this.getDefaultValue(config);
    }

    public IssueType getDefaultValue(FieldConfig config) {
        if (config != null) {
            String issueTypeId = (String)this.genericConfigManager.retrieve("DefaultValue", config.getId().toString());
            return this.constantsManager.getIssueType(issueTypeId);
        }
        return null;
    }

    public IssueType getDefaultValue(GenericValue project) {
        if (project != null) {
            IssueTypeField issueTypeField = this.getFieldManager().getIssueTypeField();
            FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(project.getLong("id"), null));
            return this.getDefaultValue(relevantConfig);
        }
        return null;
    }

    public IssueType getDefaultIssueType(Project project) {
        if (project != null) {
            IssueTypeField issueTypeField = this.getFieldManager().getIssueTypeField();
            FieldConfig relevantConfig = issueTypeField.getRelevantConfig((IssueContext)new IssueContextImpl(project.getId(), null));
            return this.getDefaultValue(relevantConfig);
        }
        return null;
    }

    public void setDefaultValue(FieldConfig config, String optionId) {
        this.genericConfigManager.update("DefaultValue", config.getId().toString(), (Object)optionId);
        this.getFieldManager().refresh();
    }

    public FieldConfigScheme getConfigScheme(GenericValue project) {
        return this.configSchemeManager.getRelevantConfigScheme((IssueContext)new IssueContextImpl(project != null ? project.getLong("id") : null, null), (ConfigurableField)this.getFieldManager().getIssueTypeField());
    }

    public FieldConfigScheme getConfigScheme(Project project) {
        return this.configSchemeManager.getRelevantConfigScheme(project, (ConfigurableField)this.getFieldManager().getIssueTypeField());
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForProject(GenericValue project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project);
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, true);
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForProject(Project project) {
        return this.getIssueTypesForProject(project.getGenericValue());
    }

    @Nonnull
    public Collection<IssueType> getIssueTypesForDefaultScheme() {
        FieldConfigScheme fieldConfigScheme = this.getDefaultIssueTypeScheme();
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, true);
    }

    @Nonnull
    public Collection<IssueType> getNonSubTaskIssueTypesForProject(Project project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project.getGenericValue());
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, false, true);
    }

    @Nonnull
    public Collection<IssueType> getSubTaskIssueTypesForProject(@Nonnull Project project) {
        FieldConfigScheme fieldConfigScheme = this.getConfigScheme(project.getGenericValue());
        return this.getIssueTypesForConfigScheme(fieldConfigScheme, true, false);
    }

    @Nonnull
    private Collection<IssueType> getIssueTypesForConfigScheme(FieldConfigScheme fieldConfigScheme, boolean includeSubTasks, boolean includeNonSubTaskIssueTypes) {
        FieldConfig config = fieldConfigScheme.getOneAndOnlyConfig();
        Collection options = this.optionSetManager.getOptionsForConfig(config).getOptions();
        ArrayList<IssueType> issueTypeObjects = new ArrayList<IssueType>();
        for (Option option : options) {
            IssueConstantOption issueTypeOption = (IssueConstantOption)option;
            IssueType issueType = this.constantsManager.getIssueType(issueTypeOption.getId());
            boolean isSubTask = issueType.isSubTask();
            if ((!includeSubTasks || !isSubTask) && (!includeNonSubTaskIssueTypes || isSubTask)) continue;
            issueTypeObjects.add(issueType);
        }
        return issueTypeObjects;
    }

    private Comparator<FieldConfigScheme> schemeComparator() {
        return this.defaultIdFirst().thenComparing(BY_NAME_NULLS_FIRST);
    }

    private Comparator<FieldConfigScheme> defaultIdFirst() {
        Long defaultId = this.getDefaultIssueTypeSchemeId();
        return Comparator.comparing(FieldConfigScheme::getId, (id1, id2) -> {
            if (defaultId.equals(id1)) {
                return -1;
            }
            if (defaultId.equals(id2)) {
                return 1;
            }
            return 0;
        });
    }
}

