/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MultiUserCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Collection<String>> {
    public MultiUserCustomFieldOperationsHandler(CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.SET.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    protected Collection<String> handleAddOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        ArrayList<String> newList = new ArrayList<String>(currentFieldValue);
        String newUser = operationValue.asObjectWithProperty("name", this.field.getId(), errors);
        if (!newList.contains(newUser)) {
            newList.add(newUser);
        }
        return newList;
    }

    protected Collection<String> handleRemoveOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(currentFieldValue, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)operationValue.asObjectWithProperty("name", this.field.getId(), errors)))));
    }

    protected Collection<String> handleSetOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        return operationValue.isNull() ? null : operationValue.asArrayOfObjectsWithProperty("name", this.field.getId(), errors);
    }

    protected List<String> getInitialValue(Issue issue, ErrorCollection errors) {
        Collection fieldValue = (Collection)this.field.getValue(issue);
        if (fieldValue == null) {
            return Collections.emptyList();
        }
        Iterable users = Iterables.transform((Iterable)fieldValue, (Function)new Function<ApplicationUser, String>(){

            public String apply(ApplicationUser from) {
                return from.getUsername();
            }
        });
        return Lists.newArrayList((Iterable)users);
    }

    protected List<String> getInitialCreateValue(IssueContext issueCtx) {
        return Collections.emptyList();
    }

    protected void finaliseOperation(Collection<String> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), finalValue != null ? finalValue.toArray(new String[finalValue.size()]) : new String[]{});
    }
}

