/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.impl.rest;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueInputParameters;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.customfields.impl.rest.AbstractCustomFieldOperationsHandler;
import com.atlassian.jira.issue.customfields.impl.rest.GroupFunctions;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.rest.StandardOperation;
import com.atlassian.jira.issue.fields.rest.json.JsonData;
import com.atlassian.jira.issue.fields.rest.json.TypeRef;
import com.atlassian.jira.issue.fields.rest.json.beans.GroupJsonBean;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class MultiGroupCustomFieldOperationsHandler
extends AbstractCustomFieldOperationsHandler<Collection<String>> {
    private static final TypeRef<List<GroupJsonBean>> LIST_OF_GROUP_JSON_BEAN = new TypeRef<List<GroupJsonBean>>(){};

    public MultiGroupCustomFieldOperationsHandler(CustomField field, I18nHelper i18nHelper) {
        super(field, i18nHelper);
    }

    public Set<String> getSupportedOperations() {
        return ImmutableSet.of((Object)StandardOperation.ADD.getName(), (Object)StandardOperation.SET.getName(), (Object)StandardOperation.REMOVE.getName());
    }

    protected Collection<String> handleSetOperation(IssueContext issueCtx, Issue issue, Collection<String> currentFieldValue, JsonData operationValue, ErrorCollection errors) {
        if (operationValue.isNull()) {
            return Collections.emptyList();
        }
        List newGroup = (List)operationValue.convertValue(this.field.getId(), LIST_OF_GROUP_JSON_BEAN, errors);
        if (newGroup == null) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.group.value.not.group.objects"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentFieldValue;
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)newGroup, GroupFunctions.GROUP_BEAN_TO_NAME));
    }

    protected Collection<String> handleAddOperation(IssueContext issueCtx, Issue issue, Collection<String> currentValue, JsonData operationValue, ErrorCollection errors) {
        GroupJsonBean newGroup = (GroupJsonBean)operationValue.convertValue(this.field.getId(), GroupJsonBean.class, errors);
        if (newGroup == null) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.group.value.not.group.objects"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentValue;
        }
        if (currentValue.contains(newGroup.getName())) {
            return currentValue;
        }
        ArrayList newValue = Lists.newArrayListWithCapacity((int)(currentValue.size() + 1));
        newValue.addAll(currentValue);
        newValue.add(newGroup.getName());
        return newValue;
    }

    protected Collection<String> handleRemoveOperation(IssueContext issueCtx, Issue issue, Collection<String> currentValue, JsonData operationValue, ErrorCollection errors) {
        GroupJsonBean newGroup = (GroupJsonBean)operationValue.convertValue(this.field.getId(), GroupJsonBean.class, errors);
        if (newGroup == null) {
            errors.addError(this.field.getId(), this.i18nHelper.getText("rest.group.value.not.group.objects"), ErrorCollection.Reason.VALIDATION_FAILED);
            return currentValue;
        }
        return ImmutableList.copyOf((Iterable)Iterables.filter(currentValue, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)newGroup.getName()))));
    }

    protected List<String> getInitialCreateValue(IssueContext issueCtx) {
        return Collections.emptyList();
    }

    protected List<String> getInitialValue(Issue issue, ErrorCollection errors) {
        Collection fieldValue = (Collection)this.field.getValue(issue);
        if (fieldValue == null) {
            return Collections.emptyList();
        }
        Iterable groups = Iterables.transform((Iterable)fieldValue, (Function)new Function<Group, String>(){

            public String apply(Group from) {
                return from.getName();
            }
        });
        return Lists.newArrayList((Iterable)groups);
    }

    protected void finaliseOperation(Collection<String> finalValue, IssueInputParameters parameters, ErrorCollection errors) {
        parameters.addCustomFieldValue(this.field.getId(), finalValue.toArray(new String[finalValue.size()]));
    }
}

