/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.converters;

import com.atlassian.jira.issue.customfields.converters.ProjectConverter;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.opensymphony.util.TextUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectConverterImpl
implements ProjectConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectConverter.class);
    private final ProjectManager projectManager;

    public ProjectConverterImpl(ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    public String getString(Project project) {
        if (project == null) {
            return "-1";
        }
        return project.getId().toString();
    }

    public Project getProjectObject(String stringValue) throws FieldValidationException {
        if (StringUtils.isBlank((String)stringValue) || "-1".equals(stringValue)) {
            return null;
        }
        try {
            Long id = Long.valueOf(stringValue);
            return this.getProjectObject(id);
        }
        catch (NumberFormatException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Project Id '" + stringValue + "' is not a number.");
        }
    }

    public Project getProjectObject(Long projectId) throws FieldValidationException {
        if (projectId == null) {
            return null;
        }
        try {
            return this.projectManager.getProjectObj(projectId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Invalid Project Id '" + projectId + "'");
        }
    }

    public Project getProject(String stringValue) throws FieldValidationException {
        if (!TextUtils.stringSet((String)stringValue) || "-1".equals(stringValue)) {
            return null;
        }
        try {
            Long id = Long.valueOf(stringValue);
            return this.getProject(id);
        }
        catch (NumberFormatException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Project Id is not a number '" + stringValue + "'");
        }
    }

    public Project getProject(Long projectId) throws FieldValidationException {
        try {
            return this.projectManager.getProjectObj(projectId);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new FieldValidationException("Invalid Project Id '" + projectId + "'");
        }
    }
}

