/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.context.persistence;

import com.atlassian.annotations.Internal;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cache.CacheAdapter;
import com.atlassian.jira.cache.SwitchingCacheFactory;
import com.atlassian.jira.entity.Entity;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersisterWorker;
import com.atlassian.jira.issue.fields.config.ConfigurationContext;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.FieldConfigSchemeIssueType;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.tenancy.TenantAware;
import com.atlassian.jira.tenancy.TenantInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
@Internal
public class CachingFieldConfigContextPersister
implements FieldConfigContextPersister,
Startable {
    private static final Logger log = LoggerFactory.getLogger(CachingFieldConfigContextPersister.class);
    protected static final String DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY = "jira.jvc.CachingFieldConfigContextPersister.caches.request";
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<String, FieldConfigContextMap> fieldContextCache;
    @TenantInfo(value=TenantAware.TENANTED)
    private final CacheAdapter<Long, IssueTypeSet> configSchemeIssueTypeCache;
    private final FieldConfigContextPersisterWorker worker;
    private final OfBizDelegator ofBizDelegator;

    public CachingFieldConfigContextPersister(OfBizDelegator delegator, ProjectManager projectManager, SwitchingCacheFactory cacheFactory) {
        this.ofBizDelegator = delegator;
        this.worker = new FieldConfigContextPersisterWorker(delegator, projectManager, cacheFactory);
        this.fieldContextCache = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".fieldContextCache", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
        this.configSchemeIssueTypeCache = cacheFactory.buildSwitchingRequestCache(this.getClass().getName() + ".configSchemeIssueTypeCache", Optional.of(new CacheSettingsBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).flushable().build()), DARK_FEATURE_REQUEST_CACHE_ENABLE_KEY);
    }

    public void start() throws Exception {
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.invalidateAll();
    }

    public List<JiraContextNode> getAllContextsForConfigScheme(FieldConfigScheme fieldConfigScheme) {
        return this.worker.getAllContextsForConfigScheme(fieldConfigScheme);
    }

    public void removeContextsForConfigScheme(@Nonnull FieldConfigScheme fieldConfigScheme) {
        this.worker.removeContextsForConfigScheme(fieldConfigScheme);
        if (fieldConfigScheme.getField() != null) {
            this.fieldContextCache.remove(fieldConfigScheme.getField().getId());
            this.configSchemeIssueTypeCache.remove(fieldConfigScheme.getId());
        }
    }

    public void removeContextsForProject(Project project) {
        this.worker.removeContextsForProject(project);
        this.invalidateAll();
    }

    @Nullable
    public Long getRelevantConfigSchemeId(@Nonnull IssueContext issueContext, @Nonnull String fieldId) {
        Long schemeId = this.getRelevantConfigSchemeId(issueContext.getProjectId(), fieldId);
        if (schemeId != null) {
            IssueTypeSet issueTypeSet = (IssueTypeSet)this.configSchemeIssueTypeCache.get(schemeId, () -> this.loadConfigSchemeIssueType(schemeId));
            if (issueTypeSet == null) {
                throw new IllegalStateException("configSchemeIssueTypeCache failed to retrieve IssueTypeSet for schemeId " + schemeId);
            }
            if (issueTypeSet.includesIssueType(issueContext.getIssueTypeId())) {
                return schemeId;
            }
        }
        return null;
    }

    @Nullable
    public Long getRelevantConfigSchemeId(@Nullable Long projectId, @Nonnull String fieldId) {
        FieldConfigContextMap fieldConfigContextMap = (FieldConfigContextMap)this.fieldContextCache.get(fieldId, () -> this.loadFieldConfigContext(fieldId));
        if (fieldConfigContextMap == null) {
            throw new IllegalStateException("fieldContextCache failed to retrieve FieldConfigContextMap for fieldId " + fieldId);
        }
        return fieldConfigContextMap.getConfigSchemeIdForProject(projectId);
    }

    public void store(String fieldId, JiraContextNode contextNode, FieldConfigScheme fieldConfigScheme) {
        this.store(fieldId, Arrays.asList(contextNode), fieldConfigScheme);
    }

    public void store(String fieldId, Collection<? extends JiraContextNode> contextNodes, FieldConfigScheme fieldConfigScheme) {
        Set uniqueSchemeIds = ((FieldConfigContextMap)this.fieldContextCache.get(fieldId, () -> this.loadFieldConfigContext(fieldId))).getUniqueSchemeIds();
        for (JiraContextNode jiraContextNode : contextNodes) {
            this.worker.store(fieldId, jiraContextNode, fieldConfigScheme);
        }
        this.fieldContextCache.remove(fieldId);
        uniqueSchemeIds.forEach(arg_0 -> this.configSchemeIssueTypeCache.remove(arg_0));
    }

    private void invalidateAll() {
        this.worker.invalidateAll();
        this.fieldContextCache.removeAll();
        this.configSchemeIssueTypeCache.removeAll();
        if (log.isTraceEnabled()) {
            log.trace("called invalidateAll()", new Throwable());
        }
    }

    @Nonnull
    private FieldConfigContextMap loadFieldConfigContext(@Nonnull String fieldId) {
        List configurationContexts = Select.from(Entity.CONFIGURATION_CONTEXT).whereEqual("key", fieldId).runWith(this.ofBizDelegator).asList();
        HashMap<Long, Long> projectIdToSchemeIdMap = new HashMap<Long, Long>(configurationContexts.size());
        for (ConfigurationContext configurationContext : configurationContexts) {
            projectIdToSchemeIdMap.put(configurationContext.getProjectId(), configurationContext.getFieldConfigSchemeId());
        }
        return new FieldConfigContextMap(projectIdToSchemeIdMap);
    }

    @Nonnull
    public IssueTypeSet loadConfigSchemeIssueType(@Nonnull Long schemeId) {
        List<FieldConfigSchemeIssueType> issueTypeConfigs = Select.from(Entity.FIELD_CONFIG_SCHEME_ISSUE_TYPE).whereEqual("fieldconfigscheme", schemeId).runWith(this.ofBizDelegator).asList();
        return IssueTypeSet.from(issueTypeConfigs);
    }

    private static class IssueTypeSet {
        private final Set<String> issueTypeIds;

        public IssueTypeSet(Set<String> issueTypeIds) {
            this.issueTypeIds = issueTypeIds;
        }

        @Nonnull
        public static IssueTypeSet from(List<FieldConfigSchemeIssueType> issueTypeConfigs) {
            HashSet<String> issueTypeIds = new HashSet<String>(issueTypeConfigs.size());
            for (FieldConfigSchemeIssueType issueTypeConfig : issueTypeConfigs) {
                if (issueTypeConfig.getIssueTypeId() == null) {
                    return new IssueTypeSet(null);
                }
                issueTypeIds.add(issueTypeConfig.getIssueTypeId());
            }
            return new IssueTypeSet(issueTypeIds);
        }

        public boolean includesIssueType(String issueTypeId) {
            return this.issueTypeIds == null || this.issueTypeIds.contains("-1") || this.issueTypeIds.contains(issueTypeId);
        }
    }

    private static class FieldConfigContextMap {
        private final Map<Long, Long> projectIdToSchemeIdMap;

        private FieldConfigContextMap(Map<Long, Long> projectIdToSchemeIdMap) {
            this.projectIdToSchemeIdMap = projectIdToSchemeIdMap;
        }

        private Long getConfigSchemeIdForProject(@Nullable Long projectId) {
            Long schemeId = this.projectIdToSchemeIdMap.get(projectId);
            if (schemeId == null && projectId != null) {
                schemeId = this.projectIdToSchemeIdMap.get(null);
            }
            return schemeId;
        }

        private Set<Long> getUniqueSchemeIds() {
            return new HashSet<Long>(this.projectIdToSchemeIdMap.values());
        }
    }
}

