/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comments;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.comment.CommentDeletedEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventManager;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentEventPublisher;
import java.util.Map;

public class CommentEventPublisherImpl
implements CommentEventPublisher {
    private final IssueEventManager issueEventManager;
    private final EventPublisher eventPublisher;
    private final IssueEventBundleFactory issueEventBundleFactory;

    public CommentEventPublisherImpl(IssueEventManager issueEventManager, EventPublisher eventPublisher, IssueEventBundleFactory issueEventBundleFactory) {
        this.issueEventManager = issueEventManager;
        this.eventPublisher = eventPublisher;
        this.issueEventBundleFactory = issueEventBundleFactory;
    }

    @Override
    public void publishCommentUpdatedEvent(Comment comment, Map<String, Object> parameters) {
        IssueEventBundle issueCommentBundle = this.issueEventBundleFactory.createCommentEditedBundle(comment.getIssue(), comment.getUpdateAuthorApplicationUser(), comment, parameters);
        this.issueEventManager.dispatchEvent(issueCommentBundle);
        this.issueEventManager.dispatchRedundantEvent(EventType.ISSUE_COMMENT_EDITED_ID, comment.getIssue(), comment.getUpdateAuthorUser(), comment, null, null, parameters);
    }

    @Override
    public void publishCommentCreatedEvent(Comment comment, Map<String, Object> parameters) {
        IssueEventBundle issueCommentBundle = this.issueEventBundleFactory.createCommentAddedBundle(comment.getIssue(), comment.getUpdateAuthorApplicationUser(), comment, parameters);
        this.issueEventManager.dispatchEvent(issueCommentBundle);
        this.issueEventManager.dispatchRedundantEvent(EventType.ISSUE_COMMENTED_ID, comment.getIssue(), comment.getUpdateAuthorUser(), comment, null, null, parameters);
    }

    @Override
    public void publishCommentDeletedEvent(Comment comment) {
        this.eventPublisher.publish((Object)new CommentDeletedEvent(comment));
    }
}

