/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment.store.temporary;

import com.atlassian.fugue.Option;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentMonitorStore;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachment;
import com.atlassian.jira.model.querydsl.QTempAttachmentsMonitor;
import com.atlassian.jira.model.querydsl.TempAttachmentsMonitorDTO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.joda.time.DateTime;

@ParametersAreNonnullByDefault
public class TemporaryAttachmentMonitorStoreImpl
implements TemporaryAttachmentMonitorStore {
    private final QueryDslAccessor databaseAccessor;

    public TemporaryAttachmentMonitorStoreImpl(QueryDslAccessor databaseAccessor) {
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    public Option<TemporaryWebAttachment> removeById(TemporaryAttachmentId temporaryAttachmentId) {
        Option<TemporaryWebAttachment> byId = this.getById(temporaryAttachmentId);
        byId.forEach(twa -> this.removeByIdImpl(temporaryAttachmentId.toStringId()));
        return byId;
    }

    @Override
    public Option<TemporaryWebAttachment> getById(TemporaryAttachmentId temporaryAttachmentId) {
        return this.getByIdImpl(temporaryAttachmentId.toStringId());
    }

    @Override
    public Collection<TemporaryWebAttachment> getByFormToken(String formToken) {
        return this.getByFormTokenImpl(formToken);
    }

    @Override
    public boolean putIfAbsent(TemporaryWebAttachment temporaryWebAttachment) {
        Option<TemporaryWebAttachment> byId = this.getById(temporaryWebAttachment.getTemporaryAttachmentId());
        if (byId.isEmpty()) {
            this.putImpl(temporaryWebAttachment);
        }
        return byId.isDefined();
    }

    @Override
    public long removeOlderThan(DateTime dateTime) {
        return this.removeOlderThanImpl(dateTime);
    }

    private Option<TemporaryWebAttachment> getByIdImpl(String temporaryAttachmentId) {
        return this.databaseAccessor.executeQuery(dbConnection -> Option.option((Object)((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR).from((Expression)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR)).where((Predicate)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.temporaryAttachmentId.eq((Object)temporaryAttachmentId))).fetchOne()).map(this::toTemporaryWebAttachment));
    }

    private Collection<TemporaryWebAttachment> getByFormTokenImpl(String formToken) {
        return this.databaseAccessor.executeQuery(dbConnection -> ((SQLQuery)((SQLQuery)dbConnection.newSqlQuery().select((Expression)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR).from((Expression)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR)).where((Predicate)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.formToken.eq((Object)formToken))).fetch().stream().map(this::toTemporaryWebAttachment).collect(Collectors.toList()));
    }

    private long removeOlderThanImpl(DateTime then) {
        return this.databaseAccessor.executeQuery(dbConnection -> dbConnection.delete((RelationalPath<?>)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR).where((Predicate)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.createdTime.lt((Number)then.getMillis())).execute());
    }

    private long removeByIdImpl(String temporaryAttachmentId) {
        return this.databaseAccessor.executeQuery(conn -> conn.delete((RelationalPath<?>)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR).where((Predicate)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.temporaryAttachmentId.eq((Object)temporaryAttachmentId)).execute());
    }

    private long putImpl(TemporaryWebAttachment temporaryWebAttachment) {
        return this.databaseAccessor.executeQuery(dbConnection -> dbConnection.insert(QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR).set((Path)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.temporaryAttachmentId, temporaryWebAttachment.getTemporaryAttachmentId().toStringId()).set((Path)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.contentType, temporaryWebAttachment.getContentType()).set((Path)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.fileName, temporaryWebAttachment.getFilename()).set((Path)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.formToken, temporaryWebAttachment.getFormToken()).set((Path)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.createdTime, (Object)temporaryWebAttachment.getCreated().getMillis()).set((Path)QTempAttachmentsMonitor.TEMP_ATTACHMENTS_MONITOR.fileSize, (Object)temporaryWebAttachment.getSize()).execute());
    }

    private TemporaryWebAttachment toTemporaryWebAttachment(@Nonnull TempAttachmentsMonitorDTO dto) {
        return new TemporaryWebAttachment(TemporaryAttachmentId.fromString((String)dto.getTemporaryAttachmentId()), dto.getFileName(), dto.getContentType(), dto.getFormToken(), dto.getFileSize().longValue(), new DateTime((Object)dto.getCreatedTime()));
    }
}

