/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.attachment;

import com.atlassian.jira.issue.attachment.MimetypesFileTypeMap;
import com.atlassian.jira.issue.attachment.Path;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class AttachmentZipKit {
    private static final Logger log = LoggerFactory.getLogger(AttachmentZipKit.class);

    @Deprecated
    public boolean isZip(@Nullable File file) {
        if (file == null) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(file);
            boolean hasAtLeastOneEntry = zipFile.getEntries().hasMoreElements();
            zipFile.close();
            return hasAtLeastOneEntry;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Deprecated
    public ZipEntryInputStream extractFile(@Nullable File zipFile, long entryIndex) throws IOException {
        if (!this.isZip(zipFile)) {
            throw new IOException("This is not a zipFile" + zipFile);
        }
        ZipArchiveInputStream zipInputStream = new ZipArchiveInputStream((InputStream)new FileInputStream(zipFile));
        ZipArchiveEntry entry = zipInputStream.getNextZipEntry();
        int currentEntry = 0;
        while (entry != null && (long)currentEntry < entryIndex) {
            entry = zipInputStream.getNextZipEntry();
            ++currentEntry;
        }
        if (entry != null && (long)currentEntry == entryIndex) {
            return new ZipEntryInputStream((InputStream)zipInputStream, entry);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public AttachmentZipEntries listEntries(File zipFile, int maxEntries, FileCriteria criteria) throws IOException {
        AttachmentZipEntriesImpl attachmentZipEntriesImpl;
        ZipFile zf = new ZipFile(zipFile);
        try {
            List<AttachmentZipEntryImpl> list = new ArrayList<AttachmentZipEntryImpl>();
            int currentEntry = 0;
            Enumeration enumeration = zf.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)enumeration.nextElement();
                if (criteria.matches(zipEntry)) {
                    list.add(new AttachmentZipEntryImpl(currentEntry, zipEntry));
                }
                ++currentEntry;
            }
            int totalNumberOfEntriesAvailable = list.size();
            boolean hasMore = false;
            if (maxEntries >= 0 && list.size() > maxEntries) {
                hasMore = true;
                list = list.subList(0, maxEntries);
            }
            attachmentZipEntriesImpl = new AttachmentZipEntriesImpl(list, totalNumberOfEntriesAvailable, hasMore);
        }
        catch (Throwable throwable) {
            try {
                zf.close();
            }
            catch (IOException e) {
                log.error(String.format("JIRA was not able to close the zip file: '%s' while / after listing its entries. An IOException was thrown.", zipFile.getPath()));
            }
            throw throwable;
        }
        try {
            zf.close();
        }
        catch (IOException e) {
            log.error(String.format("JIRA was not able to close the zip file: '%s' while / after listing its entries. An IOException was thrown.", zipFile.getPath()));
        }
        return attachmentZipEntriesImpl;
    }

    @Deprecated
    private static class AttachmentZipEntryImpl
    implements AttachmentZipEntry {
        private final int entryIndex;
        private final int directoryDepth;
        private final ZipArchiveEntry zipEntry;

        public AttachmentZipEntryImpl(int entryIndex, ZipArchiveEntry zipEntry) {
            this.entryIndex = entryIndex;
            this.zipEntry = zipEntry;
            this.directoryDepth = this.calcDepth(zipEntry.getName());
        }

        private int calcDepth(String name) {
            File f = new File(name);
            int i = 0;
            while ((f = f.getParentFile()) != null) {
                ++i;
            }
            return i;
        }

        @Override
        public long getEntryIndex() {
            return this.entryIndex;
        }

        @Override
        public String getName() {
            return this.zipEntry.getName();
        }

        @Override
        public String getAbbreviatedName() {
            return new Path(this.getName()).abbreviate(40).getPath();
        }

        @Override
        public String getExtension() {
            String name = new File(this.getName()).getName();
            int index = name.lastIndexOf(".");
            if (index > 0) {
                return name.substring(index);
            }
            return "";
        }

        @Override
        public long getSize() {
            return this.zipEntry.getSize();
        }

        @Override
        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        @Override
        public int getDirectoryDepth() {
            return this.directoryDepth;
        }

        @Override
        public Date getModifiedDate() {
            return new Date(this.zipEntry.getTime());
        }

        @Override
        public String getMimetype() {
            return MimetypesFileTypeMap.getContentType(this.getName());
        }

        public String toString() {
            return super.toString() + "-idx:" + this.getEntryIndex() + "-name:" + this.getName() + "-dir:" + this.isDirectory() + "-size:" + this.getSize();
        }
    }

    @Deprecated
    private static class AttachmentZipEntriesImpl
    implements AttachmentZipEntries {
        private final boolean moreAvailable;
        private final int totalNumberOfEntriesAvailable;
        private final List<AttachmentZipEntry> list;

        private AttachmentZipEntriesImpl(List<AttachmentZipEntry> list, int totalNumberOfEntriesAvailable, boolean moreAvailable) {
            this.moreAvailable = moreAvailable;
            this.totalNumberOfEntriesAvailable = totalNumberOfEntriesAvailable;
            this.list = list;
        }

        @Override
        public boolean isMoreAvailable() {
            return this.moreAvailable;
        }

        @Override
        public int getTotalNumberOfEntriesAvailable() {
            return this.totalNumberOfEntriesAvailable;
        }

        @Override
        public List<AttachmentZipEntry> getList() {
            return Collections.unmodifiableList(this.list);
        }
    }

    @Deprecated
    public static interface AttachmentZipEntry {
        public long getEntryIndex();

        public String getName();

        public String getAbbreviatedName();

        public String getExtension();

        public long getSize();

        public boolean isDirectory();

        public int getDirectoryDepth();

        public Date getModifiedDate();

        public String getMimetype();
    }

    @Deprecated
    public static interface AttachmentZipEntries {
        public boolean isMoreAvailable();

        public int getTotalNumberOfEntriesAvailable();

        public List<AttachmentZipEntry> getList();
    }

    @Deprecated
    public static enum FileCriteria {
        ONLY_FILES{

            @Override
            boolean matches(ZipArchiveEntry zipEntry) {
                return !zipEntry.isDirectory();
            }
        }
        ,
        ONLY_DIRECTORIES{

            @Override
            boolean matches(ZipArchiveEntry zipEntry) {
                return zipEntry.isDirectory();
            }
        }
        ,
        ALL{

            @Override
            boolean matches(ZipArchiveEntry zipEntry) {
                return true;
            }
        };


        abstract boolean matches(ZipArchiveEntry var1);
    }

    public static class ZipEntryInputStream
    extends InputStream {
        private final InputStream inputStream;
        private final ZipArchiveEntry zipEntry;

        private ZipEntryInputStream(InputStream inputStream, ZipArchiveEntry zipEntry) {
            this.inputStream = inputStream;
            this.zipEntry = zipEntry;
        }

        public ZipArchiveEntry getZipEntry() {
            return this.zipEntry;
        }

        @Override
        public int read() throws IOException {
            return this.inputStream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.inputStream.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.inputStream.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.inputStream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.inputStream.available();
        }

        @Override
        public void close() throws IOException {
            this.inputStream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.inputStream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.inputStream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.inputStream.markSupported();
        }
    }
}

