/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.issue.status.Status;
import java.util.Collection;
import org.ofbiz.core.entity.GenericValue;

public abstract class AbstractIssue
implements Issue {
    protected final ConstantsManager constantsManager;
    protected final IssueManager issueManager;
    protected final AttachmentManager attachmentManager;
    private Collection<Attachment> attachments;

    protected AbstractIssue(ConstantsManager constantsManager, IssueManager issueManager, AttachmentManager attachmentManager) {
        this.constantsManager = constantsManager;
        this.issueManager = issueManager;
        this.attachmentManager = attachmentManager;
    }

    public IssueType getIssueTypeObject() {
        return this.getIssueType();
    }

    public Priority getPriorityObject() {
        return this.getPriority();
    }

    public Resolution getResolutionObject() {
        return this.getResolution();
    }

    public Status getStatusObject() {
        return this.getStatus();
    }

    public Issue getParentObject() {
        if (this.isSubTask()) {
            return this.issueManager.getIssueObject(this.getParentId());
        }
        return null;
    }

    public GenericValue getParent() {
        if (this.isSubTask()) {
            return this.issueManager.getIssue(this.getParentId());
        }
        return null;
    }

    public boolean isEditable() {
        if (this.getGenericValue() != null) {
            return this.issueManager.isEditable((Issue)this);
        }
        return true;
    }

    public Collection<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = this.attachmentManager.getAttachments((Issue)this);
        }
        return this.attachments;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Issue)) {
            return false;
        }
        String key = this.getKey();
        String otherKey = ((Issue)o).getKey();
        if (key == null) {
            return otherKey == null;
        }
        return key.equals(otherKey);
    }

    public final int hashCode() {
        String key = this.getKey();
        return key == null ? 0 : key.hashCode();
    }
}

