/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.instrumentation.external;

import com.atlassian.instrumentation.Instrument;
import com.atlassian.instrumentation.operations.ExternalOpInstrument;
import com.atlassian.instrumentation.operations.ExternalOpValue;
import com.atlassian.instrumentation.operations.OpSnapshot;
import com.atlassian.jira.instrumentation.Instrumentation;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

class GarbageCollectionsExternalOp {
    private static final String JMX_GC = "jmx.gc";

    GarbageCollectionsExternalOp() {
        ExternalOpInstrument gc = new ExternalOpInstrument(JMX_GC, new ExternalOpValue(){

            public OpSnapshot getSnapshot() {
                long count = 0L;
                long time = 0L;
                for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                    count += gc.getCollectionCount();
                    time += gc.getCollectionTime();
                }
                return new OpSnapshot(GarbageCollectionsExternalOp.JMX_GC, count, time, 0L, 0L, 0L, 0L, 0L, 0L);
            }
        });
        Instrumentation.putInstrument((Instrument)gc);
    }
}

