/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.property;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.bc.dataimport.ImportCompletedEvent;
import com.atlassian.jira.event.ComponentManagerStartedEvent;
import com.atlassian.jira.plugin.index.EntityPropertyIndexDocumentModuleDescriptor;
import com.atlassian.jira.plugin.util.PluginModuleTrackerFactory;
import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.tenancy.api.event.TenantArrivedEvent;
import com.google.common.base.Function;
import java.util.List;
import java.util.stream.StreamSupport;

@EventComponent
public class PluginIndexConfigurationInitializer {
    private final PluginModuleTracker<Void, EntityPropertyIndexDocumentModuleDescriptor> moduleTracker;

    public PluginIndexConfigurationInitializer(PluginModuleTrackerFactory pluginModuleTrackerFactory) {
        this.moduleTracker = pluginModuleTrackerFactory.create(EntityPropertyIndexDocumentModuleDescriptor.class);
    }

    public List<String> initialisePluginIndexConfiguration() {
        Iterable epIndexModules = this.moduleTracker.getModuleDescriptors();
        return (List)StreamSupport.stream(epIndexModules.spliterator(), false).map(epIndexModule -> {
            SafePluginPointAccess.safe((Function)new Function<EntityPropertyIndexDocumentModuleDescriptor, Void>(){

                public Void apply(EntityPropertyIndexDocumentModuleDescriptor input) {
                    input.init();
                    return null;
                }
            }).apply(epIndexModule);
            return epIndexModule.getCompleteKey();
        }).collect(CollectorsUtil.toImmutableList());
    }

    @EventListener
    public void onComponentManagerStartedEvent(ComponentManagerStartedEvent ignore) {
        this.initialisePluginIndexConfiguration();
    }

    @EventListener
    public void onTenantArrivedEventEvent(TenantArrivedEvent ignore) {
        this.initialisePluginIndexConfiguration();
    }

    @EventListener
    public void onImportCompletedEventEvent(ImportCompletedEvent ignore) {
        this.initialisePluginIndexConfiguration();
    }
}

