/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.index.ha.ReplicatedIndexOperation;
import com.atlassian.jira.index.ha.ReplicatedIndexOperationFactory;
import com.atlassian.jira.index.request.AffectedIndex;
import com.atlassian.jira.index.request.SharedEntityType;
import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityExprList;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizReplicatedIndexOperationStore {
    private static final String MAX_VIEW = "IndexOperationMaxIdForNodeId";
    private static final String MAX_ID = "max";
    private final OfBizDelegator ofBizDelegator;
    private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);
    private final ReplicatedIndexOperationFactory operationFactory;

    public OfBizReplicatedIndexOperationStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
        this.operationFactory = new ReplicatedIndexOperationFactory();
    }

    @Nullable
    public ReplicatedIndexOperation createIndexOperation(@Nonnull Timestamp indexTime, @Nonnull AffectedIndex affectedIndex, @Nonnull SharedEntityType entityType, @Nonnull ReplicatedIndexOperation.Operation operation, @Nonnull Set<Long> affectedIds, @Nonnull String backupFilename) {
        String nodeId = this.getClusterManager().getNodeId();
        if (nodeId != null && (affectedIds.size() > 0 || affectedIndex.equals((Object)AffectedIndex.ALL))) {
            Map<String, Object> indexOperationFields = OfBizReplicatedIndexOperationStore.getIndexOperationFields(indexTime, affectedIndex, entityType, operation, nodeId, affectedIds, backupFilename);
            return this.operationFactory.build(this.ofBizDelegator.createValue("ReplicatedIndexOperation", indexOperationFields));
        }
        return null;
    }

    public Set<ReplicatedIndexOperation> getIndexOperationsAfter(Date sinceTime) {
        HashSet replicatedIndexOperations = Sets.newHashSet();
        String nodeId = this.getClusterManager().getNodeId();
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.NOT_EQUAL, (Object)nodeId), (Object)new EntityExpr("indexTime", EntityOperator.GREATER_THAN, (Object)sinceTime));
        List gvs = this.ofBizDelegator.findByAnd("ReplicatedIndexOperation", (List)entityConditions);
        for (GenericValue gv : gvs) {
            replicatedIndexOperations.add(this.operationFactory.build(gv));
        }
        return replicatedIndexOperations;
    }

    public int purgeOldOperations(String sourceNodeId, Date before) {
        Long latestOperationId = this.getLatestOperation(sourceNodeId);
        if (latestOperationId != null) {
            ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.EQUALS, (Object)sourceNodeId), (Object)new EntityExpr("id", EntityOperator.LESS_THAN, (Object)latestOperationId), (Object)new EntityExpr("indexTime", EntityOperator.LESS_THAN, (Object)new Timestamp(before.getTime())));
            return this.ofBizDelegator.removeByCondition("ReplicatedIndexOperation", (EntityCondition)new EntityExprList((List)entityConditions, EntityOperator.AND));
        }
        return 0;
    }

    public Set<ReplicatedIndexOperation> getIndexOperationsAfter(String sourceNodeId, Long id) {
        HashSet replicatedIndexOperations = Sets.newHashSet();
        ImmutableList entityConditions = ImmutableList.of((Object)new EntityExpr("nodeId", EntityOperator.EQUALS, (Object)sourceNodeId), (Object)new EntityExpr("id", EntityOperator.GREATER_THAN, (Object)id));
        List gvs = this.ofBizDelegator.findByAnd("ReplicatedIndexOperation", (List)entityConditions);
        for (GenericValue gv : gvs) {
            replicatedIndexOperations.add(this.operationFactory.build(gv));
        }
        return replicatedIndexOperations;
    }

    public ReplicatedIndexOperation getOperation(long id) {
        GenericValue gv = this.ofBizDelegator.findById("ReplicatedIndexOperation", Long.valueOf(id));
        return gv == null ? null : this.operationFactory.build(gv);
    }

    public Long getLatestOperation(String sourceNodeId) {
        List gvs = this.ofBizDelegator.findByAnd(MAX_VIEW, (Map)FieldMap.build((String)"nodeId", (Object)sourceNodeId));
        if (gvs.isEmpty()) {
            return null;
        }
        return ((GenericValue)gvs.get(0)).getLong(MAX_ID);
    }

    public boolean contains(long id) {
        GenericValue gv = this.ofBizDelegator.findByPrimaryKey("ReplicatedIndexOperation", Long.valueOf(id));
        return gv != null;
    }

    private ClusterManager getClusterManager() {
        return (ClusterManager)this.clusterManagerRef.get();
    }

    private static String serialize(Set<Long> ids) {
        return StringUtils.join(ids, (char)',');
    }

    private static Map<String, Object> getIndexOperationFields(Timestamp indexTime, AffectedIndex affectedIndex, SharedEntityType entityType, ReplicatedIndexOperation.Operation operation, String nodeId, Set<Long> affectedIds, String backupFilename) {
        return ImmutableMap.builder().put((Object)"indexTime", (Object)indexTime).put((Object)"operation", (Object)operation.toString()).put((Object)"nodeId", (Object)nodeId).put((Object)"affectedIndex", (Object)affectedIndex.toString()).put((Object)"entityType", (Object)entityType.toString()).put((Object)"affectedIds", (Object)OfBizReplicatedIndexOperationStore.serialize(affectedIds)).put((Object)"filename", (Object)backupFilename).build();
    }
}

