/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.index.ha;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.Message;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.ComponentReference;
import com.atlassian.jira.config.util.IndexPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.index.ha.IndexCopyService;
import com.atlassian.jira.index.ha.IndexRecoveryManager;
import com.atlassian.jira.index.ha.IndexSnapshotContribution;
import com.atlassian.jira.index.ha.IndexUtils;
import com.atlassian.jira.index.ha.IndexesRestoredEvent;
import com.atlassian.jira.index.ha.OfBizReplicatedIndexOperationStore;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.PathUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import javax.annotation.Nullable;
import org.ofbiz.core.entity.DelegatorInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexCopyService
implements IndexCopyService {
    public static final String BACKUP_INDEX_DONE = "Index Backed Up";
    public static final String BACKUP_INDEX = "Backup Index";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultIndexCopyService.class);
    private static final String INDEX_BACKUP_SEQUENCE = "IndexBackupSequence";
    private MessageConsumer messageConsumer;

    public DefaultIndexCopyService(IndexPathManager indexPathManager, JiraHome jiraHome, IndexUtils indexUtils, MessageHandlerService messageHandlerService, EventPublisher eventPublisher, IndexRecoveryManager indexRecoveryManager, DelegatorInterface delegatorInterface, I18nHelper i18n, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore) {
        String sharedIndexPath = PathUtils.joinPaths((String[])new String[]{jiraHome.getHome().getAbsolutePath(), "caches"});
        this.messageConsumer = new MessageConsumer(indexUtils, indexRecoveryManager, delegatorInterface, indexPathManager.getIndexRootPath(), messageHandlerService, sharedIndexPath, eventPublisher, ofBizNodeIndexOperationStore);
        messageHandlerService.registerListener(BACKUP_INDEX, this.messageConsumer);
        messageHandlerService.registerListener(BACKUP_INDEX_DONE, this.messageConsumer);
    }

    @Override
    public String backupIndex(String requestingNode) {
        return this.backupIndex(requestingNode, null);
    }

    @Override
    public String backupIndex(String requestingNode, IndexSnapshotContribution contribution) {
        return this.messageConsumer.backupIndex(requestingNode, contribution);
    }

    @Override
    public void restoreIndex(String filePath) {
        this.messageConsumer.restoreIndex(filePath);
    }

    @VisibleForTesting
    String copyIndex(String sourcePath, String destinationPath, Long id) {
        return this.messageConsumer.copyIndex(sourcePath, destinationPath, id, null);
    }

    private static class MessageConsumer
    implements ClusterMessageConsumer {
        private static final int MAX_SNAPSHOTS = 3;
        private final IndexUtils indexUtils;
        private final IndexRecoveryManager indexRecoveryManager;
        private final DelegatorInterface delegatorInterface;
        private final String localIndexPath;
        private final MessageHandlerService messageHandlerService;
        private final String sharedIndexPath;
        private final EventPublisher eventPublisher;
        private final OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore;
        private final ComponentReference<ClusterManager> clusterManagerRef = ComponentAccessor.getComponentReference(ClusterManager.class);

        public MessageConsumer(IndexUtils indexUtils, IndexRecoveryManager indexRecoveryManager, DelegatorInterface delegatorInterface, String localIndexPath, MessageHandlerService messageHandlerService, String sharedIndexPath, EventPublisher eventPublisher, OfBizReplicatedIndexOperationStore ofBizNodeIndexOperationStore) {
            this.indexUtils = indexUtils;
            this.indexRecoveryManager = indexRecoveryManager;
            this.delegatorInterface = delegatorInterface;
            this.localIndexPath = localIndexPath;
            this.messageHandlerService = messageHandlerService;
            this.sharedIndexPath = sharedIndexPath;
            this.eventPublisher = eventPublisher;
            this.ofBizNodeIndexOperationStore = ofBizNodeIndexOperationStore;
        }

        public String backupIndex(String requestingNode) {
            return this.backupIndex(requestingNode, null);
        }

        public String backupIndex(String requestingNode, IndexSnapshotContribution contribution) {
            if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
                LOG.info("Index backup started. Requesting node: {}", (Object)requestingNode);
                String nodeId = ((ClusterManager)this.clusterManagerRef.get()).getNodeId();
                Long latestOperation = this.ofBizNodeIndexOperationStore.getLatestOperation(nodeId);
                if (latestOperation == null) {
                    LOG.warn("Index backup failed - latest index operation not found. Requesting node: {}", (Object)requestingNode);
                    return null;
                }
                Long backupId = this.delegatorInterface.getNextSeqId(DefaultIndexCopyService.INDEX_BACKUP_SEQUENCE);
                String backupFileName = this.copyIndex(this.localIndexPath, this.sharedIndexPath, backupId, contribution);
                if (!requestingNode.equals(nodeId)) {
                    this.messageHandlerService.sendMessage(requestingNode, new Message(DefaultIndexCopyService.BACKUP_INDEX_DONE, backupFileName));
                }
                LOG.info("Index backup complete. Snapshot file: {}", (Object)backupFileName);
                return backupFileName;
            }
            return null;
        }

        @VisibleForTesting
        String copyIndex(String sourcePath, String destinationPath, Long id, @Nullable IndexSnapshotContribution contribution) {
            return this.indexUtils.takeIndexSnapshot(sourcePath, destinationPath, id.toString(), 3, contribution);
        }

        public void restoreIndex(String fileName) {
            if (((ClusterManager)this.clusterManagerRef.get()).isClustered()) {
                LOG.info("Index restore started. Snapshot file: {}", (Object)fileName);
                File backupFile = new File(this.sharedIndexPath, fileName);
                try {
                    this.indexRecoveryManager.recoverIndexFromBackup(backupFile, TaskProgressSink.NULL_SINK);
                }
                catch (IndexException e) {
                    throw new RuntimeException(e);
                }
                this.eventPublisher.publish((Object)IndexesRestoredEvent.INSTANCE);
                LOG.info("Index restore complete");
            }
        }

        public void receive(String channel, String message, String senderId) {
            if (channel.equals(DefaultIndexCopyService.BACKUP_INDEX)) {
                this.backupIndex(senderId);
            } else if (channel.equals(DefaultIndexCopyService.BACKUP_INDEX_DONE)) {
                this.restoreIndex(message);
            }
        }
    }
}

