/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.handler;

import com.atlassian.jira.exception.ParseException;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import com.atlassian.jira.util.dbc.Null;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntity;
import org.ofbiz.core.entity.model.ModelEntity;

public class IssuePartitionHandler
implements ImportOfBizEntityHandler {
    protected final GenericDelegator delegator;
    private final BackupProject backupProject;
    private final ModelEntity modelEntity;
    private final ProjectImportTemporaryFiles projectImportTemporaryFiles;
    private int entityCount;
    private PrintWriter printWriter;

    public IssuePartitionHandler(BackupProject backupProject, ProjectImportTemporaryFiles projectImportTemporaryFiles, ModelEntity modelEntity, DelegatorInterface delegatorInterface) {
        this.assertModelEntityForName(modelEntity, "Issue");
        this.projectImportTemporaryFiles = projectImportTemporaryFiles;
        this.delegator = GenericDelegator.getGenericDelegator((String)delegatorInterface.getDelegatorName());
        this.backupProject = backupProject;
        this.modelEntity = modelEntity;
    }

    public void handleEntity(String entityName, Map<String, String> attributes) throws ParseException {
        if ("Issue".equals(entityName)) {
            if (this.printWriter == null) {
                try {
                    this.printWriter = this.projectImportTemporaryFiles.getWriter("Issue");
                }
                catch (IOException e) {
                    throw new ParseException(e.getMessage());
                }
            }
            if (this.backupProject.containsIssue(this.getId(attributes))) {
                GenericEntity genericEntity = new GenericEntity(this.delegator, this.modelEntity, attributes);
                genericEntity.writeXmlText(this.printWriter, null);
                ++this.entityCount;
            }
        } else {
            this.endDocument();
        }
    }

    public int getEntityCount() {
        return this.entityCount;
    }

    String getId(Map attributes) {
        return (String)attributes.get("id");
    }

    public void startDocument() {
    }

    public void endDocument() {
        this.printWriter = null;
    }

    public void assertModelEntityForName(ModelEntity modelEntity, String expectedName) {
        Null.not("modelEntity", modelEntity);
        Null.not("expectedName", expectedName);
        if (!expectedName.equals(modelEntity.getEntityName())) {
            throw new IllegalArgumentException("This handler must only be created with a " + expectedName + " model entity");
        }
    }
}

