/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.external.ExternalException;
import com.atlassian.jira.external.beans.ExternalComponent;
import com.atlassian.jira.external.beans.ExternalCustomField;
import com.atlassian.jira.external.beans.ExternalProject;
import com.atlassian.jira.external.beans.ExternalProjectRoleActor;
import com.atlassian.jira.external.beans.ExternalUser;
import com.atlassian.jira.external.beans.ExternalVersion;
import com.atlassian.jira.imports.project.ProjectImportManager;
import com.atlassian.jira.imports.project.ProjectImportPersister;
import com.atlassian.jira.imports.project.ao.handler.AoEntityHandler;
import com.atlassian.jira.imports.project.ao.handler.AoImportHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.ao.handler.AoOverviewHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.ao.handler.AoPartitionHandler;
import com.atlassian.jira.imports.project.ao.handler.AoPreImportHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.ao.handler.ChainedAoSaxHandler;
import com.atlassian.jira.imports.project.ao.handler.PluggableImportAoEntityHandler;
import com.atlassian.jira.imports.project.ao.handler.PluggableOverviewAoEntityHandler;
import com.atlassian.jira.imports.project.ao.handler.PluggableValidator;
import com.atlassian.jira.imports.project.ao.handler.ValidatorModuleDescriptor;
import com.atlassian.jira.imports.project.core.BackupOverview;
import com.atlassian.jira.imports.project.core.BackupOverviewBuilder;
import com.atlassian.jira.imports.project.core.BackupProject;
import com.atlassian.jira.imports.project.core.BackupSystemInformation;
import com.atlassian.jira.imports.project.core.MappingResult;
import com.atlassian.jira.imports.project.core.ProjectImportData;
import com.atlassian.jira.imports.project.core.ProjectImportDataImpl;
import com.atlassian.jira.imports.project.core.ProjectImportOptions;
import com.atlassian.jira.imports.project.core.ProjectImportResults;
import com.atlassian.jira.imports.project.core.ValidationMessage;
import com.atlassian.jira.imports.project.customfield.ExternalCustomFieldConfiguration;
import com.atlassian.jira.imports.project.customfield.ProjectImportableCustomFieldParser;
import com.atlassian.jira.imports.project.handler.AbortImportException;
import com.atlassian.jira.imports.project.handler.AttachmentFileValidatorHandler;
import com.atlassian.jira.imports.project.handler.AttachmentPersisterHandler;
import com.atlassian.jira.imports.project.handler.BackupOverviewHandler;
import com.atlassian.jira.imports.project.handler.ChainedOfBizSaxHandler;
import com.atlassian.jira.imports.project.handler.ChangeGroupPersisterHandler;
import com.atlassian.jira.imports.project.handler.ChangeItemPersisterHandler;
import com.atlassian.jira.imports.project.handler.CommentPersisterHandler;
import com.atlassian.jira.imports.project.handler.ComponentPersisterHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldMapperHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldOptionsMapperHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldValuePersisterHandler;
import com.atlassian.jira.imports.project.handler.CustomFieldValueValidatorHandler;
import com.atlassian.jira.imports.project.handler.EntityPropertiesPersisterHandler;
import com.atlassian.jira.imports.project.handler.GenericEntitiesPartitionHandler;
import com.atlassian.jira.imports.project.handler.GroupMapperHandler;
import com.atlassian.jira.imports.project.handler.ImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.handler.IssueComponentMapperHandler;
import com.atlassian.jira.imports.project.handler.IssueLinkMapperHandler;
import com.atlassian.jira.imports.project.handler.IssueLinkPersisterHandler;
import com.atlassian.jira.imports.project.handler.IssueMapperHandler;
import com.atlassian.jira.imports.project.handler.IssuePartitionHandler;
import com.atlassian.jira.imports.project.handler.IssuePersisterHandler;
import com.atlassian.jira.imports.project.handler.IssueRelatedEntitiesPartitionHandler;
import com.atlassian.jira.imports.project.handler.IssueTypeMapperHandler;
import com.atlassian.jira.imports.project.handler.IssueVersionMapperHandler;
import com.atlassian.jira.imports.project.handler.LabelsPersisterHandler;
import com.atlassian.jira.imports.project.handler.OfBizImportHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.handler.OfBizPreImportHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.handler.PluggableImportHandler;
import com.atlassian.jira.imports.project.handler.PluggableImportOfBizEntityHandler;
import com.atlassian.jira.imports.project.handler.PluggableImportRunnable;
import com.atlassian.jira.imports.project.handler.PostImportHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.handler.PreImportHandlerModuleDescriptor;
import com.atlassian.jira.imports.project.handler.ProjectIssueSecurityLevelMapperHandler;
import com.atlassian.jira.imports.project.handler.ProjectMapperHandler;
import com.atlassian.jira.imports.project.handler.ProjectRoleActorMapperHandler;
import com.atlassian.jira.imports.project.handler.RegisterUserMapperHandler;
import com.atlassian.jira.imports.project.handler.RequiredProjectRolesMapperHandler;
import com.atlassian.jira.imports.project.handler.SimpleEntityMapperHandler;
import com.atlassian.jira.imports.project.handler.UserAssociationPersisterHandler;
import com.atlassian.jira.imports.project.handler.UserMapperHandler;
import com.atlassian.jira.imports.project.handler.VersionPersisterHandler;
import com.atlassian.jira.imports.project.handler.WorklogPersisterHandler;
import com.atlassian.jira.imports.project.mapper.AutomaticDataMapper;
import com.atlassian.jira.imports.project.mapper.CustomFieldMapper;
import com.atlassian.jira.imports.project.mapper.IssueTypeMapper;
import com.atlassian.jira.imports.project.mapper.MapperEntityRegister;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapper;
import com.atlassian.jira.imports.project.mapper.ProjectImportMapperImpl;
import com.atlassian.jira.imports.project.mapper.SimpleProjectImportIdMapper;
import com.atlassian.jira.imports.project.mapper.UserMapper;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParser;
import com.atlassian.jira.imports.project.parser.CustomFieldValueParserImpl;
import com.atlassian.jira.imports.project.parser.IssueLinkParserImpl;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParser;
import com.atlassian.jira.imports.project.parser.ProjectRoleActorParserImpl;
import com.atlassian.jira.imports.project.taskprogress.EntityCountTaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.EntityTypeTaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressInterval;
import com.atlassian.jira.imports.project.taskprogress.TaskProgressProcessor;
import com.atlassian.jira.imports.project.taskprogress.ThrottlingTaskProgressProcessor;
import com.atlassian.jira.imports.project.transformer.IssueLinkTransformerImpl;
import com.atlassian.jira.imports.project.util.AoImportTemporaryFiles;
import com.atlassian.jira.imports.project.util.AoImportTemporaryFilesImpl;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFiles;
import com.atlassian.jira.imports.project.util.ProjectImportTemporaryFilesImpl;
import com.atlassian.jira.imports.project.validation.ProjectImportValidators;
import com.atlassian.jira.imports.xml.BackupXmlParser;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.AttachmentStore;
import com.atlassian.jira.issue.customfields.CustomFieldType;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.CachingProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleAndActorStore;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.ImportUtils;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.concurrent.BoundedExecutor;
import com.atlassian.jira.util.concurrent.ThreadFactories;
import com.atlassian.jira.util.dbc.Null;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.model.ModelEntity;
import org.ofbiz.core.entity.model.ModelReader;
import org.ofbiz.core.entity.model.ModelViewEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultProjectImportManager
implements ProjectImportManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultProjectImportManager.class);
    private static final Set<String> IGNORED_ENTITIES = ImmutableSet.of((Object)"OSCurrentStep", (Object)"OSHistoryStep", (Object)"OSCurrentStepPrev", (Object)"OSHistoryStepPrev");
    private final BackupXmlParser backupXmlParser;
    private final DelegatorInterface genericDelegator;
    private final ApplicationProperties applicationProperties;
    private final IssueManager issueManager;
    private final IssueLinkManager issueLinkManager;
    private final CustomFieldManager customFieldManager;
    private final AutomaticDataMapper automaticDataMapper;
    private final ProjectImportValidators projectImportValidators;
    private final ProjectImportPersister projectImportPersister;
    private final UserUtil userUtil;
    private final GroupManager groupManager;
    private final ProjectRoleManager projectRoleManager;
    private final ProjectManager projectManager;
    private final ProjectRoleAndActorStore projectRoleAndActorStore;
    private final AttachmentStore attachmentStore;
    private final PluginAccessor pluginAccessor;
    private final Clock clock;
    private static final int DEFAULT_ENTITY_COUNT = 100;
    private static final int THREAD_POOL_SIZE = 10;
    private static final int THREAD_POOL_QUEUE_SIZE = 20;

    public DefaultProjectImportManager(BackupXmlParser backupXmlParser, DelegatorInterface genericDelegator, ApplicationProperties applicationProperties, IssueManager issueManager, IssueLinkManager issueLinkManager, CustomFieldManager customFieldManager, AutomaticDataMapper automaticDataMapper, ProjectImportValidators projectImportValidators, ProjectImportPersister projectImportPersister, UserUtil userUtil, GroupManager groupManager, ProjectRoleManager projectRoleManager, ProjectManager projectManager, ProjectRoleAndActorStore projectRoleAndActorStore, AttachmentStore attachmentStore, PluginAccessor pluginAccessor, Clock clock) {
        this.backupXmlParser = backupXmlParser;
        this.genericDelegator = genericDelegator;
        this.applicationProperties = applicationProperties;
        this.issueManager = issueManager;
        this.issueLinkManager = issueLinkManager;
        this.customFieldManager = customFieldManager;
        this.automaticDataMapper = automaticDataMapper;
        this.projectImportValidators = projectImportValidators;
        this.projectImportPersister = projectImportPersister;
        this.userUtil = userUtil;
        this.groupManager = groupManager;
        this.projectRoleManager = projectRoleManager;
        this.projectManager = projectManager;
        this.projectRoleAndActorStore = projectRoleAndActorStore;
        this.attachmentStore = attachmentStore;
        this.pluginAccessor = pluginAccessor;
        this.clock = clock;
    }

    @Override
    public BackupOverview getBackupOverview(String pathToBackupXml, TaskProgressSink taskProgressSink, I18nHelper i18n) throws IOException, SAXException {
        Null.not("pathToBackupXml", pathToBackupXml);
        ChainedOfBizSaxHandler ofbizHandler = this.getOfBizChainedHandler(new EntityTypeTaskProgressProcessor(this.getTotalEntitiesCount(), taskProgressSink, i18n));
        BackupOverviewHandler backupOverviewHandler = new BackupOverviewHandler();
        ofbizHandler.registerHandler(backupOverviewHandler);
        this.backupXmlParser.parseOfBizBackupXml(pathToBackupXml, ofbizHandler);
        BackupOverviewBuilder backupOverviewBuilder = backupOverviewHandler.getBackupOverviewBuilder();
        ChainedAoSaxHandler aoHandler = this.getAoChainedHandler(null);
        Iterable<PluggableOverviewAoEntityHandler> aoOverviewImportHandlers = this.getAoOverviewImportHandlers(backupOverviewBuilder);
        aoHandler.registerHandlers(aoOverviewImportHandlers);
        this.backupXmlParser.parseAoBackupXml(pathToBackupXml, aoHandler);
        return backupOverviewBuilder.getBackupOverview();
    }

    @Override
    public ProjectImportData getProjectImportData(ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressProcessor taskProgressProcessor) throws IOException, SAXException {
        Null.not("backupProject", backupProject);
        Null.not("projectImportOptions", projectImportOptions);
        Null.not("pathToBackupXml", projectImportOptions.getPathToBackup());
        Null.not("backupSystemInformation", backupSystemInformation);
        ProjectImportData projectImportData = this.getCoreProjectImportData(projectImportOptions, backupProject, backupSystemInformation, taskProgressProcessor);
        return this.getAoProjectImportData(projectImportOptions, backupProject, backupSystemInformation, taskProgressProcessor, projectImportData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectImportData getCoreProjectImportData(ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressProcessor taskProgressProcessor) throws IOException, SAXException {
        ChainedOfBizSaxHandler handler = this.getOfBizChainedHandler(taskProgressProcessor);
        String encoding = this.getApplicationEncoding();
        ProjectImportTemporaryFilesImpl projectImportTemporaryFiles = new ProjectImportTemporaryFilesImpl(backupProject.getProject().getKey(), backupSystemInformation.getEntityTypes(), encoding);
        AoImportTemporaryFilesImpl aoImportTemporaryFiles = new AoImportTemporaryFilesImpl(projectImportTemporaryFiles.getParentDirectory());
        try {
            IssuePartitionHandler issuePartitonHandler = this.getIssuePartitioner(projectImportTemporaryFiles, backupProject);
            handler.registerHandler(issuePartitonHandler);
            IssueRelatedEntitiesPartitionHandler customFieldPartionHandler = this.getCustomFieldValuesHandler(projectImportTemporaryFiles, backupProject);
            handler.registerHandler(customFieldPartionHandler);
            IssueRelatedEntitiesPartitionHandler relatedEntitiesPartionHandler = this.getIssueRelatedEntitesHandler(projectImportTemporaryFiles, backupProject);
            handler.registerHandler(relatedEntitiesPartionHandler);
            IssueRelatedEntitiesPartitionHandler fileAttachmentHandler = null;
            if (StringUtils.isNotEmpty((String)projectImportOptions.getAttachmentPath())) {
                fileAttachmentHandler = this.getFileAttachmentHandler(projectImportTemporaryFiles, backupProject);
                handler.registerHandler(fileAttachmentHandler);
            }
            GenericEntitiesPartitionHandler genericEntitiesPartionHandler = this.getGenericEntitesHandler(projectImportTemporaryFiles, backupProject, backupSystemInformation);
            handler.registerHandler(genericEntitiesPartionHandler);
            ProjectImportMapperImpl projectImportMapper = new ProjectImportMapperImpl(this.userUtil, this.groupManager);
            this.populateCustomFieldMapperOldValues(backupProject, projectImportMapper.getCustomFieldMapper());
            this.populateVersionMapperOldValues(backupProject, projectImportMapper.getVersionMapper());
            this.populateComponentMapperOldValues(backupProject, projectImportMapper.getComponentMapper());
            handler.registerHandler(this.getUserMapperHandler(projectImportOptions, backupProject, projectImportMapper));
            handler.registerHandler(this.getGroupMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getProjectIssueSecurityLevelMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueTypeMapperHandler(projectImportMapper));
            handler.registerHandler(this.getPriorityMapperHandler(projectImportMapper));
            handler.registerHandler(this.getResolutionMapperHandler(projectImportMapper));
            handler.registerHandler(this.getStatusMapperHandler(projectImportMapper));
            handler.registerHandler(this.getCustomFieldMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getProjectMapperHandler(projectImportMapper));
            handler.registerHandler(this.getCustomFieldOptionMapperHandler(projectImportMapper));
            handler.registerHandler(this.getProjectRoleRegistrationHandler(projectImportMapper));
            handler.registerHandler(this.getRequiredProjectRolesMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueVersionMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueComponentMapperHandler(backupProject, projectImportMapper));
            handler.registerHandler(this.getIssueLinkMapperHandler(backupProject, backupSystemInformation, projectImportMapper));
            handler.registerHandler(this.getRegisterUserMapperHandler(projectImportMapper));
            handler.registerHandler(this.getProjectRoleActorMapperHandler(backupProject, projectImportMapper));
            handler.registerHandlers(this.getOfBizPluginPreImportHandlers(backupProject, backupSystemInformation, projectImportMapper, null));
            this.backupXmlParser.parseOfBizBackupXml(projectImportOptions.getPathToBackup(), handler);
            projectImportMapper.getCustomFieldMapper().registerIssueTypesInUse();
            int fileAttachmentCount = 0;
            if (fileAttachmentHandler != null) {
                fileAttachmentCount = fileAttachmentHandler.getEntityCount();
            }
            ProjectImportDataImpl projectImportDataImpl = new ProjectImportDataImpl(projectImportMapper, projectImportTemporaryFiles, aoImportTemporaryFiles, issuePartitonHandler.getEntityCount(), customFieldPartionHandler.getEntityCount(), relatedEntitiesPartionHandler.getEntityCount(), fileAttachmentCount, relatedEntitiesPartionHandler.getSecondDegreeEntityCount(), genericEntitiesPartionHandler.getEntityCount());
            return projectImportDataImpl;
        }
        finally {
            projectImportTemporaryFiles.closeWriters();
        }
    }

    private ProjectImportData getAoProjectImportData(ProjectImportOptions projectImportOptions, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressProcessor taskProgressProcessor, ProjectImportData projectImportData) throws IOException, SAXException {
        ChainedAoSaxHandler handler = this.getAoChainedHandler(taskProgressProcessor);
        String encoding = this.getApplicationEncoding();
        handler.registerHandler(this.getAoPartitionHandler(projectImportData.getTemporaryAoFiles(), encoding));
        handler.registerHandlers(this.getAoPluginPreImportHandlers(backupProject, backupSystemInformation, projectImportData.getProjectImportMapper(), null));
        this.backupXmlParser.parseAoBackupXml(projectImportOptions.getPathToBackup(), handler);
        return projectImportData;
    }

    private Iterable<PluggableValidator> getPluggableValidators() {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(ValidatorModuleDescriptor.class);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)moduleDescriptors, (Function)new Function<ValidatorModuleDescriptor, PluggableValidator>(){

            public PluggableValidator apply(ValidatorModuleDescriptor moduleDescriptor) {
                return (PluggableValidator)moduleDescriptor.getModule();
            }
        }));
    }

    private Iterable<PluggableOverviewAoEntityHandler> getAoOverviewImportHandlers(final BackupOverviewBuilder backupOverviewBuilder) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(AoOverviewHandlerModuleDescriptor.class);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)moduleDescriptors, (Function)new Function<AoOverviewHandlerModuleDescriptor, PluggableOverviewAoEntityHandler>(){

            public PluggableOverviewAoEntityHandler apply(AoOverviewHandlerModuleDescriptor moduleDescriptor) {
                PluggableOverviewAoEntityHandler handler = (PluggableOverviewAoEntityHandler)moduleDescriptor.getModule();
                handler.setBackupOverviewBuilder(backupOverviewBuilder);
                return handler;
            }
        }));
    }

    private Iterable<PluggableImportRunnable> getPreImportHandlers(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults) {
        return this.getHandlersByType(backupProject, backupSystemInformation, projectImportMapper, projectImportResults, PreImportHandlerModuleDescriptor.class);
    }

    private Iterable<PluggableImportRunnable> getPostImportHandlers(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults) {
        return this.getHandlersByType(backupProject, backupSystemInformation, projectImportMapper, projectImportResults, PostImportHandlerModuleDescriptor.class);
    }

    private Iterable<PluggableImportOfBizEntityHandler> getOfBizPluginPreImportHandlers(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults) {
        return this.getHandlersByType(backupProject, backupSystemInformation, projectImportMapper, projectImportResults, OfBizPreImportHandlerModuleDescriptor.class);
    }

    private Iterable<PluggableImportOfBizEntityHandler> getOfBizPluginImportHandlers(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults) {
        return this.getHandlersByType(backupProject, backupSystemInformation, projectImportMapper, projectImportResults, OfBizImportHandlerModuleDescriptor.class);
    }

    private Iterable<PluggableImportAoEntityHandler> getAoPluginPreImportHandlers(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults) {
        return this.getHandlersByType(backupProject, backupSystemInformation, projectImportMapper, projectImportResults, AoPreImportHandlerModuleDescriptor.class);
    }

    private Iterable<PluggableImportAoEntityHandler> getAoPluginImportHandlers(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults) {
        return this.getHandlersByType(backupProject, backupSystemInformation, projectImportMapper, projectImportResults, AoImportHandlerModuleDescriptor.class);
    }

    private <T extends PluggableImportHandler> Iterable<T> getHandlersByType(final BackupProject backupProject, final BackupSystemInformation backupSystemInformation, final ProjectImportMapper projectImportMapper, final ProjectImportResults projectImportResults, Class<? extends ModuleDescriptor<T>> moduleDescriptorClass) {
        List moduleDescriptors = this.pluginAccessor.getEnabledModuleDescriptorsByClass(moduleDescriptorClass);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)moduleDescriptors, (Function)new Function<ModuleDescriptor<T>, T>(){

            public T apply(ModuleDescriptor<T> moduleDescriptor) {
                PluggableImportHandler handler = (PluggableImportHandler)moduleDescriptor.getModule();
                handler.setBackupProject(backupProject);
                handler.setBackupSystemInformation(backupSystemInformation);
                handler.setProjectImportMapper(projectImportMapper);
                handler.setProjectImportResults(projectImportResults);
                return handler;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createMissingUsers(final UserMapper userMapper, final ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval) throws AbortImportException {
        final I18nHelper i18n = projectImportResults.getI18n();
        Collection users = userMapper.getUsersToAutoCreate();
        final EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.users"), users.size(), i18n);
        final AtomicInteger count = new AtomicInteger(0);
        BoundedExecutor executor = this.createExecutor("ProjectImport: CreateUsers");
        try {
            for (final ExternalUser user : users) {
                if (projectImportResults.abortImport()) {
                    break;
                }
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        boolean userCreated = DefaultProjectImportManager.this.projectImportPersister.createUser(userMapper, user);
                        if (!userCreated) {
                            projectImportResults.addError(i18n.getText("admin.errors.project.import.could.not.create.user", user.getName()));
                        } else {
                            projectImportResults.incrementUsersCreatedCount();
                        }
                        int currentCount = count.incrementAndGet();
                        taskProgressProcessor.processTaskProgress(i18n.getText("admin.common.words.users"), currentCount);
                    }
                });
            }
        }
        finally {
            if (projectImportResults.abortImport()) {
                executor.shutdownAndIgnoreQueue();
                throw new AbortImportException();
            }
            executor.shutdownAndWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProjectRoleMembers(Project project, final ProjectImportMapper projectImportMapper, final ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval) throws AbortImportException {
        final I18nHelper i18n = projectImportResults.getI18n();
        this.projectRoleManager.removeAllRoleActorsByProject(project);
        final ProjectRoleActorParser projectRoleActorParser = this.getProjectRoleActorParser();
        Collection projectRoleActors = projectImportMapper.getProjectRoleActorMapper().getAllProjectRoleActors();
        final EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18n.getText("admin.common.words.projectrole"), projectRoleActors.size(), i18n);
        final AtomicInteger count = new AtomicInteger(0);
        BoundedExecutor executor = this.createExecutor("ProjectImport: CreateRoleMemebers");
        try {
            for (Object projectRoleActor1 : projectRoleActors) {
                if (projectImportResults.abortImport()) {
                    break;
                }
                final ExternalProjectRoleActor projectRoleActor = (ExternalProjectRoleActor)projectRoleActor1;
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (projectRoleActor.isUserActor()) {
                            DefaultProjectImportManager.this.createUserRoleActor(projectImportMapper, projectImportResults, projectRoleActorParser, projectRoleActor);
                        } else if (projectRoleActor.isGroupActor()) {
                            DefaultProjectImportManager.this.createGroupRoleActor(projectImportMapper, projectImportResults, projectRoleActorParser, projectRoleActor);
                        } else {
                            String projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
                            log.warn("Project role '" + projectRoleName + "' contains a project role actor '" + projectRoleActor.getRoleActor() + "' with unknown role type '" + projectRoleActor.getRoleType() + "', we cannot add this actor to the project role.");
                        }
                        int currentCount = count.incrementAndGet();
                        taskProgressProcessor.processTaskProgress(i18n.getText("admin.common.words.projectrole"), currentCount);
                    }
                });
            }
        }
        finally {
            executor.shutdownAndWait();
            if (this.projectRoleAndActorStore instanceof CachingProjectRoleAndActorStore) {
                ((CachingProjectRoleAndActorStore)this.projectRoleAndActorStore).clearCaches();
            }
            if (projectImportResults.abortImport()) {
                throw new AbortImportException();
            }
        }
    }

    @Override
    public void importProject(ProjectImportOptions projectImportOptions, ProjectImportMapper projectImportMapper, BackupProject backupProject, ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval) throws AbortImportException {
        Map<String, ProjectComponent> newComponents;
        Map<String, Version> newVersions;
        Project project;
        SimpleProjectImportIdMapper projectMapper = projectImportMapper.getProjectMapper();
        ExternalProject externalProject = backupProject.getProject();
        ExternalProject transformedProject = this.transformProject(externalProject, projectImportMapper);
        if (projectMapper.getMappedId(externalProject.getId()) == null) {
            try {
                project = this.projectImportPersister.createProject(transformedProject);
            }
            catch (ExternalException e) {
                log.error("An error occurred while trying to create the project '" + externalProject.getKey() + "' for project import. The import will be aborted.", (Throwable)((Object)e));
                throw new AbortImportException();
            }
            projectMapper.mapValue(externalProject.getId(), project.getId().toString());
        } else {
            project = projectImportOptions.overwriteProjectDetails() ? this.projectImportPersister.updateProjectDetails(transformedProject) : this.projectManager.getProjectObjByKey(externalProject.getKey());
        }
        projectImportResults.setImportedProject(project);
        try {
            this.projectImportPersister.updateProjectIssueCounter(backupProject, Long.parseLong(externalProject.getCounter()));
        }
        catch (NumberFormatException e) {
            log.warn("The backup project '" + externalProject.getKey() + "' has an invalid issue counter '" + externalProject.getCounter() + "'. The import will continue, but issue creation may produce warnings in the log.");
        }
        try {
            newVersions = this.projectImportPersister.createVersions(backupProject);
        }
        catch (DataAccessException e) {
            log.error("Failed to create project versions", (Throwable)e);
            throw new AbortImportException();
        }
        this.populateVersionMapper(projectImportMapper.getVersionMapper(), newVersions);
        try {
            newComponents = this.projectImportPersister.createComponents(backupProject, projectImportMapper);
        }
        catch (DataAccessException e) {
            log.error("Failed to create project components", (Throwable)e);
            throw new AbortImportException();
        }
        this.populateComponentMapper(projectImportMapper.getComponentMapper(), newComponents);
        if (projectImportOptions.overwriteProjectDetails()) {
            this.importProjectRoleMembers(project, projectImportMapper, projectImportResults, taskProgressInterval);
        }
    }

    private ExternalProject transformProject(ExternalProject externalProject, ProjectImportMapper projectImportMapper) {
        ExternalProject transformedProject = new ExternalProject();
        transformedProject.setId(externalProject.getId());
        transformedProject.setKey(externalProject.getKey());
        transformedProject.setOriginalKey(externalProject.getOriginalKey());
        transformedProject.setProjectTypeKey(externalProject.getProjectTypeKey());
        transformedProject.setName(externalProject.getName());
        transformedProject.setAssigneeType(externalProject.getAssigneeType());
        transformedProject.setCounter(externalProject.getCounter());
        transformedProject.setDescription(externalProject.getDescription());
        transformedProject.setEmailSender(externalProject.getEmailSender());
        transformedProject.setLead(projectImportMapper.getUserMapper().getMappedUserKey(externalProject.getLead()));
        transformedProject.setProjectCategoryName(externalProject.getProjectCategoryName());
        transformedProject.setProjectGV(externalProject.getProjectGV());
        transformedProject.setUrl(externalProject.getUrl());
        return transformedProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doImport(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, TaskProgressInterval taskProgressInterval, I18nHelper i18n, ApplicationUser importAuthor) throws IOException, SAXException, IndexException {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        try {
            this.subvertSecurityIndexingNotifications();
            this.pluginPreProcessing(backupProject, backupSystemInformation, projectImportData, projectImportResults);
            TaskProgressInterval issuesSubInterval = this.getSubInterval(taskProgressInterval, 0, 10);
            long largestIssueKeyNumber = this.importIssues(projectImportData, projectImportResults, i18n, importAuthor, projectImportMapper, issuesSubInterval, backupProject, backupSystemInformation);
            TaskProgressInterval issuesRelatedSubInterval = this.getSubInterval(taskProgressInterval, 10, 20);
            this.importIssueRelatedData(projectImportData, backupSystemInformation, projectImportResults, i18n, importAuthor, projectImportMapper, issuesRelatedSubInterval, backupProject);
            TaskProgressInterval secondDegreeEntitiesSubInterval = this.getSubInterval(taskProgressInterval, 20, 30);
            this.importIssueSecondDegreeEntities(projectImportData, projectImportResults, i18n, projectImportMapper, secondDegreeEntitiesSubInterval, backupProject, backupSystemInformation);
            TaskProgressInterval attachmentSubInterval = this.getSubInterval(taskProgressInterval, 30, 50);
            this.importAttachments(projectImportOptions, projectImportData, backupProject, backupSystemInformation, projectImportResults, i18n, attachmentSubInterval, projectImportMapper);
            TaskProgressInterval custFieldValueSubInterval = this.getSubInterval(taskProgressInterval, 50, 60);
            this.importCustomFieldValues(projectImportData, backupProject, backupSystemInformation, projectImportResults, i18n, projectImportMapper, custFieldValueSubInterval);
            TaskProgressInterval nonIssueDataSubInterval = this.getSubInterval(taskProgressInterval, 60, 70);
            this.importPluginData(projectImportData, backupProject, backupSystemInformation, projectImportResults, i18n, projectImportMapper, nonIssueDataSubInterval);
            this.projectImportPersister.updateProjectIssueCounter(backupProject, largestIssueKeyNumber);
            TaskProgressInterval aoDataSubInterval = this.getSubInterval(taskProgressInterval, 70, 80);
            this.importAoData(projectImportData, aoDataSubInterval, i18n, backupProject, backupSystemInformation, projectImportResults);
            TaskProgressInterval changeItemSubInterval = this.getSubInterval(taskProgressInterval, 80, 90);
            this.importChangeItemEntities(projectImportData, projectImportResults, i18n, projectImportMapper, changeItemSubInterval, backupProject);
            this.pluginPostProcessing(backupProject, backupSystemInformation, projectImportData, projectImportResults);
        }
        finally {
            this.restoreSecurityIndexingNotifications();
            this.issueLinkManager.clearCache();
            log.info("Re-indexing the Project.");
            TaskProgressInterval reIndexSubInterval = this.getSubInterval(taskProgressInterval, 90, 100);
            this.projectImportPersister.reIndexProject(projectImportMapper, reIndexSubInterval, i18n);
            log.info("Finished re-indexing the Project.");
        }
    }

    private void pluginPreProcessing(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportData projectImportData, ProjectImportResults projectImportResults) {
        Iterable<PluggableImportRunnable> handlers = this.getPreImportHandlers(backupProject, backupSystemInformation, projectImportData.getProjectImportMapper(), projectImportResults);
        for (PluggableImportRunnable handler : handlers) {
            handler.run();
        }
    }

    private void pluginPostProcessing(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportData projectImportData, ProjectImportResults projectImportResults) {
        Iterable<PluggableImportRunnable> handlers = this.getPostImportHandlers(backupProject, backupSystemInformation, projectImportData.getProjectImportMapper(), projectImportResults);
        for (PluggableImportRunnable handler : handlers) {
            handler.run();
        }
    }

    private void importAoData(ProjectImportData projectImportData, TaskProgressInterval taskProgressInterval, I18nHelper i18n, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults) throws IOException, SAXException {
        AoImportTemporaryFiles aoImportTemporaryFiles = projectImportData.getTemporaryAoFiles();
        EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.ao"), 0, i18n);
        ChainedAoSaxHandler handler = this.getAoChainedHandler(taskProgressProcessor);
        Iterable<PluggableImportAoEntityHandler> aoPluginImportHandlers = this.getAoPluginImportHandlers(backupProject, backupSystemInformation, projectImportData.getProjectImportMapper(), projectImportResults);
        handler.registerHandlers(aoPluginImportHandlers);
        List<String> entities = this.getOrderedAoFiles(aoPluginImportHandlers, aoImportTemporaryFiles);
        for (String entity : entities) {
            this.backupXmlParser.parseAoBackupXml(aoImportTemporaryFiles.getFileForEntity(entity).getAbsolutePath(), handler);
        }
    }

    private List<String> getOrderedAoFiles(final Iterable<PluggableImportAoEntityHandler> aoPluginImportHandlers, AoImportTemporaryFiles aoImportTemporaryFiles) {
        final LoadingCache cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Long>(){

            @Nonnull
            public Long load(@Nonnull String tableName) throws Exception {
                for (PluggableImportAoEntityHandler handler : aoPluginImportHandlers) {
                    Long weight = handler.getEntityWeight(tableName);
                    if (weight == null || weight.equals(PluggableImportAoEntityHandler.WEIGHT_NONE)) continue;
                    return weight;
                }
                return PluggableImportAoEntityHandler.WEIGHT_NONE;
            }
        });
        ArrayList<String> tableNames = new ArrayList<String>(aoImportTemporaryFiles.getAOXmlFiles().keySet());
        Collections.sort(tableNames, new Comparator<String>(){

            @Override
            public int compare(String tableName1, String tableName2) {
                try {
                    int i = ((Long)cache.get((Object)tableName1)).compareTo((Long)cache.get((Object)tableName2));
                    return i == 0 ? tableName1.compareTo(tableName2) : i;
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        return tableNames;
    }

    @Override
    public void validateCustomFieldValues(ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, TaskProgressProcessor taskProgressProcessor, I18nHelper i18n) throws IOException, SAXException {
        Null.not("backupProject", backupProject);
        Null.not("mappingResult", mappingResult);
        Null.not("projectImportData", projectImportData);
        Null.not("projectImportMapper", projectImportData.getProjectImportMapper());
        List<String> customFieldModelEntities = this.getCustomFieldEntityNames();
        ChainedOfBizSaxHandler handler = this.getOfBizChainedHandler(taskProgressProcessor);
        CustomFieldValueValidatorHandler valueValidatorHandler = this.getCustomFieldValueValidatorHandler(backupProject, projectImportData.getProjectImportMapper());
        handler.registerHandler(valueValidatorHandler);
        for (String entity : customFieldModelEntities) {
            String pathToEntityXml = projectImportData.getPathToEntityXml(entity);
            if (pathToEntityXml == null) continue;
            this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, handler);
        }
        Map customFieldValueMessageSets = valueValidatorHandler.getValidationResults();
        this.projectImportValidators.getCustomFieldOptionMapperValidator().validateMappings(i18n, backupProject, projectImportData.getProjectImportMapper().getCustomFieldOptionMapper(), projectImportData.getProjectImportMapper().getCustomFieldMapper(), customFieldValueMessageSets);
        mappingResult.setCustomFieldValueMessageSets(customFieldValueMessageSets);
    }

    @Override
    public void validateFileAttachments(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, BackupSystemInformation backupSystemInformation, TaskProgressProcessor taskProgressProcessor, I18nHelper i18n) throws IOException, SAXException {
        Null.not("projectImportOptions", projectImportOptions);
        if (StringUtils.isNotEmpty((String)projectImportOptions.getAttachmentPath())) {
            Null.not("backupProject", backupProject);
            Null.not("backupSystemInformation", backupSystemInformation);
            Null.not("mappingResult", mappingResult);
            Null.not("projectImportData", projectImportData);
            List<String> entities = this.getFileAttachmentEntityNames();
            ChainedOfBizSaxHandler handler = this.getOfBizChainedHandler(taskProgressProcessor);
            AttachmentFileValidatorHandler attachmentFileValidatorHandler = this.getAttachmentFileValidatorHandler(backupProject, projectImportOptions, backupSystemInformation, i18n);
            handler.registerHandler(attachmentFileValidatorHandler);
            for (String entity : entities) {
                String pathToEntityXml = projectImportData.getPathToEntityXml(entity);
                if (pathToEntityXml == null) continue;
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, handler);
            }
            projectImportData.setValidAttachmentsCount(attachmentFileValidatorHandler.getValidAttachmentCount());
            MessageSet fileAttachmentsMessageSet = attachmentFileValidatorHandler.getValidationResults();
            mappingResult.setFileAttachmentMessageSet(fileAttachmentsMessageSet);
        } else {
            mappingResult.setFileAttachmentMessageSet((MessageSet)new MessageSetImpl());
        }
    }

    @Override
    public void autoMapAndValidateIssueTypes(ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, I18nHelper i18nBean) {
        IssueTypeMapper issueTypeMapper = projectImportData.getProjectImportMapper().getIssueTypeMapper();
        this.automaticDataMapper.mapIssueTypes(backupProject, issueTypeMapper);
        MessageSet messageSet = this.projectImportValidators.getIssueTypeMapperValidator().validateMappings(i18nBean, backupProject, issueTypeMapper);
        mappingResult.setIssueTypeMessageSet(messageSet);
    }

    @Override
    public void autoMapAndValidateCustomFields(ProjectImportData projectImportData, MappingResult mappingResult, BackupProject backupProject, I18nHelper i18nBean) {
        CustomFieldMapper customFieldMapper = projectImportData.getProjectImportMapper().getCustomFieldMapper();
        IssueTypeMapper issueTypeMapper = projectImportData.getProjectImportMapper().getIssueTypeMapper();
        this.automaticDataMapper.mapCustomFields(backupProject, customFieldMapper, issueTypeMapper);
        MessageSet messageSet = this.projectImportValidators.getCustomFieldMapperValidator().validateMappings(i18nBean, backupProject, issueTypeMapper, customFieldMapper);
        mappingResult.setCustomFieldMessageSet(messageSet);
    }

    @Override
    public void autoMapCustomFieldOptions(ProjectImportData projectImportData, BackupProject backupProject) {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.automaticDataMapper.mapCustomFieldOptions(backupProject, projectImportMapper.getCustomFieldOptionMapper(), projectImportMapper.getCustomFieldMapper(), projectImportMapper.getIssueTypeMapper());
    }

    @Override
    public void autoMapProjectRoles(ProjectImportData projectImportData) {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.automaticDataMapper.mapProjectRoles(projectImportMapper.getProjectRoleMapper());
    }

    @Override
    public void autoMapSystemFields(ProjectImportData projectImportData, BackupProject backupProject) {
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.automaticDataMapper.mapPriorities(projectImportMapper.getPriorityMapper());
        this.automaticDataMapper.mapProjects(projectImportMapper.getProjectMapper());
        this.automaticDataMapper.mapResolutions(projectImportMapper.getResolutionMapper());
        this.automaticDataMapper.mapStatuses(backupProject, projectImportMapper.getStatusMapper(), projectImportMapper.getIssueTypeMapper());
        this.automaticDataMapper.mapIssueLinkTypes(projectImportMapper.getIssueLinkTypeMapper());
        this.automaticDataMapper.mapIssueSecurityLevels(backupProject.getProject().getKey(), projectImportMapper.getIssueSecurityLevelMapper());
    }

    @Override
    public void validateSystemFields(ProjectImportData projectImportData, MappingResult mappingResult, ProjectImportOptions projectImportOptions, BackupProject backupProject, TaskProgressInterval taskProgressInterval, I18nHelper i18nBean) {
        EntityCountTaskProgressProcessor taskProgressProcessor = new EntityCountTaskProgressProcessor(taskProgressInterval, i18nBean.getText("admin.message.project.import.manager.do.mapping.validate.system.fields"), 10, i18nBean);
        ProjectImportMapper projectImportMapper = projectImportData.getProjectImportMapper();
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("issue.field.priority"), 1);
        log.debug("Validating priorities.");
        MessageSet messageSet = this.projectImportValidators.getPriorityMapperValidator().validateMappings(i18nBean, projectImportMapper.getPriorityMapper());
        mappingResult.setPriorityMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("issue.field.resolution"), 2);
        log.debug("Validating resolutions.");
        messageSet = this.projectImportValidators.getResolutionMapperValidator().validateMappings(i18nBean, projectImportMapper.getResolutionMapper());
        mappingResult.setResolutionMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("issue.field.status"), 3);
        log.debug("Validating statuses.");
        messageSet = this.projectImportValidators.getStatusMapperValidator().validateMappings(i18nBean, backupProject, projectImportMapper.getIssueTypeMapper(), projectImportMapper.getStatusMapper());
        mappingResult.setStatusMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.projectrole"), 4);
        log.debug("Validating project roles.");
        messageSet = this.projectImportValidators.getProjectRoleMapperValidator().validateMappings(i18nBean, projectImportMapper.getProjectRoleMapper());
        mappingResult.setProjectRoleMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.projectrole.membership"), 5);
        log.debug("Validating project role actors.");
        messageSet = this.projectImportValidators.getProjectRoleActorMapperValidator().validateProjectRoleActors(i18nBean, projectImportMapper, projectImportOptions);
        mappingResult.setProjectRoleActorMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.users"), 6);
        log.debug("Validating users.");
        messageSet = this.projectImportValidators.getUserMapperValidator().validateMappings(i18nBean, projectImportMapper.getUserMapper());
        mappingResult.setUserMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.group"), 7);
        log.debug("Validating groups.");
        messageSet = this.projectImportValidators.getGroupMapperValidator().validateMappings(i18nBean, (SimpleProjectImportIdMapper)projectImportMapper.getGroupMapper());
        mappingResult.setGroupMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("common.concepts.issuelinktype"), 8);
        log.debug("Validating issue link types.");
        messageSet = this.projectImportValidators.getIssueLinkTypeMapperValidator().validateMappings(i18nBean, backupProject, projectImportMapper.getIssueLinkTypeMapper());
        mappingResult.setIssueLinkTypeMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("admin.common.words.issue.security.level"), 9);
        log.debug("Validating issue security levels.");
        messageSet = this.projectImportValidators.getIssueSecurityLevelValidator().validateMappings(projectImportMapper.getIssueSecurityLevelMapper(), backupProject, i18nBean);
        mappingResult.setIssueSecurityLevelMessageSet(messageSet);
        this.updateTaskProgress(taskProgressProcessor, i18nBean.getText("project.max.text.field.length"), 10);
        log.debug("Validating issue max text length.");
        messageSet = this.projectImportValidators.getSystemFieldsMaxTextLengthValidator().validate(backupProject, i18nBean);
        mappingResult.setTextFieldLengthExceedingLimitMessageSet(messageSet);
    }

    @Override
    public List<ValidationMessage> doPluginValidation(BackupProject backupProject, TaskProgressInterval sysFieldSubInterval, I18nHelper i18n) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        for (PluggableValidator validator : this.getPluggableValidators()) {
            messages.add(validator.validate(backupProject, i18n));
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importCustomFieldValues(ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, ProjectImportMapper projectImportMapper, TaskProgressInterval custFieldValueSubInterval) throws IOException, SAXException {
        BoundedExecutor customFieldValuesExecutor = this.createExecutor("ProjectImport: CreateCustomFieldValues");
        log.info("Creating custom field values.");
        ChainedOfBizSaxHandler customFieldValuesHandler = this.getOfBizChainedHandler(new EntityCountTaskProgressProcessor(custFieldValueSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.custom.field.values"), projectImportData.getCustomFieldValuesEntityCount(), i18n));
        String mappedProjectId = projectImportMapper.getProjectMapper().getMappedId(backupProject.getProject().getId());
        customFieldValuesHandler.registerHandler(this.getCustomFieldValuePersisterHandler(projectImportMapper, mappedProjectId, projectImportResults, backupSystemInformation, customFieldValuesExecutor));
        List<String> customFieldModelEntities = this.getCustomFieldEntityNames();
        customFieldValuesHandler.registerHandlers(this.getOfBizPluginImportHandlers(backupProject, backupSystemInformation, projectImportMapper, projectImportResults));
        try {
            for (String customFieldModelEntity : customFieldModelEntities) {
                String pathToEntityXml = projectImportData.getPathToEntityXml(customFieldModelEntity);
                if (pathToEntityXml == null) continue;
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, customFieldValuesHandler);
            }
            log.info("Finished creating custom field values.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                customFieldValuesExecutor.shutdownAndIgnoreQueue();
            } else {
                customFieldValuesExecutor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importPluginData(ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, ProjectImportMapper projectImportMapper, TaskProgressInterval custFieldValueSubInterval) throws IOException, SAXException {
        BoundedExecutor customFieldValuesExecutor = this.createExecutor("ProjectImport: NonIssueValues");
        log.info("Importing Non Issue data.");
        ChainedOfBizSaxHandler pluginDataHandler = this.getOfBizChainedHandler(new EntityCountTaskProgressProcessor(custFieldValueSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.plugin.values"), projectImportData.getNonIssueEntityCount(), i18n));
        List<String> nonIssueEntities = this.getNonIssueEntityNames(backupSystemInformation);
        pluginDataHandler.registerHandlers(this.getOfBizPluginImportHandlers(backupProject, backupSystemInformation, projectImportMapper, projectImportResults));
        try {
            for (String modelEntity : nonIssueEntities) {
                String pathToEntityXml = projectImportData.getPathToEntityXml(modelEntity);
                if (pathToEntityXml == null) continue;
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, pluginDataHandler);
            }
            log.info("Finished creating custom field values.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                customFieldValuesExecutor.shutdownAndIgnoreQueue();
            } else {
                customFieldValuesExecutor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importAttachments(ProjectImportOptions projectImportOptions, ProjectImportData projectImportData, BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, TaskProgressInterval attachmentSubInterval, ProjectImportMapper projectImportMapper) throws IOException, SAXException {
        boolean isImportingAttachments;
        String pathToFileAttachmentEntityXml = projectImportData.getPathToEntityXml("FileAttachment");
        boolean bl = isImportingAttachments = StringUtils.isNotEmpty((String)projectImportOptions.getAttachmentPath()) && pathToFileAttachmentEntityXml != null;
        if (isImportingAttachments) {
            BoundedExecutor attachmentExecutor = this.createExecutor("ProjectImport: CreateAttachments");
            log.info("Creating the attachments.");
            ChainedOfBizSaxHandler attachmentPersistenceHandler = this.getOfBizChainedHandler(new EntityCountTaskProgressProcessor(attachmentSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.attachments"), projectImportData.getFileAttachmentEntityCount(), i18n));
            AttachmentPersisterHandler attachmentPersisterHandler = new AttachmentPersisterHandler(this.projectImportPersister, projectImportOptions, projectImportData.getProjectImportMapper(), backupProject, backupSystemInformation, projectImportResults, attachmentExecutor, this.attachmentStore);
            attachmentPersistenceHandler.registerHandler(attachmentPersisterHandler);
            attachmentPersistenceHandler.registerHandlers(this.getOfBizPluginImportHandlers(backupProject, backupSystemInformation, projectImportMapper, projectImportResults));
            try {
                this.backupXmlParser.parseOfBizBackupXml(pathToFileAttachmentEntityXml, attachmentPersistenceHandler);
                log.info("Finished creating the attachments.");
            }
            finally {
                if (projectImportResults.abortImport()) {
                    attachmentExecutor.shutdownAndIgnoreQueue();
                } else {
                    attachmentExecutor.shutdownAndWait();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importIssueRelatedData(ProjectImportData projectImportData, BackupSystemInformation backupSystemInformation, ProjectImportResults projectImportResults, I18nHelper i18n, ApplicationUser importAuthor, ProjectImportMapper projectImportMapper, TaskProgressInterval issuesRelatedSubInterval, BackupProject backupProject) throws IOException, SAXException {
        BoundedExecutor issueRelatedExecutor = this.createExecutor("ProjectImport: CreateIssueRelatedData");
        log.info("Creating the issue-related data.");
        ChainedOfBizSaxHandler chainedEntitiesHandler = this.getOfBizChainedHandler(new EntityCountTaskProgressProcessor(issuesRelatedSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.issue.related"), projectImportData.getIssueRelatedEntityCount(), i18n));
        chainedEntitiesHandler.registerHandler(this.getCommentPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getWorklogPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getVersionPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getComponentPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getIssueLinkPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor, importAuthor));
        chainedEntitiesHandler.registerHandler(this.getUserAssociationPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getChangeGroupPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getLabelPersisterHandler(projectImportMapper, projectImportResults, backupSystemInformation, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandler(this.getIssuePropertiesPersisterHandler(projectImportMapper, projectImportResults, issueRelatedExecutor));
        chainedEntitiesHandler.registerHandlers(this.getOfBizPluginImportHandlers(backupProject, backupSystemInformation, projectImportMapper, projectImportResults));
        try {
            for (String modelEntity : this.getIssueRelatedEntityNames()) {
                String pathToEntityXml = projectImportData.getPathToEntityXml(modelEntity);
                if (pathToEntityXml == null) continue;
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, chainedEntitiesHandler);
            }
            log.info("Finished creating the issue-related data.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                issueRelatedExecutor.shutdownAndIgnoreQueue();
            } else {
                issueRelatedExecutor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importIssueSecondDegreeEntities(ProjectImportData projectImportData, ProjectImportResults projectImportResults, I18nHelper i18n, ProjectImportMapper projectImportMapper, TaskProgressInterval changeItemSubInterval, BackupProject backupProject, BackupSystemInformation backupSystemInformation) throws IOException, SAXException {
        BoundedExecutor executor = this.createExecutor("ProjectImport: IssueSecondDegreeEntities");
        log.info("Creating the change item data.");
        ChainedOfBizSaxHandler chainedEntityHandler = this.getOfBizChainedHandler(new EntityCountTaskProgressProcessor(changeItemSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.second.degree.entities"), projectImportData.getChangeItemEntityCount(), i18n));
        chainedEntityHandler.registerHandler(this.getCommentPropertiesPersisterHandler(projectImportMapper, projectImportResults, executor));
        chainedEntityHandler.registerHandler(this.getChangeHistoryPropertiesPersisterHandler(projectImportMapper, projectImportResults, executor));
        chainedEntityHandler.registerHandlers(this.getOfBizPluginImportHandlers(backupProject, backupSystemInformation, projectImportMapper, projectImportResults));
        try {
            for (String entityName : this.getSecondDegreeEntityNames()) {
                String pathToEntityXml = projectImportData.getPathToEntityXml(entityName);
                if (pathToEntityXml == null) continue;
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, chainedEntityHandler);
            }
            log.info("Finished creating the change item data.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                executor.shutdownAndIgnoreQueue();
            } else {
                executor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void importChangeItemEntities(ProjectImportData projectImportData, ProjectImportResults projectImportResults, I18nHelper i18n, ProjectImportMapper projectImportMapper, TaskProgressInterval changeItemSubInterval, BackupProject backupProject) throws IOException, SAXException {
        BoundedExecutor executor = this.createExecutor("ProjectImport: ChangeItemEntities");
        log.info("Creating change item entities.");
        ChainedOfBizSaxHandler chainedEntityHandler = this.getOfBizChainedHandler(new EntityCountTaskProgressProcessor(changeItemSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.change.items"), projectImportData.getChangeItemEntityCount(), i18n));
        chainedEntityHandler.registerHandler(this.getChangeItemPersisterHandler(projectImportMapper, backupProject, projectImportResults, executor));
        try {
            String pathToEntityXml = projectImportData.getPathToEntityXml("ChangeItem");
            if (pathToEntityXml != null) {
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, chainedEntityHandler);
            }
            log.info("Finished creating the change item data.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                executor.shutdownAndIgnoreQueue();
            } else {
                executor.shutdownAndWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long importIssues(ProjectImportData projectImportData, ProjectImportResults projectImportResults, I18nHelper i18n, ApplicationUser importAuthor, ProjectImportMapper projectImportMapper, TaskProgressInterval issuesSubInterval, BackupProject backupProject, BackupSystemInformation backupSystemInformation) throws IOException, SAXException {
        BoundedExecutor issueExecutor = this.createExecutor("ProjectImport: CreateIssues");
        log.info("Creating the issues.");
        EntityCountTaskProgressProcessor issuesTaskProgressProcessor = new EntityCountTaskProgressProcessor(issuesSubInterval, i18n.getText("admin.message.project.import.manager.do.import.importing.issues"), projectImportData.getIssueEntityCount(), i18n);
        ChainedOfBizSaxHandler issuePersistenceHandler = this.getOfBizChainedHandler(issuesTaskProgressProcessor);
        IssuePersisterHandler issuePersisterHandler = this.getIssuePersisterHandler(importAuthor, projectImportMapper, projectImportResults, issueExecutor);
        issuePersistenceHandler.registerHandler(issuePersisterHandler);
        issuePersistenceHandler.registerHandlers(this.getOfBizPluginImportHandlers(backupProject, backupSystemInformation, projectImportMapper, projectImportResults));
        try {
            String pathToEntityXml = projectImportData.getPathToEntityXml("Issue");
            if (pathToEntityXml != null) {
                this.backupXmlParser.parseOfBizBackupXml(pathToEntityXml, issuePersistenceHandler);
            }
            log.info("Finished creating the issues.");
        }
        finally {
            if (projectImportResults.abortImport()) {
                issueExecutor.shutdownAndIgnoreQueue();
            } else {
                issueExecutor.shutdownAndWait();
            }
        }
        return issuePersisterHandler.getLargestIssueKeyNumber();
    }

    private void createGroupRoleActor(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, ProjectRoleActorParser projectRoleActorParser, ExternalProjectRoleActor projectRoleActor) {
        String newProjectId = projectImportMapper.getProjectMapper().getMappedId(projectRoleActor.getProjectId());
        String newProjectRoleId = projectImportMapper.getProjectRoleMapper().getMappedId(projectRoleActor.getRoleId());
        String groupName = projectRoleActor.getRoleActor();
        String projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
        if (this.groupManager.groupExists(groupName)) {
            ExternalProjectRoleActor newProjectRoleActor = new ExternalProjectRoleActor(null, newProjectId, newProjectRoleId, projectRoleActor.getRoleType(), groupName);
            Long entityId = this.projectImportPersister.createEntity(projectRoleActorParser.getEntityRepresentation(newProjectRoleActor));
            if (entityId == null) {
                projectImportResults.addError("There was an error adding group '" + groupName + "' to the Project Role '" + projectRoleName + "'.");
            } else {
                projectImportResults.incrementRoleGroupCreatedCount(projectRoleName);
            }
        } else {
            log.warn("Group '" + groupName + "' does not exist, so we are not adding them to the Project Role '" + projectRoleName + "' in the Project Import.");
        }
    }

    private void createUserRoleActor(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, ProjectRoleActorParser projectRoleActorParser, ExternalProjectRoleActor projectRoleActor) {
        String newProjectId = projectImportMapper.getProjectMapper().getMappedId(projectRoleActor.getProjectId());
        String newProjectRoleId = projectImportMapper.getProjectRoleMapper().getMappedId(projectRoleActor.getRoleId());
        String userKey = projectRoleActor.getRoleActor();
        String projectRoleName = projectImportMapper.getProjectRoleMapper().getDisplayName(projectRoleActor.getRoleId());
        if (projectImportMapper.getUserMapper().userExists(userKey)) {
            String mappedUserKey = projectImportMapper.getUserMapper().getMappedUserKey(userKey);
            ExternalProjectRoleActor newProjectRoleActor = new ExternalProjectRoleActor(null, newProjectId, newProjectRoleId, projectRoleActor.getRoleType(), mappedUserKey);
            Long entityId = this.projectImportPersister.createEntity(projectRoleActorParser.getEntityRepresentation(newProjectRoleActor));
            if (entityId == null) {
                projectImportResults.addError("There was an error adding user '" + projectImportMapper.getUserMapper().getDisplayName(userKey) + "' to the Project Role '" + projectRoleName + "'.");
            } else {
                projectImportResults.incrementRoleUserCreatedCount(projectRoleName);
            }
        } else {
            log.warn("User '" + projectImportMapper.getUserMapper().getDisplayName(userKey) + "' does not exist, so we are not adding them to the Project Role '" + projectRoleName + "' in the Project Import.");
        }
    }

    private void updateTaskProgress(EntityCountTaskProgressProcessor taskProgressProcessor, String message, int currentCount) {
        if (taskProgressProcessor != null) {
            taskProgressProcessor.processTaskProgress(message, currentCount);
        }
    }

    @VisibleForTesting
    void populateVersionMapper(SimpleProjectImportIdMapper versionMapper, Map<String, Version> newVersions) {
        for (Map.Entry<String, Version> entry : newVersions.entrySet()) {
            String oldId = entry.getKey();
            Version version = entry.getValue();
            versionMapper.mapValue(oldId, version.getId().toString());
        }
    }

    @VisibleForTesting
    void populateComponentMapper(SimpleProjectImportIdMapper componentMapper, Map<String, ProjectComponent> newComponents) {
        for (Map.Entry<String, ProjectComponent> entry : newComponents.entrySet()) {
            String oldId = entry.getKey();
            ProjectComponent component = entry.getValue();
            componentMapper.mapValue(oldId, component.getId().toString());
        }
    }

    private ImportOfBizEntityHandler getCustomFieldValuePersisterHandler(ProjectImportMapper projectImportMapper, String newProjectId, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        Map<String, CustomFieldValueParser> parsers = this.getCustomFieldParsers();
        return new CustomFieldValuePersisterHandler(this.projectImportPersister, projectImportMapper, this.customFieldManager, new Long(newProjectId), projectImportResults, backupSystemInformation, executor, parsers);
    }

    private ImportOfBizEntityHandler getCommentPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new CommentPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getWorklogPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new WorklogPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getLabelPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new LabelsPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getVersionPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new VersionPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getComponentPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new ComponentPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getUserAssociationPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new UserAssociationPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getIssuePropertiesPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, Executor executor) {
        return new EntityPropertiesPersisterHandler(executor, projectImportResults, this.projectImportPersister, EntityPropertyType.ISSUE_PROPERTY, projectImportMapper.getIssueMapper());
    }

    private ImportOfBizEntityHandler getCommentPropertiesPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, Executor executor) {
        return new EntityPropertiesPersisterHandler(executor, projectImportResults, this.projectImportPersister, EntityPropertyType.COMMENT_PROPERTY, projectImportMapper.getCommentMapper());
    }

    private ImportOfBizEntityHandler getChangeHistoryPropertiesPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BoundedExecutor executor) {
        return new EntityPropertiesPersisterHandler(executor, projectImportResults, this.projectImportPersister, EntityPropertyType.CHANGE_HISTORY_PROPERTY, projectImportMapper.getChangeGroupMapper());
    }

    private ImportOfBizEntityHandler getChangeGroupPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor) {
        return new ChangeGroupPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, executor);
    }

    private ImportOfBizEntityHandler getChangeItemPersisterHandler(ProjectImportMapper projectImportMapper, BackupProject backupProject, ProjectImportResults projectImportResults, Executor executor) {
        return new ChangeItemPersisterHandler(this.projectImportPersister, backupProject, projectImportMapper, projectImportResults, this.customFieldManager, executor);
    }

    private IssuePersisterHandler getIssuePersisterHandler(ApplicationUser importAuthor, ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, Executor executor) {
        return new IssuePersisterHandler(this.projectImportPersister, projectImportMapper, importAuthor, projectImportResults, executor);
    }

    private ImportOfBizEntityHandler getIssueLinkPersisterHandler(ProjectImportMapper projectImportMapper, ProjectImportResults projectImportResults, BackupSystemInformation backupSystemInformation, Executor executor, ApplicationUser importAuthor) {
        return new IssueLinkPersisterHandler(this.projectImportPersister, projectImportMapper, projectImportResults, backupSystemInformation, new IssueLinkTransformerImpl(this.issueManager, backupSystemInformation), new IssueLinkParserImpl(), executor, importAuthor);
    }

    AoEntityHandler getAoPartitionHandler(AoImportTemporaryFiles aoImportTemporaryFiles, String encoding) {
        return new AoPartitionHandler(aoImportTemporaryFiles, encoding);
    }

    @VisibleForTesting
    void populateCustomFieldMapperOldValues(BackupProject backupProject, CustomFieldMapper customFieldMapper) {
        for (ExternalCustomFieldConfiguration customFieldConfiguration : backupProject.getCustomFields()) {
            ExternalCustomField externalCustomField = customFieldConfiguration.getCustomField();
            customFieldMapper.registerOldValue(externalCustomField.getId(), externalCustomField.getName());
        }
    }

    @VisibleForTesting
    void populateVersionMapperOldValues(BackupProject backupProject, SimpleProjectImportIdMapper versionMapper) {
        for (ExternalVersion externalVersion : backupProject.getProjectVersions()) {
            versionMapper.registerOldValue(externalVersion.getId(), externalVersion.getName());
        }
    }

    @VisibleForTesting
    void populateComponentMapperOldValues(BackupProject backupProject, SimpleProjectImportIdMapper componentMapper) {
        for (ExternalComponent externalComponent : backupProject.getProjectComponents()) {
            componentMapper.registerOldValue(externalComponent.getId(), externalComponent.getName());
        }
    }

    @VisibleForTesting
    CustomFieldValueValidatorHandler getCustomFieldValueValidatorHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        Map<String, CustomFieldValueParser> parsers = this.getCustomFieldParsers();
        return new CustomFieldValueValidatorHandler(backupProject, projectImportMapper, this.customFieldManager, parsers);
    }

    @VisibleForTesting
    CustomFieldMapperHandler getCustomFieldMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        Map<String, CustomFieldValueParser> parsers = this.getCustomFieldParsers();
        return new CustomFieldMapperHandler(backupProject, projectImportMapper.getCustomFieldMapper(), parsers);
    }

    @VisibleForTesting
    SimpleEntityMapperHandler getStatusMapperHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("Status", (MapperEntityRegister)projectImportMapper.getStatusMapper());
    }

    @VisibleForTesting
    SimpleEntityMapperHandler getResolutionMapperHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("Resolution", (MapperEntityRegister)projectImportMapper.getResolutionMapper());
    }

    @VisibleForTesting
    SimpleEntityMapperHandler getPriorityMapperHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("Priority", (MapperEntityRegister)projectImportMapper.getPriorityMapper());
    }

    @VisibleForTesting
    ProjectMapperHandler getProjectMapperHandler(ProjectImportMapper projectImportMapper) {
        return new ProjectMapperHandler(projectImportMapper.getProjectMapper());
    }

    @VisibleForTesting
    IssueTypeMapperHandler getIssueTypeMapperHandler(ProjectImportMapper projectImportMapper) {
        return new IssueTypeMapperHandler(projectImportMapper.getIssueTypeMapper());
    }

    @VisibleForTesting
    ProjectIssueSecurityLevelMapperHandler getProjectIssueSecurityLevelMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new ProjectIssueSecurityLevelMapperHandler(backupProject, projectImportMapper.getIssueSecurityLevelMapper());
    }

    @VisibleForTesting
    IssueMapperHandler getIssueMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new IssueMapperHandler(backupProject, projectImportMapper);
    }

    @VisibleForTesting
    UserMapperHandler getUserMapperHandler(ProjectImportOptions projectImportOptions, BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new UserMapperHandler(projectImportOptions, backupProject, projectImportMapper.getUserMapper(), this.attachmentStore);
    }

    @VisibleForTesting
    GroupMapperHandler getGroupMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new GroupMapperHandler(backupProject, (SimpleProjectImportIdMapper)projectImportMapper.getGroupMapper());
    }

    @VisibleForTesting
    ChainedOfBizSaxHandler getOfBizChainedHandler(TaskProgressProcessor taskProgressProcessor) {
        return new ChainedOfBizSaxHandler(new ThrottlingTaskProgressProcessor(taskProgressProcessor, this.clock));
    }

    ChainedAoSaxHandler getAoChainedHandler(TaskProgressProcessor taskProgressProcessor) {
        return new ChainedAoSaxHandler(new ThrottlingTaskProgressProcessor(taskProgressProcessor, this.clock));
    }

    @VisibleForTesting
    CustomFieldOptionsMapperHandler getCustomFieldOptionMapperHandler(ProjectImportMapper projectImportMapper) {
        return new CustomFieldOptionsMapperHandler(projectImportMapper.getCustomFieldOptionMapper());
    }

    @VisibleForTesting
    SimpleEntityMapperHandler getProjectRoleRegistrationHandler(ProjectImportMapper projectImportMapper) {
        return new SimpleEntityMapperHandler("ProjectRole", (MapperEntityRegister)projectImportMapper.getProjectRoleMapper());
    }

    @VisibleForTesting
    RequiredProjectRolesMapperHandler getRequiredProjectRolesMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new RequiredProjectRolesMapperHandler(backupProject, projectImportMapper.getProjectRoleMapper());
    }

    @VisibleForTesting
    RegisterUserMapperHandler getRegisterUserMapperHandler(ProjectImportMapper projectImportMapper) {
        return new RegisterUserMapperHandler(projectImportMapper.getUserMapper());
    }

    @VisibleForTesting
    ProjectRoleActorMapperHandler getProjectRoleActorMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new ProjectRoleActorMapperHandler(backupProject, projectImportMapper.getProjectRoleActorMapper());
    }

    @VisibleForTesting
    List<String> getIssueRelatedEntityNamesForPartitioning() {
        return ImmutableList.builder().addAll(this.getIssueRelatedEntityNames()).add((Object)"ChangeItem").build();
    }

    @VisibleForTesting
    List<String> getIssueRelatedEntityNames() {
        return ImmutableList.of((Object)"Worklog", (Object)"Label", (Object)"NodeAssociation", (Object)"IssueLink", (Object)"Action", (Object)"ChangeGroup", (Object)"UserAssociation", (Object)"EntityProperty");
    }

    @VisibleForTesting
    List<String> getFileAttachmentEntityNames() {
        return ImmutableList.of((Object)"FileAttachment");
    }

    @VisibleForTesting
    List<String> getCustomFieldEntityNames() {
        return ImmutableList.copyOf(this.getCustomFieldParsers().keySet());
    }

    List<String> getNonIssueEntityNames(BackupSystemInformation backupSystemInformation) {
        Set allEntities = backupSystemInformation.getEntityTypes();
        ArrayList entities = new ArrayList(allEntities);
        entities.remove("Issue");
        entities.removeAll(this.getCustomFieldEntityNames());
        entities.removeAll(this.getIssueRelatedEntityNamesForPartitioning());
        entities.removeAll(this.getFileAttachmentEntityNames());
        entities.removeAll(IGNORED_ENTITIES);
        return ImmutableList.copyOf(entities);
    }

    private List<String> getSecondDegreeEntityNames() {
        return ImmutableList.of((Object)"Action", (Object)"ChangeGroup");
    }

    private Map<String, CustomFieldValueParser> getCustomFieldParsers() {
        MapBuilder entities = MapBuilder.newBuilder();
        entities.add((Object)"CustomFieldValue", (Object)new CustomFieldValueParserImpl());
        List customFieldTypes = this.customFieldManager.getCustomFieldTypes();
        for (CustomFieldType customFieldType : customFieldTypes) {
            if (!(customFieldType instanceof ProjectImportableCustomFieldParser)) continue;
            String entity = ((ProjectImportableCustomFieldParser)customFieldType).getEntityName();
            entities.add((Object)entity, (Object)((ProjectImportableCustomFieldParser)customFieldType));
        }
        return entities.toMap();
    }

    @VisibleForTesting
    IssuePartitionHandler getIssuePartitioner(ProjectImportTemporaryFiles projectImportTemporaryFiles, BackupProject backupProject) throws IOException {
        ModelEntity issueModelEntity = this.getModelEntity("Issue");
        return new IssuePartitionHandler(backupProject, projectImportTemporaryFiles, issueModelEntity, this.genericDelegator);
    }

    @VisibleForTesting
    List<ModelEntity> getModelEntities(List<String> names) {
        ArrayList<ModelEntity> models = new ArrayList<ModelEntity>(names.size());
        models.addAll(names.stream().map(this::getModelEntity).collect(Collectors.toList()));
        return models;
    }

    @VisibleForTesting
    IssueRelatedEntitiesPartitionHandler getFileAttachmentHandler(ProjectImportTemporaryFiles projectImportTemporaryFiles, BackupProject backupProject) throws IOException {
        return new IssueRelatedEntitiesPartitionHandler(backupProject, projectImportTemporaryFiles, this.getModelEntities(this.getFileAttachmentEntityNames()), this.genericDelegator);
    }

    @VisibleForTesting
    IssueRelatedEntitiesPartitionHandler getCustomFieldValuesHandler(ProjectImportTemporaryFiles projectImportTemporaryFiles, BackupProject backupProject) throws IOException {
        return new IssueRelatedEntitiesPartitionHandler(backupProject, projectImportTemporaryFiles, this.getModelEntities(this.getCustomFieldEntityNames()), this.genericDelegator);
    }

    @VisibleForTesting
    IssueRelatedEntitiesPartitionHandler getIssueRelatedEntitesHandler(ProjectImportTemporaryFiles projectImportTemporaryFiles, BackupProject backupProject) throws IOException {
        return new IssueRelatedEntitiesPartitionHandler(backupProject, projectImportTemporaryFiles, this.getModelEntities(this.getIssueRelatedEntityNamesForPartitioning()), this.genericDelegator);
    }

    @VisibleForTesting
    GenericEntitiesPartitionHandler getGenericEntitesHandler(ProjectImportTemporaryFiles projectImportTemporaryFiles, BackupProject backupProject, BackupSystemInformation backupSystemInformation) throws IOException {
        return new GenericEntitiesPartitionHandler(backupProject, projectImportTemporaryFiles, this.getModelEntities(this.getNonIssueEntityNames(backupSystemInformation)), this.genericDelegator);
    }

    @VisibleForTesting
    IssueVersionMapperHandler getIssueVersionMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new IssueVersionMapperHandler(backupProject, projectImportMapper.getVersionMapper());
    }

    @VisibleForTesting
    IssueComponentMapperHandler getIssueComponentMapperHandler(BackupProject backupProject, ProjectImportMapper projectImportMapper) {
        return new IssueComponentMapperHandler(backupProject, projectImportMapper.getComponentMapper());
    }

    @VisibleForTesting
    AttachmentFileValidatorHandler getAttachmentFileValidatorHandler(BackupProject backupProject, ProjectImportOptions projectImportOptions, BackupSystemInformation backupSystemInformation, I18nHelper i18nHelper) {
        return new AttachmentFileValidatorHandler(backupProject, projectImportOptions, backupSystemInformation, i18nHelper, this.attachmentStore);
    }

    @VisibleForTesting
    IssueLinkMapperHandler getIssueLinkMapperHandler(BackupProject backupProject, BackupSystemInformation backupSystemInformation, ProjectImportMapper projectImportMapper) {
        return new IssueLinkMapperHandler(backupProject, backupSystemInformation, this.issueManager, projectImportMapper.getIssueLinkTypeMapper());
    }

    private void subvertSecurityIndexingNotifications() {
        ImportUtils.setSubvertSecurityScheme((boolean)true);
        ImportUtils.setIndexIssues((boolean)false);
        ImportUtils.setEnableNotifications((boolean)false);
    }

    private void restoreSecurityIndexingNotifications() {
        ImportUtils.setSubvertSecurityScheme((boolean)false);
        ImportUtils.setIndexIssues((boolean)true);
        ImportUtils.setEnableNotifications((boolean)true);
    }

    private TaskProgressInterval getSubInterval(TaskProgressInterval taskProgressInterval, int subIntervalStart, int subIntervalEnd) {
        if (taskProgressInterval == null) {
            return null;
        }
        return taskProgressInterval.getSubInterval(subIntervalStart, subIntervalEnd);
    }

    @VisibleForTesting
    int getTotalEntitiesCount() {
        int count = 0;
        try {
            ModelReader reader = this.genericDelegator.getModelReader();
            Iterator iterator = reader.getEntityNamesIterator();
            while (iterator.hasNext()) {
                String entityName = (String)iterator.next();
                ModelEntity modelEntity = this.genericDelegator.getModelReader().getModelEntity(entityName);
                if (modelEntity instanceof ModelViewEntity) continue;
                ++count;
            }
            return count;
        }
        catch (GenericEntityException e) {
            return 100;
        }
    }

    @VisibleForTesting
    ModelEntity getModelEntity(String entityName) {
        try {
            return this.genericDelegator.getModelReader().getModelEntity(entityName);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    @VisibleForTesting
    String getApplicationEncoding() {
        return this.applicationProperties.getEncoding();
    }

    @VisibleForTesting
    ProjectRoleActorParser getProjectRoleActorParser() {
        return new ProjectRoleActorParserImpl();
    }

    @VisibleForTesting
    BoundedExecutor createExecutor(String threadName) {
        return new BoundedExecutor(Executors.newFixedThreadPool(10, ThreadFactories.namedThreadFactory(threadName)), 20);
    }
}

