/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.txnaware;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.IssueChangedEvent;
import com.atlassian.jira.event.issue.IssueChangedEventImpl;
import com.atlassian.jira.event.issue.txnaware.TxnAwareEventFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.changehistory.ChangeHistory;
import com.atlassian.jira.issue.changehistory.ChangeHistoryManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.transaction.RequestLocalTransactionRunnableQueueFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.ozymandias.SafePluginPointAccess;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class TxnAwareEventFactoryImpl
implements TxnAwareEventFactory {
    private final EventPublisher eventPublisher;
    private final RequestLocalTransactionRunnableQueueFactory runnableQueueFactory;
    private final ComponentLocator componentLocator;

    public TxnAwareEventFactoryImpl(EventPublisher eventPublisher, RequestLocalTransactionRunnableQueueFactory runnableQueueFactory, ComponentLocator componentLocator) {
        this.eventPublisher = eventPublisher;
        this.runnableQueueFactory = runnableQueueFactory;
        this.componentLocator = componentLocator;
    }

    @Override
    public void issueChangedEventOnCommit(long issueId, ApplicationUser author, Comment comment, long changeGroupId) {
        this.issueChangedEventOnCommit(issueId, Optional.ofNullable(author), Optional.ofNullable(comment), changeGroupId);
    }

    private void issueChangedEventOnCommit(long issueId, Optional<ApplicationUser> authorOption, Optional<Comment> commentOption, long changeGroupIdOption) {
        this.runThisOnCommit(() -> {
            Optional<ChangeHistory> changeHistory = this.getChangeHistory(changeGroupIdOption);
            changeHistory.ifPresent(history -> {
                List changeItems = history.getChangeItemBeans();
                if (changeItems != null && !changeItems.isEmpty()) {
                    IssueChangedEvent issueChangeEvent = this.makeChangedEvent(issueId, authorOption, commentOption, changeItems, history.getTimePerformed());
                    this.publishEvent(issueChangeEvent);
                }
            });
        });
    }

    private Optional<ChangeHistory> getChangeHistory(long changeGroupId) {
        ChangeHistory changeHistory = ((ChangeHistoryManager)this.componentLocator.getComponent(ChangeHistoryManager.class)).getChangeHistoryById(Long.valueOf(changeGroupId));
        return Optional.ofNullable(changeHistory);
    }

    private IssueChangedEvent makeChangedEvent(long issueId, Optional<ApplicationUser> author, Optional<Comment> comment, List<ChangeItemBean> changeItems, Timestamp timePerformed) {
        Issue issue = this.getIssueObject(issueId);
        Date eventTime = new Date(timePerformed.getTime());
        return new IssueChangedEventImpl(issue, author, changeItems, comment, eventTime);
    }

    private Issue getIssueObject(long issueId) {
        IssueManager issueManager = (IssueManager)this.componentLocator.getComponent(IssueManager.class);
        return issueManager.getIssueObject(Long.valueOf(issueId));
    }

    private void runThisOnCommit(Runnable onCommit) {
        if (CoreTransactionUtil.inTransaction()) {
            this.runnableQueueFactory.getRunnablesQueue().offer(onCommit);
        } else {
            SafePluginPointAccess.to().runnable(onCommit);
        }
    }

    private void publishEvent(IssueChangedEvent event) {
        this.eventPublisher.publish((Object)event);
    }
}

