/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue;

import com.atlassian.jira.event.comment.CommentCreatedEvent;
import com.atlassian.jira.event.comment.CommentUpdatedEvent;
import com.atlassian.jira.event.issue.DefaultIssueEventBundle;
import com.atlassian.jira.event.issue.DelegatingJiraIssueEvent;
import com.atlassian.jira.event.issue.EventTypesForIssueChange;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.issue.IssueEventBundle;
import com.atlassian.jira.event.issue.IssueEventBundleFactory;
import com.atlassian.jira.event.issue.IssueEventParamsTransformer;
import com.atlassian.jira.event.issue.JiraIssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.managers.DefaultIssueDeleteHelper;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.user.ApplicationUser;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericValue;

public class IssueEventBundleFactoryImpl
implements IssueEventBundleFactory {
    private final IssueEventParamsTransformer paramsTransformer;
    private final EventTypesForIssueChange eventsForIssueChange;

    public IssueEventBundleFactoryImpl(IssueEventParamsTransformer paramsTransformer, EventTypesForIssueChange eventsForIssueChange) {
        this.paramsTransformer = paramsTransformer;
        this.eventsForIssueChange = eventsForIssueChange;
    }

    @Override
    public IssueEventBundle createIssueUpdateEventBundle(Issue issue, GenericValue changeGroup, IssueUpdateBean iub, ApplicationUser user) {
        if (EventType.ISSUE_COMMENTED_ID.equals(iub.getEventTypeId())) {
            return this.createCommentAddedBundle(issue, user, iub.getComment(), iub.getParams());
        }
        List<Long> eventIds = this.eventsForIssueChange.getEventTypeIdsForIssueUpdate(iub);
        Collection<JiraIssueEvent> events = this.toJiraIssueEvents(eventIds.stream().map(eventId -> new IssueEvent(issue, user, iub.getComment(), iub.getWorklog(), changeGroup, this.transformParams(iub.getParams()), eventId, iub.isSendMail(), iub.isSubtasksUpdated())));
        if (iub.getComment() != null) {
            return DefaultIssueEventBundle.create((Collection<? extends JiraIssueEvent>)ImmutableList.builder().addAll(events).add((Object)new CommentCreatedEvent(iub.getComment())).build());
        }
        return DefaultIssueEventBundle.create(events);
    }

    @Override
    public IssueEventBundle createWorklogEventBundle(Issue issue, GenericValue changeGroup, IssueUpdateBean iub, ApplicationUser user) {
        IssueEvent issueEvent = new IssueEvent(issue, user, iub.getComment(), iub.getWorklog(), changeGroup, this.transformParams(iub.getParams()), iub.getEventTypeId(), iub.isSendMail(), iub.isSubtasksUpdated());
        return this.wrapInBundle(issueEvent);
    }

    @Override
    public IssueEventBundle createIssueDeleteEventBundle(Issue issue, DefaultIssueDeleteHelper.DeletedIssueEventData deletedIssueEventData, ApplicationUser user) {
        IssueEvent issueEvent = new IssueEvent(issue, this.transformParams(deletedIssueEventData.paramsMap()), user, EventType.ISSUE_DELETED_ID, deletedIssueEventData.isSendMail());
        return this.wrapInBundle(issueEvent);
    }

    @Override
    public IssueEventBundle createCommentAddedBundle(Issue issue, ApplicationUser user, Comment comment, Map<String, Object> params) {
        IssueEvent issueEvent = new IssueEvent(issue, user, comment, null, null, this.transformParams(params), EventType.ISSUE_COMMENTED_ID);
        CommentCreatedEvent commentCreatedEvent = new CommentCreatedEvent(comment);
        return DefaultIssueEventBundle.create((Collection<? extends JiraIssueEvent>)ImmutableList.of((Object)new IssueEventWrapper(issueEvent), (Object)commentCreatedEvent));
    }

    @Override
    public IssueEventBundle createCommentEditedBundle(Issue issue, ApplicationUser user, Comment comment, Map<String, Object> params) {
        IssueEvent issueEvent = new IssueEvent(issue, user, comment, null, null, this.transformParams(params), EventType.ISSUE_COMMENT_EDITED_ID);
        CommentUpdatedEvent commentUpdatedEvent = new CommentUpdatedEvent(comment);
        return DefaultIssueEventBundle.create((Collection<? extends JiraIssueEvent>)ImmutableList.of((Object)new IssueEventWrapper(issueEvent), (Object)commentUpdatedEvent));
    }

    @Override
    public IssueEventBundle createWorkflowEventBundle(Long eventType, Issue issue, ApplicationUser user, Comment comment, GenericValue changeGroup, Map<String, Object> params, boolean sendMail, String originalAssigneeId) {
        IssueEvent workflowEvent = new IssueEvent(issue, user, comment, null, changeGroup, this.transformParams(params), eventType, sendMail);
        if (issue.getAssigneeId() == null || issue.getAssigneeId().equals(originalAssigneeId)) {
            return this.wrapInBundle(workflowEvent);
        }
        IssueEvent assigneeChangedEvent = new IssueEvent(issue, user, comment, null, changeGroup, this.transformParams(params), EventType.ISSUE_ASSIGNED_ID, sendMail);
        return this.wrapInBundle(workflowEvent, assigneeChangedEvent);
    }

    @Override
    public IssueEventBundle wrapInBundle(IssueEvent issueEvent) {
        return this.wrapInBundle(new IssueEvent[]{issueEvent});
    }

    private IssueEventBundle wrapInBundle(IssueEvent ... issueEvents) {
        return DefaultIssueEventBundle.create(this.toJiraIssueEvents(issueEvents));
    }

    private Collection<JiraIssueEvent> toJiraIssueEvents(IssueEvent ... issueEvents) {
        return this.toJiraIssueEvents(Stream.of(issueEvents));
    }

    private Collection<JiraIssueEvent> toJiraIssueEvents(Stream<IssueEvent> issueEvents) {
        return issueEvents.map(x$0 -> new IssueEventWrapper((IssueEvent)x$0)).collect(Collectors.toList());
    }

    private Map<String, Object> transformParams(Map<String, Object> params) {
        return this.paramsTransformer.transformParams(params);
    }

    private static class IssueEventWrapper
    implements DelegatingJiraIssueEvent {
        private final IssueEvent issueEvent;

        private IssueEventWrapper(IssueEvent issueEvent) {
            this.issueEvent = issueEvent;
        }

        @Nonnull
        public IssueEvent asIssueEvent() {
            return this.issueEvent;
        }
    }
}

