/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.ConnectionProvider;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.DbConnectionImpl;
import com.atlassian.jira.database.JiraOracleTemplates;
import com.atlassian.jira.database.NestedConnection;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.SqlCallback;
import com.atlassian.jira.exception.DataAccessException;
import com.querydsl.sql.H2Templates;
import com.querydsl.sql.HSQLDBTemplates;
import com.querydsl.sql.MySQLTemplates;
import com.querydsl.sql.PostgreSQLTemplates;
import com.querydsl.sql.SQLServerTemplates;
import com.querydsl.sql.SQLTemplates;
import java.sql.Connection;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericTransactionException;

public class DefaultQueryDslAccessor
implements QueryDslAccessor {
    private final DatabaseAccessor databaseAccessor;
    private final DelegatorInterface delegatorInterface;
    private final SQLTemplates dialect;

    public DefaultQueryDslAccessor(DatabaseAccessor databaseAccessor, DelegatorInterface delegatorInterface, DatabaseConfigurationManager databaseConfigurationManager) {
        this.databaseAccessor = databaseAccessor;
        this.delegatorInterface = delegatorInterface;
        DatabaseConfig databaseConfig = databaseConfigurationManager.getDatabaseConfiguration();
        SQLTemplates.Builder dialectBuilder = DefaultQueryDslAccessor.findDialectBuilder(databaseConfig);
        if (!StringUtils.isEmpty((String)databaseConfig.getSchemaName())) {
            dialectBuilder.printSchema();
        }
        this.dialect = dialectBuilder.build();
    }

    static SQLTemplates.Builder findDialectBuilder(DatabaseConfig databaseConfig) {
        if (databaseConfig.isMySql()) {
            return MySQLTemplates.builder();
        }
        if (databaseConfig.isPostgres()) {
            return PostgreSQLTemplates.builder();
        }
        if (databaseConfig.isOracle()) {
            return JiraOracleTemplates.builder();
        }
        if (databaseConfig.isSqlServer()) {
            return SQLServerTemplates.builder();
        }
        if (databaseConfig.isH2()) {
            return H2Templates.builder();
        }
        if (databaseConfig.isHSql()) {
            return HSQLDBTemplates.builder();
        }
        throw new IllegalStateException("Unrecognised database dialect '" + databaseConfig.getDatabaseType() + "'.");
    }

    @Override
    public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
        return (T)this.databaseAccessor.runInTransaction(con -> callback.runQuery(new DbConnectionImpl((Connection)con, this.dialect, this.delegatorInterface)));
    }

    @Override
    public void execute(@Nonnull SqlCallback callback) {
        this.databaseAccessor.runInTransaction(con -> {
            callback.run(new DbConnectionImpl((Connection)con, this.dialect, this.delegatorInterface));
            return null;
        });
    }

    @Override
    public ConnectionProvider withNewConnection() {
        return new ConnectionProvider(){

            @Override
            public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
                return (T)DefaultQueryDslAccessor.this.databaseAccessor.executeQuery(con -> callback.runQuery(new DbConnectionImpl(con, DefaultQueryDslAccessor.this.dialect, DefaultQueryDslAccessor.this.delegatorInterface)));
            }

            @Override
            public void execute(@Nonnull SqlCallback callback) {
                DefaultQueryDslAccessor.this.databaseAccessor.executeQuery(con -> {
                    callback.run(new DbConnectionImpl(con, DefaultQueryDslAccessor.this.dialect, DefaultQueryDslAccessor.this.delegatorInterface));
                    return null;
                });
            }
        };
    }

    @Override
    public ConnectionProvider withLegacyOfBizTransaction() {
        return new ConnectionProvider(){

            @Override
            public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
                try {
                    return (T)DefaultQueryDslAccessor.this.executeWithLegacyOfBizTransaction(callback);
                }
                catch (GenericTransactionException ex) {
                    throw new DataAccessException((Throwable)ex);
                }
            }

            @Override
            public void execute(@Nonnull SqlCallback callback) {
                try {
                    DefaultQueryDslAccessor.this.executeWithLegacyOfBizTransaction(dbConnection -> {
                        callback.run(dbConnection);
                        return null;
                    });
                }
                catch (GenericTransactionException ex) {
                    throw new DataAccessException((Throwable)ex);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithLegacyOfBizTransaction(QueryCallback<T> callback) throws GenericTransactionException {
        boolean began = CoreTransactionUtil.begin();
        boolean success = false;
        try {
            NestedConnection jdbcConnection = new NestedConnection(CoreTransactionUtil.getConnection());
            DbConnectionImpl dbConnection = new DbConnectionImpl(jdbcConnection, this.dialect, this.delegatorInterface);
            T val = callback.runQuery(dbConnection);
            CoreTransactionUtil.commit(began);
            success = true;
            T t = val;
            return t;
        }
        finally {
            if (!success) {
                CoreTransactionUtil.rollback(began);
            }
        }
    }

    @Override
    public DbConnection withDbConnection(Connection connection) {
        return new DbConnectionImpl(connection, this.dialect, this.delegatorInterface);
    }
}

