/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.jira.database.DatabaseSystemTimeReader;
import com.atlassian.jira.database.DatabaseSystemTimeReaderFactory;
import com.atlassian.jira.database.SqlStatementTimeReader;
import com.atlassian.jira.ofbiz.DefaultOfBizConnectionFactory;
import com.atlassian.jira.ofbiz.OfBizConnectionFactory;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.jdbc.dbtype.AbstractPostgresDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DB2DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.H2DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.HsqlDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.MsSqlDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.MySqlDatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.Oracle10GDatabaseType;

public class DefaultDatabaseSystemTimeReaderFactory
implements DatabaseSystemTimeReaderFactory {
    private final OfBizConnectionFactory connectionFactory = DefaultOfBizConnectionFactory.getInstance();

    @Override
    @Nonnull
    public DatabaseSystemTimeReader getReader() {
        DatabaseType dbType = this.connectionFactory.getDatasourceInfo().getDatabaseTypeFromJDBCConnection();
        if (dbType instanceof AbstractPostgresDatabaseType) {
            return new SqlStatementTimeReader("values (current_timestamp)");
        }
        if (dbType instanceof MySqlDatabaseType || dbType instanceof MsSqlDatabaseType) {
            return new SqlStatementTimeReader("select current_timestamp");
        }
        if (dbType instanceof Oracle10GDatabaseType || "oracle".equals(dbType.getFieldTypeName())) {
            return new SqlStatementTimeReader("select systimestamp from dual");
        }
        if (dbType instanceof HsqlDatabaseType) {
            return new SqlStatementTimeReader("CALL current_timestamp");
        }
        if (dbType instanceof DB2DatabaseType) {
            return new SqlStatementTimeReader("SELECT CURRENT TIMESTAMP FROM sysibm.sysdummy1");
        }
        if (dbType instanceof H2DatabaseType) {
            return new SqlStatementTimeReader("select current_timestamp()");
        }
        throw new RuntimeException("Database type '" + dbType.getName() + "' is not supported for retrieving database system times.");
    }
}

