/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.database.ConnectionProvider;
import com.atlassian.jira.database.DatabaseAccessorImpl;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.DefaultQueryDslAccessor;
import com.atlassian.jira.database.QueryCallback;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.database.SqlCallback;
import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericDelegator;

public class BootstrapQueryDslAccessor
implements QueryDslAccessor {
    protected final DatabaseConfigurationManager databaseConfigurationManager;
    private volatile QueryDslAccessor delegate;

    public BootstrapQueryDslAccessor(DatabaseConfigurationManager databaseConfigurationManager) {
        this.databaseConfigurationManager = databaseConfigurationManager;
    }

    @Override
    public <T> T executeQuery(@Nonnull QueryCallback<T> callback) {
        return this.getDelegate().executeQuery(callback);
    }

    @Override
    public void execute(@Nonnull SqlCallback callback) {
        this.getDelegate().execute(callback);
    }

    @Override
    public ConnectionProvider withNewConnection() {
        return this.getDelegate().withNewConnection();
    }

    @Override
    public ConnectionProvider withLegacyOfBizTransaction() {
        return this.getDelegate().withLegacyOfBizTransaction();
    }

    @Override
    public DbConnection withDbConnection(Connection connection) {
        return this.getDelegate().withDbConnection(connection);
    }

    private QueryDslAccessor getDelegate() {
        QueryDslAccessor existing = this.delegate;
        return existing != null ? existing : this.initDelegate();
    }

    private synchronized QueryDslAccessor initDelegate() {
        if (this.delegate == null) {
            if (!this.databaseConfigurationManager.isDatabaseSetup()) {
                throw new IllegalStateException("The database has not been configured, yet!");
            }
            this.delegate = this.createDelegate();
        }
        return this.delegate;
    }

    @VisibleForTesting
    QueryDslAccessor createDelegate() {
        GenericDelegator delegatorInterface = CoreFactory.getGenericDelegator();
        DatabaseAccessorImpl databaseAccessor = new DatabaseAccessorImpl(this.databaseConfigurationManager, (DelegatorInterface)delegatorInterface);
        return new DefaultQueryDslAccessor(databaseAccessor, (DelegatorInterface)delegatorInterface, this.databaseConfigurationManager);
    }
}

