/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.beehive.ClusterLockService;
import com.atlassian.cache.CacheManager;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.embedded.spi.DirectoryDao;
import com.atlassian.crowd.embedded.spi.GroupDao;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.DelegatingGroupWithAttributes;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.InternalDirectoryGroup;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.BatchResult;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.crowd.embedded.ofbiz.DirectoryEntityKey;
import com.atlassian.jira.crowd.embedded.ofbiz.EagerOfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupAttributeEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupEntityConditionFactory;
import com.atlassian.jira.crowd.embedded.ofbiz.GroupNotFoundException;
import com.atlassian.jira.crowd.embedded.ofbiz.InternalMembershipDao;
import com.atlassian.jira.crowd.embedded.ofbiz.LazyOfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizAttributesBuilder;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroup;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupCache;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.entity.Select;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionList;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;

public class OfBizGroupDao
implements GroupDao {
    private final OfBizDelegator ofBizDelegator;
    private final InternalMembershipDao membershipDao;
    private final OfBizGroupCache groupCaseInsensitiveCache;
    static final Function<GenericValue, String> TO_GROUPNAME_FUNCTION = gv -> gv.getString("groupName");
    static final Function<GenericValue, OfBizGroup> TO_GROUP_FUNCTION = OfBizGroup::from;
    final Function<GenericValue, GroupWithAttributes> toGroupWithAttributesFunction = gv -> this.withAttributes((OfBizGroup)TO_GROUP_FUNCTION.get(gv));

    public OfBizGroupDao(OfBizDelegator ofBizDelegator, DirectoryDao directoryDao, InternalMembershipDao membershipDao, CacheManager cacheManager, ClusterLockService clusterLockService, ApplicationProperties applicationProperties) {
        this.ofBizDelegator = ofBizDelegator;
        this.membershipDao = membershipDao;
        this.groupCaseInsensitiveCache = applicationProperties.getOption("jira.fullUserCache") ? new EagerOfBizGroupCache(clusterLockService, cacheManager, directoryDao, ofBizDelegator) : new LazyOfBizGroupCache(cacheManager, ofBizDelegator);
    }

    @Nonnull
    public InternalDirectoryGroup findByName(long directoryId, @Nonnull String name) throws GroupNotFoundException {
        return this.findOfBizGroup(directoryId, name);
    }

    @Nonnull
    OfBizGroup findOfBizGroup(long directoryId, String name) throws GroupNotFoundException {
        OfBizGroup group = this.findByNameOrNull(directoryId, name);
        if (group == null) {
            throw new GroupNotFoundException(name);
        }
        return group;
    }

    @Nullable
    OfBizGroup findByNameOrNull(long directoryId, String name) {
        return this.groupCaseInsensitiveCache.getCaseInsensitive(directoryId, name);
    }

    public GroupWithAttributes findByNameWithAttributes(long directoryId, String name) throws GroupNotFoundException {
        return this.withAttributes(this.findOfBizGroup(directoryId, name));
    }

    private GroupWithAttributes withAttributes(OfBizGroup group) {
        List<GenericValue> attributes = Select.columns(OfBizAttributesBuilder.SUPPORTED_FIELDS).from("GroupAttribute").whereEqual("directoryId", group.getDirectoryId()).andEqual("groupId", group.getId()).runWith(this.ofBizDelegator).asList();
        return new DelegatingGroupWithAttributes((Group)group, OfBizAttributesBuilder.toAttributes(attributes));
    }

    public Group add(Group group) {
        return this.add(group, false);
    }

    public Group addLocal(Group group) {
        return this.add(group, true);
    }

    private Group add(Group group, boolean local) {
        Timestamp currentTimestamp = OfBizGroupDao.getCurrentTimestamp();
        Map<String, Object> groupData = GroupEntity.getData(group, currentTimestamp, currentTimestamp, local);
        GenericValue gvGroup = this.ofBizDelegator.createValue("Group", groupData);
        OfBizGroup ofBizGroup = OfBizGroup.from(gvGroup);
        this.groupCaseInsensitiveCache.refresh(ofBizGroup);
        return ofBizGroup;
    }

    public BatchResult<Group> addAll(Set<? extends Group> groups) throws DirectoryNotFoundException {
        BatchResult results = new BatchResult(groups.size());
        for (Group group : groups) {
            try {
                Group addedGroup = this.add(group);
                results.addSuccess((Object)addedGroup);
            }
            catch (DataAccessException e) {
                results.addFailure((Object)group);
            }
        }
        return results;
    }

    public Group update(Group group) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        groupGenericValue.set("active", (Object)BooleanUtils.toInteger((boolean)group.isActive()));
        groupGenericValue.set("updatedDate", (Object)OfBizGroupDao.getCurrentTimestamp());
        groupGenericValue.set("description", (Object)group.getDescription());
        groupGenericValue.set("lowerDescription", (Object)OfBizGroupDao.toLowerCaseAllowNull(group.getDescription()));
        this.storeGroup(groupGenericValue);
        OfBizGroup ofBizGroup = OfBizGroup.from(groupGenericValue);
        this.groupCaseInsensitiveCache.refresh(ofBizGroup);
        return ofBizGroup;
    }

    private void storeGroup(GenericValue groupGenericValue) {
        if (groupGenericValue.get("description") != null && ((String)groupGenericValue.get("description")).length() > 255) {
            groupGenericValue.set("description", (Object)GroupEntity.truncateDescriptionIfRequired(groupGenericValue.getString("description")));
        }
        if (groupGenericValue.get("lowerDescription") != null && ((String)groupGenericValue.get("lowerDescription")).length() > 255) {
            groupGenericValue.set("lowerDescription", (Object)GroupEntity.truncateDescriptionIfRequired(groupGenericValue.getString("lowerDescription")));
        }
        this.ofBizDelegator.store(groupGenericValue);
    }

    public Group rename(Group group, String newName) {
        throw new UnsupportedOperationException("Renaming groups is not supported!");
    }

    public void storeAttributes(Group group, Map<String, Set<String>> attributes) throws GroupNotFoundException {
        for (Map.Entry attribute : ((Map)Assertions.notNull(attributes)).entrySet()) {
            this.removeAttribute(group, (String)attribute.getKey());
            if (attribute.getValue() == null || ((Set)attribute.getValue()).isEmpty()) continue;
            this.storeAttributeValues(group, (String)attribute.getKey(), (Set)attribute.getValue());
        }
    }

    private void storeAttributeValues(Group group, String name, Set<String> values) throws GroupNotFoundException {
        for (String value : values) {
            if (!StringUtils.isNotEmpty((String)value)) continue;
            this.storeAttributeValue(group, name, value);
        }
    }

    private void storeAttributeValue(Group group, String name, String value) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        this.ofBizDelegator.createValue("GroupAttribute", GroupAttributeEntity.getData(group.getDirectoryId(), groupGenericValue.getLong("id"), name, value));
    }

    public void removeAttribute(Group group, String attributeName) throws GroupNotFoundException {
        Assertions.notNull((Object)attributeName);
        GenericValue gv = this.findGroupGenericValue(group);
        this.ofBizDelegator.removeByAnd("GroupAttribute", PrimitiveMap.of("groupId", (long)gv.getLong("id"), "name", attributeName));
    }

    public void remove(Group group) throws GroupNotFoundException {
        GenericValue groupGenericValue = this.findGroupGenericValue(group);
        try {
            this.membershipDao.removeAllMembersFromGroup(group);
            this.membershipDao.removeAllGroupMemberships(group);
            this.ofBizDelegator.removeByAnd("GroupAttribute", PrimitiveMap.of("groupId", groupGenericValue.getLong("id")));
            this.ofBizDelegator.removeValue(groupGenericValue);
        }
        finally {
            this.groupCaseInsensitiveCache.remove(DirectoryEntityKey.getKeyLowerCase((DirectoryEntity)group));
        }
    }

    public <T> List<T> search(long directoryId, EntityQuery<T> query) {
        SearchRestriction searchRestriction = query.getSearchRestriction();
        EntityCondition baseCondition = new GroupEntityConditionFactory(this.ofBizDelegator).getEntityConditionFor(searchRestriction);
        EntityExpr directoryCondition = new EntityExpr("directoryId", EntityOperator.EQUALS, (Object)directoryId);
        ArrayList<Object> entityConditions = new ArrayList<Object>(2);
        if (baseCondition != null) {
            entityConditions.add(baseCondition);
        }
        entityConditions.add(directoryCondition);
        EntityConditionList entityCondition = new EntityConditionList(entityConditions, EntityOperator.AND);
        Function<GenericValue, T> valueFunction = this.getTransformer(query.getReturnType());
        List<T> results = Select.from("Group").whereCondition((EntityCondition)entityCondition).orderBy("groupName").limit(query.getStartIndex(), query.getMaxResults()).runWith(this.ofBizDelegator).asList(valueFunction);
        return results;
    }

    private <T> Function<GenericValue, T> getTransformer(Class<T> returnType) {
        if (returnType.equals(String.class)) {
            return TO_GROUPNAME_FUNCTION;
        }
        if (returnType.isAssignableFrom(OfBizGroup.class)) {
            return TO_GROUP_FUNCTION;
        }
        if (returnType.isAssignableFrom(GroupWithAttributes.class)) {
            return this.toGroupWithAttributesFunction;
        }
        throw new IllegalArgumentException("Class type for return values ('" + returnType + "') is not supported");
    }

    public BatchResult<String> removeAllGroups(long directoryId, Set<String> groupNames) {
        BatchResult results = new BatchResult(groupNames.size());
        for (String groupName : groupNames) {
            try {
                this.remove((Group)this.findByName(directoryId, groupName));
                results.addSuccess((Object)groupName);
            }
            catch (GroupNotFoundException e) {
                results.addFailure((Object)groupName);
            }
        }
        return results;
    }

    public void flushCache() {
        this.groupCaseInsensitiveCache.refresh();
    }

    private GenericValue findGroupGenericValue(Group group) throws GroupNotFoundException {
        return this.findGroupGenericValue(group.getDirectoryId(), group.getName());
    }

    GenericValue findGroupGenericValue(long directoryId, String name) throws GroupNotFoundException {
        Assertions.notNull((String)"name", (Object)name);
        GenericValue groupGenericValue = (GenericValue)Select.from("Group").whereEqual("directoryId", directoryId).andEqual("lowerGroupName", IdentifierUtils.toLowerCase((String)name)).runWith(this.ofBizDelegator).singleValue();
        if (groupGenericValue == null) {
            throw new GroupNotFoundException(name);
        }
        return groupGenericValue;
    }

    @Nullable
    private static String toLowerCaseAllowNull(String value) {
        return value != null ? IdentifierUtils.toLowerCase((String)value) : null;
    }

    private static Timestamp getCurrentTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }
}

