/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.crowd.event.directory.DirectoryDeletedEvent;
import com.atlassian.crowd.event.migration.XMLRestoreFinishedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizApplicationDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizGroupDao;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizInternalMembershipDao;
import com.atlassian.jira.event.ClearCacheEvent;

public final class OfBizCacheFlushingManager {
    private final OfBizCacheFlushingManagerListener ofBizCacheFlushingManagerListener;

    public OfBizCacheFlushingManager(EventPublisher eventPublisher, ExtendedUserDao ofBizUserDao, OfBizDirectoryDao ofBizDirectoryDao, OfBizGroupDao ofBizGroupDao, OfBizInternalMembershipDao ofBizInternalMembershipDao, OfBizApplicationDao ofBizApplicationDao) {
        this.ofBizCacheFlushingManagerListener = new OfBizCacheFlushingManagerListener(ofBizUserDao, ofBizDirectoryDao, ofBizGroupDao, ofBizInternalMembershipDao, ofBizApplicationDao);
        eventPublisher.register((Object)this.ofBizCacheFlushingManagerListener);
    }

    public void flushCaches() {
        this.ofBizCacheFlushingManagerListener.flushAllCaches();
    }

    public static final class OfBizCacheFlushingManagerListener {
        private final ExtendedUserDao ofBizUserDao;
        private final OfBizDirectoryDao ofBizDirectoryDao;
        private final OfBizGroupDao ofBizGroupDao;
        private final OfBizInternalMembershipDao ofBizInternalMembershipDao;
        private final OfBizApplicationDao ofBizApplicationDao;

        private OfBizCacheFlushingManagerListener(ExtendedUserDao ofBizUserDao, OfBizDirectoryDao ofBizDirectoryDao, OfBizGroupDao ofBizGroupDao, OfBizInternalMembershipDao ofBizInternalMembershipDao, OfBizApplicationDao ofBizApplicationDao) {
            this.ofBizUserDao = ofBizUserDao;
            this.ofBizDirectoryDao = ofBizDirectoryDao;
            this.ofBizGroupDao = ofBizGroupDao;
            this.ofBizInternalMembershipDao = ofBizInternalMembershipDao;
            this.ofBizApplicationDao = ofBizApplicationDao;
        }

        @EventListener
        public void onEvent(XMLRestoreFinishedEvent event) {
            this.flushAllCaches();
        }

        @EventListener
        public void onEvent(DirectoryDeletedEvent event) {
            this.flushAllCaches();
        }

        @EventListener
        public void onEvent(ClearCacheEvent event) {
            this.flushAllCaches();
        }

        private void flushAllCaches() {
            this.ofBizApplicationDao.flushCache();
            this.ofBizDirectoryDao.flushCache();
            this.ofBizUserDao.flushCache();
            this.ofBizGroupDao.flushCache();
            this.ofBizInternalMembershipDao.flushCache();
        }
    }
}

