/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.crowd.embedded.ofbiz;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.crowd.dao.application.ApplicationDAO;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationImpl;
import com.atlassian.crowd.model.application.RemoteAddress;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.ApplicationTermKeys;
import com.atlassian.jira.cache.request.RequestCacheController;
import com.atlassian.jira.crowd.embedded.ofbiz.ApplicationEntity;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizApplication;
import com.atlassian.jira.crowd.embedded.ofbiz.OfBizDirectoryDao;
import com.atlassian.jira.crowd.embedded.ofbiz.PrimitiveMap;
import com.atlassian.jira.crowd.embedded.ofbiz.RemoteAddressEntity;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfBizApplicationDao
implements ApplicationDAO {
    @VisibleForTesting
    private final OfBizDelegator ofBizDelegator;
    private final OfBizDirectoryDao directoryDao;
    private final CachedReference<List<Application>> applicationCache;

    public OfBizApplicationDao(OfBizDelegator ofBizDelegator, OfBizDirectoryDao directoryDao, CacheManager cacheManager) {
        this.ofBizDelegator = ofBizDelegator;
        this.directoryDao = directoryDao;
        this.applicationCache = this.buildReference(cacheManager);
    }

    private CachedReference<List<Application>> buildReference(CacheManager cacheManager) {
        return cacheManager.getCachedReference(OfBizApplicationDao.class, "applicationCache", (Supplier)new Supplier<List<Application>>(){

            public List<Application> get() {
                return OfBizApplicationDao.this.getAllApplications();
            }
        });
    }

    private Application buildApplication(GenericValue applicationGenericValue) {
        List<GenericValue> remoteAddressesGenericValue = this.findRemoteAddresses(applicationGenericValue.getLong("id"));
        OfBizApplication ofBizApplication = OfBizApplication.from(applicationGenericValue, remoteAddressesGenericValue);
        ofBizApplication.setDirectoryDao(this.directoryDao);
        return ofBizApplication;
    }

    public void updateCredential(Application application, PasswordCredential passwordCredential) throws ApplicationNotFoundException {
        Validate.notNull((Object)application);
        Validate.notNull((Object)passwordCredential);
        if (passwordCredential.getCredential() != null) {
            Validate.isTrue((boolean)passwordCredential.isEncryptedCredential(), (String)"credential must be encrypted");
        }
        GenericValue gv = this.findApplicationById(application.getId());
        gv.set("credential", (Object)passwordCredential.getCredential());
        gv.set("updatedDate", (Object)new Timestamp(System.currentTimeMillis()));
        this.ofBizDelegator.store(gv);
        this.applicationCache.reset();
    }

    public void addRemoteAddress(long applicationId, RemoteAddress remoteAddress) {
        GenericValue gv = this.ofBizDelegator.makeValue("RemoteAddress", RemoteAddressEntity.getData(applicationId, remoteAddress.getAddress()));
        try {
            gv.create();
            this.ofBizDelegator.store(gv);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.applicationCache.reset();
    }

    public void removeRemoteAddress(long applicationId, RemoteAddress remoteAddress) {
        this.ofBizDelegator.removeByAnd("RemoteAddress", PrimitiveMap.of("applicationId", applicationId, "address", remoteAddress.getAddress()));
        this.applicationCache.reset();
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, int position) throws DirectoryNotFoundException {
        this.directoryDao.updateDirectoryPosition(directoryId, position);
        RequestCacheController.clearAll();
    }

    public Application findById(long id) throws ApplicationNotFoundException {
        for (Application application : (List)this.applicationCache.get()) {
            if (application.getId() != id) continue;
            return application;
        }
        throw new ApplicationNotFoundException(Long.valueOf(id));
    }

    public Application findByName(String name) throws ApplicationNotFoundException {
        Optional<Application> application = this.findApplicationSafely(name);
        return application.orElseThrow(() -> new ApplicationNotFoundException(name));
    }

    private Optional<Application> findApplicationSafely(String name) {
        for (Application application : (List)this.applicationCache.get()) {
            if (!application.getName().equals(name)) continue;
            return Optional.of(application);
        }
        return Optional.empty();
    }

    public Application add(Application application, PasswordCredential credential) {
        long applicationId;
        try {
            if (credential != null) {
                Validate.isTrue((boolean)credential.isEncryptedCredential(), (String)"credential must be encrypted");
            }
            ApplicationImpl applicationToSave = ApplicationImpl.newInstance((Application)application);
            applicationToSave.setCredential(credential);
            applicationToSave.setCreatedDateToNow();
            applicationToSave.setUpdatedDateToNow();
            Map<String, Object> map = ApplicationEntity.getData((Application)applicationToSave);
            this.ofBizDelegator.createValue("Application", map);
            GenericValue applicationGenericValue = EntityUtil.getOnly(this.findApplications(PrimitiveMap.caseInsensitive("lowerName", application.getName())));
            applicationId = applicationGenericValue.getLong("id");
            for (RemoteAddress remoteAddress : application.getRemoteAddresses()) {
                GenericValue genericValue = this.ofBizDelegator.makeValue("RemoteAddress", RemoteAddressEntity.getData(applicationId, remoteAddress.getAddress()));
                genericValue.create();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.flushCache();
        try {
            return this.findById(applicationId);
        }
        catch (ApplicationNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private GenericValue findApplicationById(Long id) throws ApplicationNotFoundException {
        try {
            GenericValue applicationGenericValue = EntityUtil.getOnly(this.findApplications(PrimitiveMap.of("id", id)));
            if (applicationGenericValue != null) {
                return applicationGenericValue;
            }
            throw new ApplicationNotFoundException(id);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<GenericValue> findApplications(Map<String, Object> filter) throws GenericEntityException {
        return this.ofBizDelegator.findByAnd("Application", filter);
    }

    private List<GenericValue> findRemoteAddresses(long applicationId) {
        return this.ofBizDelegator.findByAnd("RemoteAddress", PrimitiveMap.of("applicationId", applicationId));
    }

    private List<Application> getAllApplications() {
        ImmutableList.Builder applications = ImmutableList.builder();
        List applicationGenericValues = this.ofBizDelegator.findByAnd("Application", Collections.emptyMap());
        for (GenericValue applicationGenericValue : applicationGenericValues) {
            applications.add((Object)this.buildApplication(applicationGenericValue));
        }
        return applications.build();
    }

    public void flushCache() {
        this.applicationCache.reset();
    }

    public Application add(Application application) {
        return this.add(application, null);
    }

    public Application update(Application application) throws ApplicationNotFoundException {
        Validate.notNull((Object)application);
        GenericValue gv = this.findApplicationById(application.getId());
        ApplicationEntity.setData(application, gv);
        this.ofBizDelegator.store(gv);
        this.ofBizDelegator.removeByAnd("RemoteAddress", PrimitiveMap.of("applicationId", application.getId()));
        try {
            for (RemoteAddress remoteAddress : application.getRemoteAddresses()) {
                GenericValue genericValue = this.ofBizDelegator.makeValue("RemoteAddress", RemoteAddressEntity.getData(application.getId(), remoteAddress.getAddress()));
                genericValue.create();
            }
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.applicationCache.reset();
        return application;
    }

    public void remove(Application application) {
        this.ofBizDelegator.removeByAnd("RemoteAddress", PrimitiveMap.of("applicationId", application.getId()));
        this.ofBizDelegator.removeByAnd("Application", PrimitiveMap.of("id", application.getId()));
        this.applicationCache.reset();
    }

    public List<Application> search(EntityQuery<Application> entityQuery) {
        TermRestriction termRestriction;
        SearchRestriction searchRestriction = entityQuery.getSearchRestriction();
        if (searchRestriction instanceof TermRestriction && (termRestriction = (TermRestriction)searchRestriction).getMatchMode() == MatchMode.EXACTLY_MATCHES && termRestriction.getProperty().equals(ApplicationTermKeys.NAME) && entityQuery.getMaxResults() == 1) {
            Optional<Application> application = this.findApplicationSafely(String.valueOf(termRestriction.getValue().toString()));
            return application.map(Collections::singletonList).orElse(Collections.emptyList());
        }
        return (List)this.applicationCache.get();
    }

    public void addDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, OperationType ... operationTypes) {
        throw new UnsupportedOperationException("Not Supported by the Crowd Embedded API");
    }

    public void removeDirectoryMapping(long applicationId, long directoryId) throws ApplicationNotFoundException {
    }

    public void removeDirectoryMappings(long directoryId) {
    }

    public void addGroupMapping(long applicationId, long directoryId, String groupName) {
        throw new UnsupportedOperationException("Not Supported by the Crowd Embedded API");
    }

    public void removeGroupMapping(long applicationId, long directoryId, String groupName) {
    }

    public void removeGroupMappings(long directoryId, String groupName) {
    }

    public void renameGroupMappings(long directoryId, String oldGroupName, String newGroupName) {
        throw new UnsupportedOperationException("Not Supported by the Crowd Embedded API");
    }

    public List<Application> findAuthorisedApplications(long directoryId, List<String> groupNames) {
        throw new UnsupportedOperationException("Not Supported by the Crowd Embedded API");
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate) {
        throw new UnsupportedOperationException("Not Supported by the Crowd Embedded API");
    }

    public void updateDirectoryMapping(long applicationId, long directoryId, boolean allowAllToAuthenticate, Set<OperationType> operationTypes) {
        throw new UnsupportedOperationException("Not Supported by the Crowd Embedded API");
    }
}

