/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterInfo;
import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.MessageHandlerService;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateDao;
import com.atlassian.jira.cluster.zdu.ClusterUpgradeStateManager;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.cluster.zdu.NodeBuildInfo;
import com.atlassian.jira.cluster.zdu.NodeBuildInfoFactory;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.event.JiraDelayedUpgradeCompletedEvent;
import com.atlassian.jira.extension.JiraStartedEvent;
import com.atlassian.jira.model.querydsl.ClusterUpgradeStateDTO;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventComponent
public class DefaultClusterUpgradeStateManager
implements ClusterUpgradeStateManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultClusterUpgradeStateManager.class);
    private static final String CLUSTER_UPGRADE_TATE_LOCK_NAME = DefaultClusterUpgradeStateManager.class.getName() + ".clusterUpgradeState";
    private static final Runnable DO_NOTHING = () -> {};
    private static final EnumSet<UpgradeState> AUTO_TRANSITION_STATES = EnumSet.of(UpgradeState.MIXED, UpgradeState.READY_TO_UPGRADE, UpgradeState.READY_TO_RUN_UPGRADE_TASKS);
    private final ClusterManager clusterManager;
    private final ClusterLock lock;
    private final ClusterUpgradeStateDao clusterUpgradeStateDao;
    private final ClusterInfo clusterInfo;
    private final EventPublisher eventPublisher;
    private final FeatureManager featureManager;
    private final MessageHandlerService messageHandlerService;
    private final NodeBuildInfoFactory nodeBuildInfoFactory;

    public DefaultClusterUpgradeStateManager(ClusterManager clusterManager, ClusterLockService clusterLockService, ClusterUpgradeStateDao clusterUpgradeStateDao, ClusterInfo clusterInfo, EventPublisher eventPublisher, FeatureManager featureManager, MessageHandlerService messageHandlerService, NodeBuildInfoFactory nodeBuildInfoFactory) {
        this.clusterManager = clusterManager;
        this.lock = clusterLockService.getLockForName(CLUSTER_UPGRADE_TATE_LOCK_NAME);
        this.clusterUpgradeStateDao = clusterUpgradeStateDao;
        this.clusterInfo = clusterInfo;
        this.eventPublisher = eventPublisher;
        this.featureManager = featureManager;
        this.messageHandlerService = messageHandlerService;
        this.nodeBuildInfoFactory = nodeBuildInfoFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startUpgrade() {
        Runnable actionsAfterLockDropped;
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.getDatabaseUpgradeState();
            if (upgradeState != UpgradeState.STABLE) {
                throw new IllegalStateException("Can only transition to " + UpgradeState.READY_TO_UPGRADE + " from " + UpgradeState.STABLE + " but was in " + upgradeState);
            }
            NodeBuildInfo nodeBuildInfo = this.getNodeBuildInfo();
            this.setUpgradeState(nodeBuildInfo, UpgradeState.READY_TO_UPGRADE);
            actionsAfterLockDropped = () -> {
                this.eventPublisher.publish((Object)new JiraUpgradeStartedEvent(nodeBuildInfo));
                this.notifyCluster(UpgradeState.READY_TO_UPGRADE);
            };
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelUpgrade() {
        Runnable actionsAfterLockDropped;
        this.recalculateState();
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.getDatabaseUpgradeState();
            NodeBuildInfo clusterBuildInfo = this.getClusterBuildInfo();
            switch (upgradeState) {
                case READY_TO_UPGRADE: {
                    this.setUpgradeState(clusterBuildInfo, UpgradeState.STABLE);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cluster can not be rolled back to stable state until upgrade is completed. Current state is [%s]", upgradeState));
                }
            }
            actionsAfterLockDropped = () -> {
                this.eventPublisher.publish((Object)new JiraUpgradeCancelledEvent(clusterBuildInfo));
                this.notifyCluster(UpgradeState.STABLE);
            };
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @Override
    public void approveUpgrade() {
        Runnable actionsAfterLockDropped;
        this.recalculateState();
        this.lock.lock();
        try {
            UpgradeState upgradeState = this.getDatabaseUpgradeState();
            if (upgradeState != UpgradeState.READY_TO_RUN_UPGRADE_TASKS) {
                throw new IllegalStateException(String.format("Cluster not ready to run upgrade tasks yet, because it in [%s] state", upgradeState));
            }
            actionsAfterLockDropped = () -> this.eventPublisher.publish((Object)new JiraUpgradeApprovedEvent(this.getClusterBuildInfo(), this.getNodeBuildInfo()));
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void runUpgrade() {
        this.lock.lock();
        try {
            upgradeState = this.getDatabaseUpgradeState();
            switch (1.$SwitchMap$com$atlassian$jira$cluster$zdu$UpgradeState[upgradeState.ordinal()]) {
                case 2: {
                    this.setUpgradeState(this.getClusterBuildInfo(), UpgradeState.RUNNING_UPGRADE_TASKS);
                    ** break;
lbl8:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Cluster not ready to run upgrade tasks yet, because it in [%s] state", new Object[]{upgradeState}));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.notifyCluster(UpgradeState.RUNNING_UPGRADE_TASKS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onJiraUpgradeCompleted(JiraDelayedUpgradeCompletedEvent event) {
        Runnable actionsAfterLockDropped;
        this.lock.lock();
        try {
            UpgradeState currentUpgradeState = this.getDatabaseUpgradeState();
            NodeBuildInfo nodeBuildInfo = this.getNodeBuildInfo();
            NodeBuildInfo clusterBuildInfo = this.getClusterBuildInfo();
            if (currentUpgradeState == UpgradeState.RUNNING_UPGRADE_TASKS) {
                this.setUpgradeState(nodeBuildInfo, UpgradeState.STABLE);
                actionsAfterLockDropped = () -> {
                    this.eventPublisher.publish((Object)new JiraUpgradeFinishedEvent(clusterBuildInfo, nodeBuildInfo));
                    this.notifyCluster(UpgradeState.STABLE);
                };
            } else {
                log.warn("Unexpected JiraUpgradedEvent. Cluster wasn't in RUNNING_UPGRADE_TASKS state");
                actionsAfterLockDropped = DO_NOTHING;
            }
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @EventListener
    public void updateState(JiraStartedEvent event) {
        this.recalculateState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalculateState() {
        Runnable actionsAfterLockDropped;
        this.lock.lock();
        try {
            UpgradeState currentUpgradeState = this.getDatabaseUpgradeState();
            if (AUTO_TRANSITION_STATES.contains(currentUpgradeState)) {
                Object targetUpgradeState;
                this.clusterManager.refreshLiveNodes();
                Set buildNumbers = this.clusterManager.findLiveNodes().stream().map(this.nodeBuildInfoFactory::create).filter(Objects::nonNull).collect(Collectors.toSet());
                if (buildNumbers.isEmpty()) {
                    if (this.clusterInfo.isClustered()) {
                        log.warn("No cluster node entries, cannot determine upgrade state transition.");
                        targetUpgradeState = null;
                    } else {
                        targetUpgradeState = Objects.equals(this.getNodeBuildInfo(), this.getClusterBuildInfo()) ? null : UpgradeState.READY_TO_RUN_UPGRADE_TASKS;
                    }
                } else if (buildNumbers.size() > 1) {
                    targetUpgradeState = UpgradeState.MIXED;
                } else {
                    NodeBuildInfo nodesBuildNumber = (NodeBuildInfo)buildNumbers.iterator().next();
                    NodeBuildInfo clusterBuildNumber = this.getClusterBuildInfo();
                    targetUpgradeState = clusterBuildNumber.equals(nodesBuildNumber) ? UpgradeState.READY_TO_UPGRADE : UpgradeState.READY_TO_RUN_UPGRADE_TASKS;
                }
                if (targetUpgradeState != null && targetUpgradeState != currentUpgradeState) {
                    log.info("Transitioning cluster upgrade state from " + currentUpgradeState + " to " + targetUpgradeState);
                    this.setUpgradeState(this.getClusterBuildInfo(), (UpgradeState)targetUpgradeState);
                    actionsAfterLockDropped = () -> this.lambda$recalculateState$5((UpgradeState)targetUpgradeState);
                } else {
                    actionsAfterLockDropped = DO_NOTHING;
                }
            } else {
                actionsAfterLockDropped = DO_NOTHING;
            }
        }
        finally {
            this.lock.unlock();
        }
        actionsAfterLockDropped.run();
    }

    @Nonnull
    public UpgradeState getUpgradeState() {
        if (!this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state")) {
            return UpgradeState.STABLE;
        }
        this.recalculateState();
        return this.getDatabaseUpgradeState();
    }

    private UpgradeState getDatabaseUpgradeState() {
        Optional<ClusterUpgradeStateDTO> currentState = this.clusterUpgradeStateDao.getCurrent();
        return currentState.map(ClusterUpgradeStateDTO::getState).map(UpgradeState::valueOf).orElse(UpgradeState.STABLE);
    }

    @Override
    public NodeBuildInfo getClusterBuildInfo() {
        if (!this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state")) {
            return this.getNodeBuildInfo();
        }
        Optional<ClusterUpgradeStateDTO> currentState = this.clusterUpgradeStateDao.getCurrent();
        return currentState.map(this.nodeBuildInfoFactory::create).orElse(this.getNodeBuildInfo());
    }

    private NodeBuildInfo getNodeBuildInfo() {
        return this.nodeBuildInfoFactory.currentApplicationInfo();
    }

    private void setUpgradeState(NodeBuildInfo nodeBuildInfo, @Nonnull UpgradeState upgradeState) {
        this.clusterUpgradeStateDao.writeState(nodeBuildInfo, upgradeState);
    }

    private void notifyCluster(UpgradeState upgradeState) {
        this.messageHandlerService.sendRemote("Upgrade State", upgradeState.toString());
    }

    @Override
    public boolean areDelayedUpgradesHandledByCluster() {
        boolean isClusterUpgradeStateDarkFeatureEnabled = this.featureManager.isEnabled("jira.zdu.cluster-upgrade-state");
        if (isClusterUpgradeStateDarkFeatureEnabled) {
            return this.getUpgradeState() != UpgradeState.STABLE;
        }
        return false;
    }

    private /* synthetic */ void lambda$recalculateState$5(UpgradeState targetUpgradeState) {
        this.notifyCluster(targetUpgradeState);
    }
}

