/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.zdu;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.EventComponent;
import com.atlassian.jira.cluster.ClusterMessageConsumer;
import com.atlassian.jira.cluster.ClusterMessagingService;
import com.atlassian.jira.cluster.zdu.JiraUpgradeApprovedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeCancelledEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeFinishedEvent;
import com.atlassian.jira.cluster.zdu.JiraUpgradeStartedEvent;
import com.atlassian.jira.cluster.zdu.UpgradeState;
import com.atlassian.jira.config.properties.JiraProperties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@EventComponent
public class ClusterUpgradeLogger
implements ClusterMessageConsumer {
    private static final Logger log = Logger.getLogger(ClusterUpgradeLogger.class);
    private final ClusterMessagingService messagingService;
    private final JiraProperties jiraProperties;

    public ClusterUpgradeLogger(ClusterMessagingService messagingService, JiraProperties jiraProperties) {
        this.messagingService = messagingService;
        this.jiraProperties = jiraProperties;
        this.messagingService.registerListener("Upgrade State", (ClusterMessageConsumer)this);
    }

    private String formatBigMessage(String message) {
        String newLine = this.jiraProperties.getProperty("line.separator");
        String starLine = StringUtils.repeat((String)"*", (int)message.length());
        return newLine + newLine + starLine + newLine + message + newLine + starLine + newLine;
    }

    void logClusterUpgradeState(String upgradeState) {
        log.info((Object)this.formatBigMessage("Cluster upgrade state changed to " + upgradeState));
    }

    void logClusterUpgradeState(String upgradeState, String senderId) {
        log.info((Object)this.formatBigMessage("Cluster upgrade state changed to " + upgradeState + " (sender: " + senderId + ")"));
    }

    @EventListener
    public void onUpgradeStarted(JiraUpgradeStartedEvent event) {
        this.logClusterUpgradeState(UpgradeState.READY_TO_UPGRADE.toString());
    }

    @EventListener
    public void onUpgradeApproved(JiraUpgradeApprovedEvent event) {
        this.logClusterUpgradeState(UpgradeState.RUNNING_UPGRADE_TASKS.toString());
    }

    @EventListener
    public void onUpgradeFinished(JiraUpgradeFinishedEvent event) {
        this.logClusterUpgradeState(UpgradeState.STABLE.toString());
    }

    @EventListener
    public void onUpgradeCancelled(JiraUpgradeCancelledEvent event) {
        this.logClusterUpgradeState(UpgradeState.STABLE.toString());
    }

    public void receive(String channel, String message, String senderId) {
        this.logClusterUpgradeState(message, senderId);
    }
}

