/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.monitoring;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.cluster.monitoring.ClusterNodeStatus;
import com.google.common.annotations.VisibleForTesting;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterMonitoringBeansRegistrar {
    public static final String CLUSTER_MONITORING_DARK_FEATURE = "jira.zdu.jmx-monitoring";
    private static final Logger LOG = LoggerFactory.getLogger(ClusterMonitoringBeansRegistrar.class);
    private final MBeanServer mBeanServer;

    public ClusterMonitoringBeansRegistrar() {
        this(ManagementFactory.getPlatformMBeanServer());
    }

    @VisibleForTesting
    ClusterMonitoringBeansRegistrar(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public void registerClusterMonitoringMBeans() {
        this.registerMBean("com.atlassian.jira.cluster.monitoring:type=ClusterNodeStatus", ClusterNodeStatus.class);
    }

    public void unregisterClusterMonitorMBeans() {
        this.unregisterMBean("com.atlassian.jira.cluster.monitoring:type=ClusterNodeStatus");
    }

    private void registerMBean(String objectName, Class<?> implementationClass) {
        try {
            ObjectName beanName = this.getObjectName(objectName);
            if (this.mBeanServer.isRegistered(beanName)) {
                LOG.debug(objectName + " is already registered, skipping...");
                return;
            }
            this.mBeanServer.registerMBean(ComponentManager.getComponent(implementationClass), beanName);
            LOG.debug("Registered monitoring bean " + beanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            LOG.warn("Unable to register monitoring bean: " + objectName, (Throwable)e);
        }
    }

    private void unregisterMBean(String objectName) {
        ObjectName beanName = this.getObjectName(objectName);
        try {
            this.mBeanServer.unregisterMBean(beanName);
            LOG.debug("Unregistered monitoring bean " + beanName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            LOG.error("Unable to unregister monitoring bean " + beanName, (Throwable)e);
        }
    }

    private ObjectName getObjectName(String beanName) {
        try {
            return new ObjectName(beanName);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Unable to name monitoring bean", e);
        }
    }
}

