/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.cluster.lock;

import com.atlassian.beehive.db.AbstractClusterNodeHeartbeatService;
import com.atlassian.beehive.db.spi.ClusterNodeHeartBeatDao;
import com.atlassian.core.util.Clock;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.lock.NodeSharedHomeStatus;
import com.atlassian.jira.cluster.lock.SharedHomeNodeStatusWriter;
import com.atlassian.jira.event.cluster.HeartbeatEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class StartableClusterNodeHeartbeatService
extends AbstractClusterNodeHeartbeatService
implements Startable {
    private static final String SHARED_HOME_FILE_WRITER_JOB_RUNNER_KEY_NAME = StartableClusterNodeHeartbeatService.class.getName() + ".sharedHomeFileWriter";
    private static final JobRunnerKey SHARED_HOME_FILE_WRITER_JOB_RUNNER_KEY = JobRunnerKey.of((String)SHARED_HOME_FILE_WRITER_JOB_RUNNER_KEY_NAME);
    private final SchedulerService schedulerService;
    private final SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter;
    private final Clock clock;
    private final EventPublisher eventPublisher;

    public StartableClusterNodeHeartbeatService(ClusterNodeHeartBeatDao clusterNodeHeartBeatDao, SchedulerService schedulerService, SharedHomeNodeStatusWriter sharedHomeNodeStatusWriter, Clock clock, EventPublisher eventPublisher) {
        super(clusterNodeHeartBeatDao, schedulerService);
        this.schedulerService = schedulerService;
        this.sharedHomeNodeStatusWriter = sharedHomeNodeStatusWriter;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.startHeartbeat();
    }

    protected void startHeartbeat() throws SchedulerServiceException {
        super.startHeartbeat();
        SharedHomeFileWriterJobRunner runner = new SharedHomeFileWriterJobRunner();
        runner.writeFile();
        this.schedulerService.registerJobRunner(SHARED_HOME_FILE_WRITER_JOB_RUNNER_KEY, (JobRunner)runner);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)SHARED_HOME_FILE_WRITER_JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)TimeUnit.MINUTES.toMillis(1L), null));
        this.schedulerService.scheduleJob(JobId.of((String)SHARED_HOME_FILE_WRITER_JOB_RUNNER_KEY_NAME), jobConfig);
    }

    protected JobRunner newHeartbeatJobRunner() {
        JobRunner original = super.newHeartbeatJobRunner();
        return request -> {
            JobRunnerResponse result = original.runJob(request);
            this.eventPublisher.publish((Object)HeartbeatEvent.INSTANCE);
            return result;
        };
    }

    private class SharedHomeFileWriterJobRunner
    implements JobRunner {
        private SharedHomeFileWriterJobRunner() {
        }

        @Nullable
        public JobRunnerResponse runJob(JobRunnerRequest request) {
            this.writeFile();
            return JobRunnerResponse.success();
        }

        private void writeFile() {
            long now = StartableClusterNodeHeartbeatService.this.clock.getCurrentDate().getTime();
            NodeSharedHomeStatus status = new NodeSharedHomeStatus(StartableClusterNodeHeartbeatService.this.getNodeId(), now);
            StartableClusterNodeHeartbeatService.this.sharedHomeNodeStatusWriter.writeNodeStatus(status);
        }
    }
}

